/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.kanbanpedidos;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.DownloadDialog;
import br.com.system.app.components.MultiComboBox;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.repository.projection.HierarquiaDTO;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.kanbanpedidos.model.KanbanPedidos;
import br.com.system.app.features.kanbanpedidos.service.KanbanPedidosService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.layout.size.FontSize;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.model.PedidoEtapa;
import br.com.system.app.features.pedido.service.PedidoEtapaService;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.Collection;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.CrudOperation;
import org.vaadin.crudui.crud.impl.GridCrud;

@Route(value="kanban-config", layout=MainLayout.class)
@PageTitle(value="Kanban Config")
@RolesAllowed(value={"MASTER"})
public class KanbanConfigView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final KanbanPedidosService kanbanService;
    private final EstruturaUsuarioService eus;
    private final UsuarioHierarquiaService hierarquiaService;
    private final PedidoEtapaService pedidoEtapaService;
    private GridCrud<KanbanPedidos> crud;
    private RadioButtonGroup<PedidoTipoEnum> rbTipo;
    private RadioButtonGroup<String> rbAtivo;
    private DownloadDialog dd;

    public KanbanConfigView(KanbanPedidosService kanbanService, EstruturaUsuarioService eus, PedidoEtapaService pedidoEtapaService, UsuarioHierarquiaService hierarquiaService) {
        this.kanbanService = kanbanService;
        this.hierarquiaService = hierarquiaService;
        this.eus = eus;
        this.pedidoEtapaService = pedidoEtapaService;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado() && this.isMaster()) {
            this.setViewContent(this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private Component createContent() {
        this.dd = new DownloadDialog();
        this.rbTipo = new RadioButtonGroup();
        this.rbTipo.setItems((Object[])PedidoTipoEnum.values());
        this.rbTipo.setValue((Object)PedidoTipoEnum.COMERCIAL);
        this.rbTipo.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.crud.refreshGrid());
        this.rbAtivo = new RadioButtonGroup("Situa\u00e7\u00e3o Usu\u00e1rio");
        this.rbAtivo.setItems((Object[])new String[]{"Ativo", "Inativo"});
        this.rbAtivo.setValue((Object)"Ativo");
        this.rbAtivo.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.crud.refreshGrid());
        UIUtils.setFontSize((FontSize)FontSize.XXS, (Component[])new Component[]{this.rbTipo, this.rbAtivo});
        this.crud = new GridCrud(KanbanPedidos.class);
        TextField filterUsuario = new TextField("Filtrar Usu\u00e1rio");
        filterUsuario.setWidth("200px");
        TextField filterEtapa = new TextField("Filtrar Etapa");
        filterEtapa.setWidth("200px");
        Button btnAdicionar = UIUtils.createSmallButton((String)"Adicionar", (VaadinIcon)VaadinIcon.PLUS, (String)"Adicionar Kanban");
        btnAdicionar.setEnabled(this.hasPermission("KANBAN_CONFIG_SAVE"));
        btnAdicionar.addClickListener((ComponentEventListener & Serializable)e -> this.addDialog());
        Button btnExport = UIUtils.createSmallButton((String)"Exportar", (VaadinIcon)VaadinIcon.TABLE, (String)"Exportar dados de kanban");
        btnExport.addClickListener((ComponentEventListener & Serializable)e -> this.dd.open(this.kanbanService.export(this.getEstrutura()), "Exportacao-dados-kanban.xlsx", true));
        Button btnDel = UIUtils.createSmallButton((String)"Excluir Selecionados", (VaadinIcon)VaadinIcon.TRASH, (String)"Excluir todos os selecionados");
        btnDel.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.crud.getGrid().getSelectedItems().size() <= 0) {
                this.showNotification("Selecione pelo menos 1 para excluir");
                return;
            }
            ConfirmationDialog cd = new ConfirmationDialog("Excluir", "COnfirma a exclus\u00e3o de " + this.crud.getGrid().getSelectedItems().size() + " filas de kanban?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)can -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                cd.close();
                this.kanbanService.delete(this.crud.getGrid().getSelectedItems());
                this.showNotification("Deletados com sucesso");
                this.crud.refreshGrid();
            });
        });
        Button btnMulti = UIUtils.createSmallButton((String)"Habilitar Multi");
        btnMulti.setVisible(this.isMaster());
        btnMulti.addClickListener((ComponentEventListener & Serializable)e -> {
            if (btnMulti.getText().equals("Habilitar Multi")) {
                this.crud.getGrid().setSelectionMode(Grid.SelectionMode.MULTI);
                btnMulti.setText("Desabilitar Multi");
            } else {
                this.crud.getGrid().setSelectionMode(Grid.SelectionMode.SINGLE);
                btnMulti.setText("Habilitar Multi");
            }
        });
        Button btnZerar = UIUtils.createSmallButton((String)"ZERAR KANBAN", (String)"Zera TODAS AS FILAS DO KANBAN DA ESTRUTURA");
        btnZerar.setVisible(this.isMaster());
        btnZerar.addClickListener((ComponentEventListener & Serializable)e -> {
            ConfirmationDialog cd = new ConfirmationDialog("Excluir", "COnfirma a exclus\u00e3o de TODAS as filas do kanban de TODOS os usu\u00e1rios desta estrutura?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)can -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                cd.close();
                this.kanbanService.delete(this.crud.getGrid().getSelectedItems());
                this.showNotification("Deletados com sucesso");
                this.crud.refreshGrid();
            });
        });
        this.crud.getAddButton().setText("Adicionar");
        this.crud.getCrudLayout().addToolbarComponent((Component)new HorizontalContainer(new Component[]{btnAdicionar, btnExport, btnDel, btnMulti, btnZerar}));
        this.crud.getGrid().setColumns(new String[0]);
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getEstruturaUsuario().getUsuario().getNome()))).setHeader("Usu\u00e1rio").setFlexGrow(0).setWidth("250px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getEstruturaUsuario().getUsuario().getLogin()))).setHeader("Login").setFlexGrow(0).setWidth("250px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getPedidoEtapa().getNome()))).setHeader("Etapa").setFlexGrow(0).setWidth("250px");
        this.crud.getGrid().addColumn("position").setHeader("Posi\u00e7\u00e3o").setFlexGrow(0).setWidth("160px");
        this.crud.getCrudFormFactory().setUseBeanValidation(true);
        this.crud.getCrudFormFactory().setVisibleProperties(CrudOperation.UPDATE, new String[]{"position"});
        this.crud.getCrudFormFactory().setVisibleProperties(CrudOperation.DELETE, new String[]{"id", "position"});
        this.crud.getAddButton().setVisible(false);
        this.crud.getUpdateButton().setVisible(this.hasPermission("KANBAN_CONFIG_SAVE"));
        this.crud.getDeleteButton().setVisible(this.hasPermission("KANBAN_CONFIG_DELETE"));
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        this.crud.setWidthFull();
        this.crud.setHeightFull();
        filterUsuario.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.crud.refreshGrid());
        filterEtapa.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.crud.refreshGrid());
        HorizontalContainer filter = new HorizontalContainer(new Component[]{filterUsuario, this.rbTipo, filterEtapa, this.rbAtivo});
        VerticalContainer cGrid = new VerticalContainer(new Component[]{this.crud});
        cGrid.setWidth("100%");
        cGrid.setHeight("100%");
        VerticalContainer main = new VerticalContainer(new Component[]{filter, cGrid});
        main.setWidthFull();
        main.setHeightFull();
        return main;
    }

    private void addDialog() {
        Dialog dialog = new Dialog();
        dialog.setWidth("400px");
        MultiComboBox cbUsuario = new MultiComboBox("Usuario", (Collection)this.hierarquiaService.getHierarquiaDto(this.getEu(), Boolean.TRUE));
        cbUsuario.setItemLabelGenerator(HierarquiaDTO::getLoginAndPerfil);
        cbUsuario.setWidth("400px");
        MultiComboBox cbEtapa = new MultiComboBox("Fila", (Collection)this.pedidoEtapaService.getAtivos(this.getEstrutura(), (PedidoTipoEnum)this.rbTipo.getValue()));
        cbEtapa.setItemLabelGenerator(PedidoEtapa::getNome);
        cbEtapa.setWidth("400px");
        NumberField posicao = new NumberField("Posi\u00e7\u00e3o");
        posicao.setValue((Number)1.0);
        posicao.setMax(Double.valueOf(99.0).doubleValue());
        posicao.setMin(Double.valueOf(1.0).doubleValue());
        Button close = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE, (String)"Fechar");
        close.addClickListener((ComponentEventListener & Serializable)e -> dialog.close());
        Button confirm = UIUtils.createSmallButton((String)"Confirmar", (VaadinIcon)VaadinIcon.CHECK, (String)"Confirmar");
        confirm.addClickListener((ComponentEventListener & Serializable)e -> {
            if (cbUsuario.getValue().size() <= 0 || cbEtapa.getValue().size() <= 0 || ((Double)posicao.getValue()).intValue() <= 0) {
                this.showNotification("Selecione um usuario, uma etapa e informe uma posicao");
                return;
            }
            Object erro = "";
            for (HierarquiaDTO h : cbUsuario.getValue()) {
                for (PedidoEtapa pe : cbEtapa.getValue()) {
                    EstruturaUsuario eu = this.eus.getById(h.getEstruturaUsuarioId());
                    KanbanPedidos kp = new KanbanPedidos();
                    kp.setBackgroundColor("");
                    kp.setEstruturaUsuario(eu);
                    kp.setNome("");
                    kp.setPedidoEtapa(pe);
                    kp.setPosition(Integer.valueOf(((Double)posicao.getValue()).intValue()));
                    try {
                        this.kanbanService.save(kp);
                    }
                    catch (Exception ex) {
                        erro = (String)erro + ex.getMessage() + "\n";
                    }
                }
            }
            dialog.close();
            this.crud.refreshGrid();
            if (((String)erro).isEmpty()) {
                this.showNotification("Inserido com sucesso");
            } else {
                this.showNotification((String)erro);
            }
        });
        dialog.add(new Component[]{new VerticalContainer(new Component[]{cbUsuario, cbEtapa, posicao}), new FooterContainer(new Component[]{close, confirm})});
        dialog.open();
    }
}

