/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.mailing.model;

import br.com.system.app.features.mailing.model.Mailing;
import br.com.system.app.features.mailing.model.MailingTipoContatoEnum;
import br.com.system.app.features.shared.model.IEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Objects;
import org.hibernate.annotations.DynamicUpdate;

@Entity
@DynamicUpdate
@Table(name="mailing_contato")
public class MailingContato
implements IEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @OneToOne
    @JsonIgnore
    private Mailing mailing;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private MailingTipoContatoEnum tipo;
    @NotNull
    private String valor;

    public MailingContato() {
    }

    public MailingContato(MailingTipoContatoEnum tipo, String valor) {
        this.tipo = tipo;
        this.valor = valor;
    }

    public MailingContato(Long id, Mailing mailing, MailingTipoContatoEnum tipo, String valor) {
        this.id = id;
        this.mailing = mailing;
        this.tipo = tipo;
        this.valor = valor;
    }

    public MailingContato(Mailing mailing, MailingTipoContatoEnum tipo, String valor) {
        this.mailing = mailing;
        this.tipo = tipo;
        this.valor = valor;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Mailing getMailing() {
        return this.mailing;
    }

    public void setMailing(Mailing mailing) {
        this.mailing = mailing;
    }

    public MailingTipoContatoEnum getTipo() {
        return this.tipo;
    }

    public void setTipo(MailingTipoContatoEnum tipo) {
        this.tipo = tipo;
    }

    public String getValor() {
        return this.valor;
    }

    public void setValor(String valor) {
        this.valor = valor;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + Objects.hashCode(this.mailing);
        hash = 97 * hash + Objects.hashCode(this.tipo);
        hash = 97 * hash + Objects.hashCode(this.valor);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MailingContato other = (MailingContato)obj;
        if (!Objects.equals(this.valor, other.valor)) {
            return false;
        }
        if (!Objects.equals(this.mailing, other.mailing)) {
            return false;
        }
        return this.tipo == other.tipo;
    }
}

