/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.marketing.service;

import br.com.system.app.features.marketing.model.MarketingItem;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.commons.HashUtil;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.datetime.FormatDate;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class MarketingExportacao
implements Serializable {
    private static final long serialVersionUID = 1L;

    public String exportar(List<MarketingItem> lista) {
        InputStream is = null;
        XSSFWorkbook xls = null;
        try {
            is = StorageUtil.getObjectModelo((String)"ExportacaoMarketing-v1.xlsx");
            xls = new XSSFWorkbook(is);
            Sheet aba = xls.getSheet("Exportacao");
            CellStyle styleCellDouble = xls.createCellStyle();
            styleCellDouble.setDataFormat((short)2);
            int linha = 1;
            for (MarketingItem p : lista) {
                Row row = aba.createRow(linha);
                row.createCell(0).setCellValue(p.getNumero());
                row.createCell(1).setCellValue(p.getStatus().name());
                row.createCell(2).setCellValue(p.getDataHoraEnvio() == null ? "" : p.getDataHoraEnvio().format(FormatDate.DATETIME_BR.toDTF()));
                row.createCell(3).setCellValue(p.getDataHoraLeitura() == null ? "" : p.getDataHoraLeitura().format(FormatDate.DATETIME_BR.toDTF()));
                row.createCell(4).setCellValue(p.getDataHoraRecebimento() == null ? "" : p.getDataHoraRecebimento().format(FormatDate.DATETIME_BR.toDTF()));
                row.createCell(5).setCellValue(p.getRespostas());
                row.createCell(6).setCellValue(p.getErro());
                ++linha;
            }
            String nomeArquivo = HashUtil.getUUI() + ".xlsx";
            InputStream isOutput = InputStreamUtil.workbookToInputStream((Workbook)xls);
            String string = StorageUtil.uploadObjectInputStream((String)nomeArquivo, (String)ContentType.MULTIPART_FORM_DATA.toString(), (InputStream)isOutput);
            return string;
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        finally {
            try {
                xls.close();
                is.close();
                lista = null;
                xls = null;
                is = null;
            }
            catch (Exception exception) {}
        }
    }
}

