/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.oportunidade.view;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.DownloadDialog;
import br.com.system.app.components.ListField;
import br.com.system.app.components.ListFieldTypeEnum;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.configurations.model.ConfigurationEnum;
import br.com.system.app.features.configurations.service.ConfigurationsService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.layout.util.Shadow;
import br.com.system.app.features.oportunidade.model.OportunidadeFile;
import br.com.system.app.features.oportunidade.service.OportunidadeService;
import br.com.system.app.features.shared.model.TipoProcessoEnum;
import br.com.system.app.features.util.TempFileMultiBuffer;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.FileUtil;
import br.com.system.commons.SleepUtil;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import elemental.json.Json;
import elemental.json.JsonValue;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;

@Route(value="oportunidade/lote", layout=MainLayout.class)
@PageTitle(value="Oportunidade")
@RolesAllowed(value={"OPORTUNIDADE_VIEW"})
public class OportunidadeView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final OportunidadeService os;
    private final ConfigurationsService configurationsService;
    private String nomeArquivo = "";
    private TempFileMultiBuffer mBuffer;
    private GridCrud<OportunidadeFile> crud;
    private final RadioButtonGroup<TipoProcessoEnum> rbTipo;
    private Checkbox cbWhats;
    private DownloadDialog dd;

    @Autowired
    public OportunidadeView(OportunidadeService os, ConfigurationsService configurationsService) {
        this.os = os;
        this.configurationsService = configurationsService;
        this.rbTipo = new RadioButtonGroup("Tipo Pesquisa");
        this.rbTipo.setItems((Object[])new TipoProcessoEnum[]{TipoProcessoEnum.CNPJ});
        this.rbTipo.setValue((Object)TipoProcessoEnum.CNPJ);
    }

    protected void onAttach(AttachEvent attachEvent) {
        if (this.autenticado()) {
            this.setViewContent(this.createContent());
        }
    }

    private Component createContent() {
        this.dd = new DownloadDialog();
        this.cbWhats = new Checkbox("Consultar Se Tem Whatsapp R$ " + String.valueOf(this.configurationsService.get(ConfigurationEnum.VALOR_TEM_WHATS).getBigDecimal()) + " por n\u00famero");
        this.cbWhats.setVisible(false);
        this.cbWhats.setValue((Object)false);
        VerticalContainer v = new VerticalContainer(new Component[0]);
        v.setHeight("100%");
        v.add(new Component[]{new HorizontalContainer(new Component[]{this.rbTipo, this.cbWhats})});
        v.add(new Component[]{new HorizontalContainer(new Component[]{this.createUpload(), this.createCampanha()})});
        v.add(new Component[]{this.createGrid()});
        return v;
    }

    private VerticalContainer createUpload() {
        this.mBuffer = new TempFileMultiBuffer();
        Upload upload = new Upload((Receiver)this.mBuffer);
        upload.setMaxFiles(1);
        upload.setAcceptedFileTypes(new String[]{".xlsx"});
        upload.addFinishedListener((ComponentEventListener & Serializable)e -> {
            this.nomeArquivo = e.getFileName();
            UIUtils.showNotification((String)"Arquivo carregado, clique em processar");
        });
        upload.addFileRejectedListener((ComponentEventListener & Serializable)event -> UIUtils.showNotification((String)"Formato inv\u00e1lido, apenas .xlxs"));
        Button processar = UIUtils.createSmallButton((String)"Processar", (VaadinIcon)VaadinIcon.COGS, (String)"Iniciar processamento");
        processar.setDisableOnClick(true);
        processar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.nomeArquivo.isEmpty()) {
                UIUtils.showNotification((String)"Selecione o arquivo.");
            } else {
                try {
                    this.os.exportacaoByFile(this.getEu(), this.mBuffer.getInputStream(), this.nomeArquivo, (TipoProcessoEnum)this.rbTipo.getValue(), (Boolean)this.cbWhats.getValue());
                    UIUtils.showProcessNotification();
                }
                catch (Exception ex) {
                    this.showNotification(ex.getMessage());
                }
                upload.getElement().setPropertyJson("files", (JsonValue)Json.createArray());
                SleepUtil.inSeconds((Integer)3);
                this.crud.refreshGrid();
                this.mBuffer.clear();
                this.nomeArquivo = "";
            }
            processar.setEnabled(true);
        });
        VerticalContainer card = new VerticalContainer(new Component[0]);
        card.setWidth("310px");
        card.setShadow(Shadow.S);
        card.add(new Component[]{UIUtils.createHeader((String)"Upload arquivos")});
        card.add(new Component[]{upload, new FooterContainer(new Component[]{processar})});
        return card;
    }

    private Component createCampanha() {
        TextField txtNomeProcesso = new TextField();
        txtNomeProcesso.setLabel("Nome Campanha");
        ListField txtListaCnpjs = new ListField(ListFieldTypeEnum.CPF_CNPJ, "Lista CPF-CNPJ");
        Button btnLista = UIUtils.createSmallButton((String)"Processar", (VaadinIcon)VaadinIcon.COGS, (String)"Iniciar processamento");
        btnLista.setDisableOnClick(true);
        btnLista.addClickListener((ComponentEventListener & Serializable)event -> {
            if (txtNomeProcesso.isEmpty() || txtListaCnpjs.isEmpty()) {
                UIUtils.showNotification((String)"Nome Campanha e lista Cnpj's s\u00e3o obrigat\u00f3rios.");
            } else {
                try {
                    this.os.exportacao(txtListaCnpjs.getValue(), this.getEu(), txtNomeProcesso.getValue().replace(".", "_"), (TipoProcessoEnum)this.rbTipo.getValue(), (Boolean)this.cbWhats.getValue());
                    UIUtils.showProcessNotification();
                    SleepUtil.inSeconds((Integer)3);
                }
                catch (Exception ex) {
                    this.showNotification(ex.getMessage());
                }
                this.crud.refreshGrid();
                txtNomeProcesso.setValue("");
                txtListaCnpjs.clear();
            }
            btnLista.setEnabled(true);
        });
        VerticalContainer card = new VerticalContainer(new Component[0]);
        card.setWidth("310px");
        card.setShadow(Shadow.S);
        card.add(new Component[]{UIUtils.createHeader((String)"Campanha processo")});
        card.add(new Component[]{txtNomeProcesso, txtListaCnpjs, new FooterContainer(new Component[]{btnLista})});
        return card;
    }

    private GridCrud<OportunidadeFile> createGrid() {
        this.crud = new GridCrud(OportunidadeFile.class);
        TextField filter = new TextField();
        filter.setPlaceholder("Filtrar por nome");
        filter.setClearButtonVisible(true);
        this.crud.getCrudLayout().addFilterComponent((Component)filter);
        this.crud.getGrid().setColumns(new String[0]);
        if (this.isMaster()) {
            this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> {
                Button btn = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.REFRESH, (String)"Reprocessar");
                btn.setEnabled(this.isMaster());
                btn.addClickListener((ComponentEventListener & Serializable)e -> {
                    ConfirmationDialog cd = new ConfirmationDialog("Reprocessamento", "Confirma reprocessamento do arquivo?");
                    cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
                    cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                        this.reprocessar(p);
                        this.showNotification("Solicita\u00e7\u00e3o de reprocessamento efetuada com sucesso");
                        cd.close();
                    });
                });
                return btn;
            })).setHeader("Rep").setFlexGrow(0).setWidth("80px");
        }
        this.crud.getGrid().addColumns(new String[]{"nomeArquivo", "statusProcesso", "totalRegistros", "observacao"});
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> UIUtils.formatDateTime((LocalDateTime)p.getDataHoraImportacao()))).setHeader("Data/Hora");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getEstruturaUsuario().getUsuario().getNome())).setHeader("Usu\u00e1rio");
        this.crud.getGrid().getColumnByKey("nomeArquivo").setWidth("300px");
        this.crud.getGrid().addComponentColumn((ValueProvider & Serializable)item -> {
            Button b = UIUtils.createSmallButton((String)"Download");
            b.setVisible(item.getUrlArquivo() != null && !item.getUrlArquivo().isEmpty());
            b.addClickListener((ComponentEventListener & Serializable)e -> {
                String url;
                String string = url = item.getUrlArquivo() == null ? "" : item.getUrlArquivo();
                if (item.getUrlArquivo() == null) {
                    item.setUrlArquivo("");
                }
                if (item.getUrlArquivo().isEmpty()) {
                    b.setVisible(false);
                } else {
                    String ext = FileUtil.getExtension((String)item.getNomeArquivo());
                    if (ext == null || ext.isEmpty()) {
                        ext = FileUtil.getExtension((String)item.getUrlArquivo());
                        item.setNomeArquivo(item.getNomeArquivo() + ext);
                    }
                    this.dd.open(url, item.getNomeArquivo());
                }
            });
            return b;
        }).setHeader("Download");
        this.crud.getGrid().setColumnReorderingAllowed(true);
        this.crud.getAddButton().setVisible(false);
        this.crud.getUpdateButton().setVisible(false);
        this.crud.getDeleteButton().setVisible(this.isMaster());
        this.crud.getCrudFormFactory().setVisibleProperties(new String[]{"nomeArquivo"});
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        filter.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.crud.refreshGrid());
        return this.crud;
    }

    private void reprocessar(OportunidadeFile p) {
        this.os.reprocessar(p);
    }
}

