/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.service;

import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoAudio;
import br.com.system.app.features.pedido.repository.PedidoAudioRepository;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.commons.HashUtil;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PedidoAudioService {
    @Autowired
    private PedidoAudioRepository repository;

    public List<PedidoAudio> getAudio(Pedido p) {
        return this.repository.findByPedido(p);
    }

    public PedidoAudio save(EstruturaUsuario eu, String nomeAudio, Pedido p, String audiobase64) {
        try {
            if (audiobase64.contains(",")) {
                audiobase64 = audiobase64.split(",")[1];
            }
            byte[] bytes = Base64.decodeBase64((String)audiobase64);
            String hash = HashUtil.getUUI() + ".mp3";
            String contentFile = "audio/mpeg";
            StorageUtil.uploadObjectByteArray((String)hash, (String)contentFile, (byte[])bytes);
            PedidoAudio pa = new PedidoAudio();
            pa.setDataHora(LocalDateTime.now());
            pa.setEstruturaUsuario(eu);
            pa.setNomeAudio(nomeAudio);
            pa.setPedido(p);
            pa.setHashGravacao(hash);
            return (PedidoAudio)this.repository.save((Object)pa);
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
    }

    public void delete(PedidoAudio pa) {
        this.repository.delete((Object)pa);
    }

    public void deleteByPedido(Pedido pedido) {
        this.repository.deleteByPedido(pedido);
    }
}

