/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.service;

import br.com.system.app.features.estrutura.model.EstruturaComplemento;
import br.com.system.app.features.estrutura.service.EstruturaComplementoService;
import br.com.system.app.features.estrutura.service.EstruturaService;
import br.com.system.app.features.pedido.dto.PedidoStatusDTO;
import br.com.system.app.features.pedido.service.PedidoStatusService;
import br.com.system.app.features.tokens.model.Tokens;
import br.com.system.app.features.tokens.service.TokensService;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.datetime.DateTimeUtil;
import br.com.system.commons.datetime.FormatDate;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PedidoStatusIntegration
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private PedidoStatusService pedidoStatusService;
    @Autowired
    private EstruturaComplementoService estruturaComplementoService;
    @Autowired
    private EstruturaService estruturaService;
    @Autowired
    private TokensService tokensService;

    public void doIntegration(ServletRequest request, ServletResponse response) {
        PrintWriter out;
        try {
            out = response.getWriter();
            response.setCharacterEncoding("UTF-8");
        }
        catch (IOException e) {
            return;
        }
        try {
            long minutes;
            EstruturaComplemento estruturaCompl;
            String body = InputStreamUtil.toString((InputStream)request.getInputStream());
            if (body.isEmpty()) {
                out.print(this.example());
                return;
            }
            JSONObject jsonBody = new JSONObject(body);
            if (!jsonBody.has("token")) {
                this.printErro("Token obrigatorio", out);
                return;
            }
            Tokens token = this.tokensService.getToken(jsonBody.getString("token"));
            if (token != null) {
                if (!jsonBody.has("estruturaId")) {
                    this.printErro("Estrutura Id \u00e9 obrigatorio", out);
                    return;
                }
                Long estruturaId = jsonBody.getLong("estruturaId");
                if (estruturaId <= 0L) {
                    this.printErro("Estrutura Id \u00e9 obrigatorio", out);
                    return;
                }
                boolean permitido = false;
                for (String s : token.getListaEstruturaId().split(",")) {
                    if (!Long.valueOf(s).equals(estruturaId)) continue;
                    permitido = true;
                    break;
                }
                if (!permitido) {
                    this.printErro("Sem permiss\u00e3o para acessar essa estrutura", out);
                    return;
                }
                estruturaCompl = this.estruturaComplementoService.getComplementos(this.estruturaService.getById(estruturaId));
            } else {
                estruturaCompl = this.estruturaComplementoService.getByTokenIntegration(jsonBody.getString("token"));
            }
            if (estruturaCompl == null) {
                this.printErro("Token Inv\u00e1lido", out);
                return;
            }
            if (!jsonBody.has("dataHoraInicioCarga")) {
                this.printErro("dataHoraInicioCarga \u00e9 Obrigat\u00f3rio", out);
                return;
            }
            LocalDateTime dataHoraInicioCarga = DateTimeUtil.toDateTime((String)jsonBody.getString("dataHoraInicioCarga"), (FormatDate)FormatDate.US_DATETIME);
            LocalDateTime dataHoraFimCarga = !jsonBody.has("dataHoraFimCarga") ? LocalDateTime.now() : DateTimeUtil.toDateTime((String)jsonBody.getString("dataHoraFimCarga"), (FormatDate)FormatDate.US_DATETIME);
            if (!DateTimeUtil.isOpen((LocalTime)LocalTime.of(22, 0), (LocalTime)LocalTime.of(5, 0), (LocalTime)LocalTime.now()) && (minutes = ChronoUnit.MINUTES.between(dataHoraInicioCarga, dataHoraFimCarga)) > 90L) {
                this.printErro("Entre 06:00 e 22:00 periodo m\u00e1ximo de pesquisa \u00e9 90 minutos", out);
                return;
            }
            String strOut = this.getJson(estruturaCompl.getEstrutura().getId(), dataHoraInicioCarga);
            out.print(strOut);
        }
        catch (Exception e) {
            this.printErro(e.getMessage(), out);
        }
    }

    private void printErro(String msg, PrintWriter out) {
        JSONObject jsonRetorno = new JSONObject();
        jsonRetorno.put("success", false);
        jsonRetorno.put("erro", (Object)msg);
        out.print(jsonRetorno.toString());
    }

    private String example() {
        return "<html><head><title>Integra\u00e7\u00e3o Movimetacao Atividade</title></head><body><div><p ><img src=\"images/logos/neo-200.png\"></p>\n<h4 ><strong><u>Integra\u00e7\u00e3o Movimetacao Atividade</u></strong></h4>\n<ul>\n <li>method - POST</li>\n <li>token parceiro ou token global- Obrigat\u00f3rio</li>\n <li>estruturaId - (obrigatorio para token global) <li>dataHoraInicioCarga - Obrigat\u00f3rio</li>\n <li>dataHoraFimCarga - N\u00e3o Obrigat\u00f3rio</li>\n</ul>\n<p>Json Body :</p>\n<pre>{\n       \"token\":\"SOLICITE_SEU_TOKEN_AO_SUPORTE\",\n       \"estruturaId\":\"SOLICITE_AO_SUPORTE\",\n       \"dataHoraInicioCarga\":\"2022-04-01 00:00:00\",\n       \"dataHoraFimCarga\":\"2022-04-31 00:00:00\",\n}\n</pre>\n<p style=\"text-align: center\"><br></p></div></body></html>";
    }

    private String getJson(Long estruturaId, LocalDateTime dataHoraUltimaCarga) {
        List lista = this.pedidoStatusService.getForBi(estruturaId, dataHoraUltimaCarga);
        JSONArray arr = new JSONArray();
        for (PedidoStatusDTO e : lista) {
            if (e.getDataHoraSaiu() != null && e.getDataHoraSaiu().isBefore(e.getDataHoraEntrou())) {
                e.setDataHoraSaiu(null);
                e.setEuSaiuId(null);
                e.setUsuarioSaiu(null);
            }
            JSONObject j = new JSONObject();
            j.put("id", (Object)e.getId());
            j.put("estruturaId", (Object)estruturaId);
            j.put("numeroAtividade", (Object)e.getNumeroAtividade());
            j.put("etapaId", (Object)e.getEtapaId());
            j.put("etapaNome", (Object)e.getNomeEtapa());
            j.put("valorTotal", (Object)e.getTotal());
            j.put("compMensal", (Object)e.getCompromissoMensal());
            j.put("consultor", (Object)e.getNomeConsultor());
            j.put("dataHoraEntrou", (Object)e.getDataHoraEntrou());
            j.put("usuarioEntrouId", (Object)e.getEuEntrouId());
            j.put("usuarioEntrou", (Object)e.getUsuarioEntrou());
            j.put("dataHoraSaiu", e.getDataHoraSaiu() == null ? JSONObject.NULL : e.getDataHoraSaiu());
            j.put("usuarioSaiuId", e.getEuSaiuId() == null ? JSONObject.NULL : e.getEuSaiuId());
            j.put("usuarioSaiu", e.getUsuarioSaiu() == null ? JSONObject.NULL : e.getUsuarioSaiu());
            arr.put((Object)j);
        }
        return arr.toString();
    }
}

