/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.service;

import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.estrutura.model.EstruturaComplemento;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaComplementoService;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.StringUtil;
import br.com.system.commons.ValidationUtil;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RdstationIntegration
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private EstruturaComplementoService estruturaService;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private EstruturaUsuarioService estruturaUsuarioService;

    public void doIntegration(ServletRequest request, ServletResponse response) {
        PrintWriter out;
        try {
            out = response.getWriter();
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            response.setContentType("json");
        }
        catch (IOException e) {
            return;
        }
        try {
            String token = request.getParameter("token");
            EstruturaComplemento estruturaCompl = this.estruturaService.getByTokenIntegration(token);
            if (estruturaCompl == null) {
                out.print("FORBIDEN");
                return;
            }
            String body = InputStreamUtil.toString((InputStream)request.getInputStream());
            if (body.isEmpty()) {
                throw new Exception("Body is empty");
            }
            JSONObject jsonBody = new JSONObject(body);
            StringBuilder dados = new StringBuilder();
            JSONArray campos = jsonBody.names();
            String cnpj = "";
            String campanha = "";
            for (int i = 0; i < campos.length(); ++i) {
                String campo = campos.getString(i);
                dados.append(campo).append(": ").append(jsonBody.getString(campo)).append("\n");
                if (campo.contains("cnpj")) {
                    cnpj = StringUtil.normalizeCpfCnpj((String)jsonBody.getString(campo));
                }
                if (campo.contains("email")) {
                    dados.append(jsonBody.getString(campo)).append("\n");
                }
                if (campo.contains("personal_phone")) {
                    dados.append(jsonBody.getString(campo)).append("\n");
                }
                if (campo.contains("mobile_phone")) {
                    dados.append(jsonBody.getString(campo)).append("\n");
                }
                if (!campo.contains("event_identifier")) continue;
                campanha = jsonBody.getString(campo);
            }
            if (!ValidationUtil.isValidCnpjAndCpf((String)cnpj)) {
                cnpj = estruturaCompl.getEstrutura().getCpfCnpj();
            }
            EstruturaUsuario eu = this.estruturaUsuarioService.getMasterEstrutura(estruturaCompl.getEstrutura());
            Pedido pedido = new Pedido();
            pedido.setCliente(this.clienteService.getAndCreateCliente(eu, cnpj, new ClienteContato[0]));
            pedido.setComplementos(dados.toString());
            pedido.setEstruturaUsuario(eu);
            if (campanha.isEmpty()) {
                pedido.setTags("#rdStation");
            } else {
                pedido.setTags("#rdStation,#" + campanha);
            }
            pedido.setPedidoTipo(PedidoTipoEnum.COMERCIAL);
            this.pedidoService.salvar(pedido);
            JSONObject jsonRetorno = new JSONObject();
            jsonRetorno.put("success", true);
            out.print(jsonRetorno.toString());
            jsonRetorno = null;
            jsonBody = null;
            dados = null;
        }
        catch (Exception e) {
            JSONObject jsonRetorno = new JSONObject();
            jsonRetorno.put("success", false);
            jsonRetorno.put("erro", (Object)e.getMessage());
            out.print(jsonRetorno.toString());
        }
    }
}

