/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.view;

import br.com.system.app.components.Card;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.model.PedidoEtapa;
import br.com.system.app.features.pedido.model.PedidoOrigem;
import br.com.system.app.features.pedido.service.PedidoEtapaService;
import br.com.system.app.features.pedido.service.PedidoOrigemService;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.app.features.producaopainel.dto.ProducaoPedidoDTO;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DialogAlterarEtapa
implements SecurityContext,
Serializable {
    private static final long serialVersionUID = 1L;
    private final EstruturaUsuario estruturaUsuario;
    private final PedidoService pedidoService;
    private final PedidoEtapaService pedidoEtapaService;
    private final List<ProducaoPedidoDTO> pedidos;
    private final PedidoOrigemService pedidoOrigemService;
    private final PedidoTipoEnum pte;
    private Dialog dialog;
    private PedidoEtapa etapa;

    public Dialog getDialog() {
        return this.dialog;
    }

    public DialogAlterarEtapa(List<ProducaoPedidoDTO> pedidos, EstruturaUsuario estruturaUsuario, PedidoService pedidoService, PedidoEtapaService pedidoEtapaService, PedidoOrigemService pedidoOrigemService, PedidoTipoEnum pte) {
        this.pte = pte;
        this.estruturaUsuario = estruturaUsuario;
        this.pedidoOrigemService = pedidoOrigemService;
        this.pedidoService = pedidoService;
        this.pedidoEtapaService = pedidoEtapaService;
        this.pedidos = pedidos;
    }

    public PedidoEtapa getEtapa() {
        return this.etapa;
    }

    public void open() {
        Card card = new Card();
        card.setHeader("Etapa atividade");
        Div alertOrigem = new Div();
        alertOrigem.setWidth("300px");
        TextField nome = new TextField("Filtrar atividade");
        Grid grid = new Grid();
        ComboBox cbOrigem = new ComboBox("Origem", (Collection)this.pedidoOrigemService.getByEstruturaTipoActiveOnly(this.estruturaUsuario.getEstrutura().getEstruturaTipo()));
        cbOrigem.setItemLabelGenerator(PedidoOrigem::getNome);
        cbOrigem.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            this.povoa(grid, "", (PedidoOrigem)e.getValue());
            Object msg = "";
            for (ProducaoPedidoDTO ppd : this.pedidos) {
                if (ppd.getPedidoOrigemId().equals(((PedidoOrigem)e.getValue()).getId())) continue;
                if (((String)msg).isBlank()) {
                    msg = "<b>Aten\u00e7\u00e3o, origens divergentes</b><BR>";
                }
                msg = (String)msg + "Pedido <b>" + ppd.getNumeroPedido() + "</b> Origem <b>" + ppd.getNomeOrigem() + "</b><BR>";
            }
            alertOrigem.getElement().setProperty("innerHTML", "<span>" + (String)msg + "</span>");
        });
        PedidoOrigem origemAtividade = this.pedidoOrigemService.getOrigemAtividade(this.estruturaUsuario.getEstrutura());
        cbOrigem.setValue((Object)origemAtividade);
        grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getNome())).setHeader("Nome").setSortable(true).setFlexGrow(0).setWidth("400px");
        grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getPedidoOrigem().getNome())).setHeader("Origem").setSortable(true).setFlexGrow(0).setWidth("19    0px");
        this.povoa(grid, nome.getValue(), (PedidoOrigem)cbOrigem.getValue());
        nome.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.povoa(grid, (String)e.getValue(), (PedidoOrigem)cbOrigem.getValue()));
        card.setContent(new Component[]{UIUtils.createSmallSpan((String)("Total Atividades: " + this.pedidos.size())), new HorizontalContainer(new Component[]{new VerticalContainer(new Component[]{cbOrigem, nome}), alertOrigem}), grid});
        Button btnConfirmar = UIUtils.createSmallButton((String)"Confirmar", (VaadinIcon)VaadinIcon.CHECK);
        btnConfirmar.setDisableOnClick(true);
        Button btnFechar = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE);
        card.setFooter(new Component[]{btnFechar, btnConfirmar});
        card.getFooterBox().setJustifyContentMode(FlexComponent.JustifyContentMode.BETWEEN);
        this.dialog = new Dialog();
        this.dialog.add(new Component[]{card});
        this.dialog.setWidth("600px");
        btnConfirmar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (grid.getSelectedItems().size() <= 0) {
                UIUtils.showNotification((String)"Selecione uma Etapa");
                btnConfirmar.setEnabled(true);
                return;
            }
            this.etapa = (PedidoEtapa)grid.getSelectedItems().iterator().next();
            if (this.pedidos.size() > 1) {
                this.pedidoService.alterarEtapaPedido(this.pedidos, this.etapa, this.estruturaUsuario, this.hasPermission("ATIVIDADE_MOVER_NAO_EDITAVEIS"), false);
                UIUtils.showProcessNotification((String)"Etapas alteradas com sucesso, resultado em notificacoes");
            } else {
                ProducaoPedidoDTO p = (ProducaoPedidoDTO)this.pedidos.iterator().next();
                if (!p.getEditavel().booleanValue() && !this.hasPermission("ATIVIDADE_MOVER_NAO_EDITAVEIS")) {
                    UIUtils.showNotification((String)"Esta atividade est\u00e1 em uma etapa n\u00e3o editavel e voc\u00ea n\u00e3o tem permiss\u00e3o de movimenta-la");
                } else {
                    this.pedidoService.alterarEtapaPedido(p, this.etapa, this.estruturaUsuario, true, true);
                    UIUtils.showNotification((String)"Etapa alterada com sucesso");
                }
            }
            this.dialog.close();
        });
        btnFechar.addClickListener((ComponentEventListener & Serializable)e -> this.dialog.close());
        this.dialog.open();
    }

    private void povoa(Grid<PedidoEtapa> grid, String filtername, PedidoOrigem origem) {
        List lista = this.pedidoEtapaService.getAtivosNomeContains(this.estruturaUsuario.getEstrutura(), filtername, origem, this.pte);
        grid.setItems((Collection)lista);
    }
}

