/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.view;

import br.com.system.app.components.Card;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.features.estrutura.model.EstruturaSenhas;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaSenhasService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.size.FontSize;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoTipoNegociacaoEnum;
import br.com.system.app.features.pedido.service.PedidoVinculoService;
import br.com.system.commons.StringUtil;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;
import java.util.Collection;

public class DialogVincularTim
extends Dialog
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Pedido pedido;
    private final EstruturaUsuario euContext;
    private final PedidoVinculoService pedidoVinculoService;
    private final EstruturaSenhasService estruturaSenhasService;
    private TextField numeroPedido;
    private TextField notaFiscal;
    private RadioButtonGroup<PedidoTipoNegociacaoEnum> rbNegociacao;
    private ComboBox<EstruturaSenhas> cbSenhas;

    public DialogVincularTim(Pedido pedido, EstruturaUsuario euContext, PedidoVinculoService pedidoVinculoService, EstruturaSenhasService estruturaSenhasService) {
        this.pedido = pedido;
        this.estruturaSenhasService = estruturaSenhasService;
        this.euContext = euContext;
        this.pedidoVinculoService = pedidoVinculoService;
    }

    public Pedido getPedido() {
        return this.pedido;
    }

    public void create() {
        Card card = new Card();
        card.setHeader("Vincular pedido RADAR/TIM-VENDAS");
        this.cbSenhas = new ComboBox("Login", (Collection)this.estruturaSenhasService.getAtivosByEstrutura(this.euContext.getEstrutura()));
        this.cbSenhas.setItemLabelGenerator(EstruturaSenhas::getNomeAndSistema);
        this.cbSenhas.setValue((Object)this.pedido.getEstruturaSenhas());
        this.setWidth("500px");
        this.cbSenhas.setWidth("300px");
        this.numeroPedido = new TextField("N\u00famero Radar/Tim Vendas");
        this.numeroPedido.setWidth("200px");
        this.numeroPedido.setValue(this.pedido.getNumeroPedidoVinculado() == null ? "" : this.pedido.getNumeroPedidoVinculado());
        this.notaFiscal = new TextField("N\u00famero P2B");
        this.notaFiscal.setWidth("200px");
        this.notaFiscal.setValue(this.pedido.getNotasFiscais() == null ? "" : this.pedido.getNotasFiscais());
        this.rbNegociacao = new RadioButtonGroup();
        this.rbNegociacao.setItems((Object[])PedidoTipoNegociacaoEnum.values());
        this.rbNegociacao.setLabel("Cliente base ou Novo");
        this.rbNegociacao.setValue((Object)(this.pedido.getTipoNegociacao() == null ? PedidoTipoNegociacaoEnum.NOVO : this.pedido.getTipoNegociacao()));
        Button btnDescincular = UIUtils.createSmallButton((String)"Desvincular", (VaadinIcon)VaadinIcon.UNLINK, (String)"Desvincular pedido");
        btnDescincular.addClickListener((ComponentEventListener & Serializable)e -> {
            ConfirmationDialog cd = new ConfirmationDialog("Desvincular", "Confirma desvincular Pedido?");
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)confirm -> {
                this.pedidoVinculoService.desvincularSingle(this.pedido, this.euContext);
                this.close();
                UIUtils.showNotification((String)"Desvinculado com sucesso.");
            });
        });
        Button btn = UIUtils.createSmallButton((String)"Vincular", (VaadinIcon)VaadinIcon.CHECK, (String)"Vincular pedido");
        btn.addClickListener((ComponentEventListener & Serializable)e -> this.doLink());
        Button btnClose = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE, (String)"");
        btnClose.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        card.setContent(new Component[]{UIUtils.createSpan((FontSize)FontSize.S, (String)("Pedido: " + this.pedido.getNumero())), UIUtils.createSpan((FontSize)FontSize.S, (String)("Cliente: " + this.pedido.getCliente().getNome())), this.cbSenhas, this.numeroPedido, this.notaFiscal, this.rbNegociacao});
        card.setFooter(new Component[]{btnClose, btn});
        card.getFooterBox().setJustifyContentMode(FlexComponent.JustifyContentMode.BETWEEN);
        this.add(new Component[]{card});
        this.open();
    }

    private void doLink() {
        if (this.numeroPedido.isEmpty() || this.cbSenhas.getValue() == null) {
            UIUtils.showNotification((String)"Informe o n\u00famero e selecione uma senha");
            return;
        }
        if (this.numeroPedido.getValue().equals(this.pedido.getNumero())) {
            UIUtils.showNotification((String)"Voc\u00ea n\u00e3o pode vincular o pedido com ele mesmo.");
            return;
        }
        if (this.rbNegociacao.getValue() == null) {
            UIUtils.showNotification((String)"Selecione se \u00e9 cliente novo ou base");
            return;
        }
        try {
            String numero = StringUtil.removeLineBreaks((String)this.numeroPedido.getValue().trim());
            this.pedido = this.pedidoVinculoService.vincularSingle(this.pedido, (EstruturaSenhas)this.cbSenhas.getValue(), this.euContext, numero, this.notaFiscal.getValue(), (PedidoTipoNegociacaoEnum)this.rbNegociacao.getValue(), null, null, null, null, null);
            UIUtils.showNotification((String)"Vinculado com sucesso");
            this.close();
        }
        catch (Exception ex) {
            UIUtils.showNotification((String)("Erro: " + ex.getMessage()));
        }
    }
}

