/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.view;

import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoEmail;
import br.com.system.app.features.pedido.repository.PedidoEmailRepository;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.util.Collection;

public class PedidoEmailView
extends Dialog {
    private static final long serialVersionUID = 1L;
    private final PedidoEmailRepository pmr;
    private final Pedido pedido;

    public PedidoEmailView(Pedido pedido, PedidoEmailRepository pmr) {
        this.pmr = pmr;
        this.pedido = pedido;
        this.init();
    }

    private void init() {
        this.setWidth("600px");
        Grid grid = new Grid(PedidoEmail.class);
        grid.setColumns(new String[0]);
        grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)e -> {
            PedidoEmail pm = e;
            return UIUtils.createBreakWrapSpan((String)pm.getEstruturaUsuario().getUsuario().getNome());
        })).setHeader("Usu\u00e1rio").setFlexGrow(0).setWidth("200px");
        grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataHoraEnvio().format(FormatDate.DATETIME_BR.toDTF()))).setFlexGrow(0).setWidth("250px").setHeader("Envio");
        grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)e -> {
            PedidoEmail pm = e;
            return UIUtils.createBreakWrapSpan((String)pm.getAssunto());
        })).setHeader("Assunto").setFlexGrow(0).setWidth("200px");
        grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)e -> {
            PedidoEmail pm = e;
            return UIUtils.createBreakWrapSpan((String)pm.getDestinatarios());
        })).setHeader("Destinat\u00e1rios").setFlexGrow(0).setWidth("200px");
        grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)e -> {
            PedidoEmail pm = e;
            Button btn = UIUtils.createSmallButton((String)"Ver E-mail");
            btn.addClickListener((ComponentEventListener & Serializable)c -> {
                Dialog dialog = new Dialog();
                Div content = new Div();
                content.getElement().setProperty("innerHTML", pm.getMensagem());
                Button fechar = UIUtils.createSmallButton((String)"Fechar");
                fechar.addClickListener((ComponentEventListener & Serializable)close -> dialog.close());
                dialog.setWidthFull();
                dialog.setHeightFull();
                dialog.add(new Component[]{new VerticalContainer(new Component[]{content, fechar})});
                dialog.open();
            });
            return btn;
        })).setHeader("Conte\u00fado").setFlexGrow(0).setWidth("200px");
        grid.setItems((Collection)this.pmr.findByPedido(this.pedido, null));
        Button btnClose = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE);
        btnClose.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        this.add(new Component[]{new VerticalContainer(new Component[]{UIUtils.createHeader((String)"E-mails enviados "), grid, btnClose})});
        this.open();
    }
}

