/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.view.atividade;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.DownloadDialog;
import br.com.system.app.components.InformationDialog;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.components.grid.GridOrderService;
import br.com.system.app.components.grid.model.GridNameEnum;
import br.com.system.app.features.cliente.view.ClienteContatoView;
import br.com.system.app.features.configurations.model.ConfigurationEnum;
import br.com.system.app.features.configurations.service.ConfigurationsService;
import br.com.system.app.features.equipe.service.EquipeService;
import br.com.system.app.features.estrutura.model.EstruturaComplemento;
import br.com.system.app.features.estrutura.model.EstruturaTipoEnum;
import br.com.system.app.features.estrutura.service.EstruturaComplementoService;
import br.com.system.app.features.estrutura.service.EstruturaSenhasService;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.layout.Color;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.layout.size.FontSize;
import br.com.system.app.features.pedido.dto.AtividadeTagsActionEnum;
import br.com.system.app.features.pedido.dto.PedidoSlaENUM;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoTags;
import br.com.system.app.features.pedido.repository.PedidoEmailRepository;
import br.com.system.app.features.pedido.service.PedidoAnexoService;
import br.com.system.app.features.pedido.service.PedidoCategoriaService;
import br.com.system.app.features.pedido.service.PedidoDeleteService;
import br.com.system.app.features.pedido.service.PedidoEtapaGrupoService;
import br.com.system.app.features.pedido.service.PedidoEtapaService;
import br.com.system.app.features.pedido.service.PedidoLogService;
import br.com.system.app.features.pedido.service.PedidoMovimentacaoService;
import br.com.system.app.features.pedido.service.PedidoOrigemService;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.app.features.pedido.service.PedidoSubCategoriaService;
import br.com.system.app.features.pedido.service.PedidoTagsService;
import br.com.system.app.features.pedido.service.PedidoVinculoService;
import br.com.system.app.features.pedido.view.DialogAlterarEtapa;
import br.com.system.app.features.pedido.view.DialogAlterarUsuario;
import br.com.system.app.features.pedido.view.DialogVincularClaro;
import br.com.system.app.features.pedido.view.DialogVincularConsultoria;
import br.com.system.app.features.pedido.view.DialogVincularOi;
import br.com.system.app.features.pedido.view.DialogVincularProvedor;
import br.com.system.app.features.pedido.view.DialogVincularTim;
import br.com.system.app.features.pedido.view.DialogVincularVivo;
import br.com.system.app.features.pedido.view.PedidoAnexoView;
import br.com.system.app.features.pedido.view.PedidoEmailView;
import br.com.system.app.features.pedido.view.PedidoMovimentacaoView;
import br.com.system.app.features.pedido.view.atividade.AtividadeView;
import br.com.system.app.features.pedido.view.atividade.MovimentacaoEnum;
import br.com.system.app.features.pedido.view.atividade.PainelAtividadeFilter;
import br.com.system.app.features.pedido.view.atividade.PainelAtividadesView;
import br.com.system.app.features.producaopainel.dto.ProducaoPedidoDTO;
import br.com.system.app.features.producaopainel.dto.ProducaoPedidoFilter;
import br.com.system.app.features.producaopainel.repository.ProducaoPainelRepository;
import br.com.system.app.features.producaopainel.service.PainelAtividadeExportacaoService;
import br.com.system.app.features.produto.model.Produto;
import br.com.system.app.features.produto.model.ProdutoOrigem;
import br.com.system.app.features.produto.service.ProdutoService;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.features.usuario.service.UsuarioService;
import br.com.system.app.features.usuario.service.UsuarioTagService;
import br.com.system.app.features.whatsapp.WhatsAppAtendimentoCreate;
import br.com.system.app.features.whatsapp.WhatsAppViewDialog;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendimento;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendimentoService;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.SleepUtil;
import br.com.system.commons.datetime.DateTimeUtil;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.shared.Registration;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

@Route(value="painel-producao/pedido", layout=MainLayout.class)
@PageTitle(value="Painel Atividades e Pedidos")
@RolesAllowed(value={"PAINEL_PRODUCAO_PEDIDO_VIEW"})
public class PainelAtividadesView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final PedidoEtapaGrupoService pegs;
    private final ProducaoPainelRepository ppr;
    private final PedidoOrigemService pos;
    private final EquipeService equipeService;
    private final EstruturaSenhasService estruturaSenhasService;
    private final PedidoService pedidoService;
    private final PedidoEtapaService pedidoEtapaService;
    private final EstruturaUsuarioService eus;
    private final PedidoTagsService pedidoTagsService;
    private final UsuarioTagService usuarioTagService;
    private final PedidoEmailRepository pedidoEmailRepository;
    private final AtividadeView atividadeView;
    private final PainelAtividadeExportacaoService painelAtividadeExportacao;
    private final UsuarioHierarquiaService hierarquiaService;
    private final PedidoLogService pedidoLogService;
    private final UsuarioService usuarioService;
    private final PedidoVinculoService pedidoVinculoService;
    private final PedidoAnexoService pedidoAnexoService;
    private final WhatsAppAtendimentoCreate whatsAppAtendimentoCreate;
    private final WhatsAppViewDialog whatsAppViewDialog;
    private final WhatsAppAtendimentoService whatsAppAtendimentoService;
    private Grid<ProducaoPedidoDTO> grid;
    private final Set<Long> hierarquia;
    private final PedidoMovimentacaoService pedidoMovimentacaoService;
    private final GridOrderService gridOrderService;
    private final PedidoDeleteService pedidoDeleteService;
    private final ClienteContatoView clienteContatoView;
    private final EstruturaComplementoService estruturaComplementoService;
    private final PedidoCategoriaService pedidoCategoriaService;
    private final PedidoSubCategoriaService pedidoSubCategoriaService;
    private final ProdutoService produtoService;
    private ProdutoOrigem po = ProdutoOrigem.NEOCRM;
    private List<Produto> produtos;
    private Span lblRegistros;
    private PainelAtividadeFilter filter;
    private Button bCount;
    private Button btnFiltroView;
    private Button bMove;
    private Button btnTags;
    private Button bUser;
    private Button bExport;
    private Button bExportMovimentacao;
    private Button bExportStatus;
    private Button bData;
    private EstruturaComplemento complemento;
    private Registration openListner;
    private final long tempoMaximoPesquisa;
    private final VerticalLayout containergrid;
    private DownloadDialog dd;

    public PainelAtividadesView(ProducaoPainelRepository ppr, PedidoOrigemService pos, EstruturaSenhasService estruturaSenhasService, PedidoService pedidoService, PedidoEtapaService pedidoEtapaService, EstruturaUsuarioService eus, PedidoTagsService pedidoTagsService, UsuarioTagService usuarioTagService, EstruturaComplementoService complementoService, PedidoAnexoService pedidoAnexoService, PedidoMovimentacaoService pedidoMovimentacaoService, PedidoVinculoService pedidoVinculoService, EquipeService equipeService, ConfigurationsService configurationsService, PedidoEmailRepository pedidoEmailRepository, AtividadeView atividadeView, PainelAtividadeExportacaoService painelAtividadeExportacao, UsuarioHierarquiaService hierarquiaService, PedidoLogService pedidoLogService, GridOrderService gridOrderService, UsuarioService usuarioService, WhatsAppAtendimentoCreate whatsAppAtendimentoCreate, WhatsAppAtendimentoService whatsAppAtendimentoService, WhatsAppViewDialog whatsAppViewDialog, PedidoDeleteService pedidoDeleteService, ClienteContatoView clienteContatoView, PedidoEtapaGrupoService pegs, PedidoCategoriaService pedidoCategoriaService, PedidoSubCategoriaService pedidoSubCategoriaService, ProdutoService produtoService) {
        this.pedidoEmailRepository = pedidoEmailRepository;
        this.pegs = pegs;
        this.produtoService = produtoService;
        this.pedidoDeleteService = pedidoDeleteService;
        this.clienteContatoView = clienteContatoView;
        this.pedidoCategoriaService = pedidoCategoriaService;
        this.pedidoSubCategoriaService = pedidoSubCategoriaService;
        this.estruturaComplementoService = complementoService;
        this.whatsAppAtendimentoService = whatsAppAtendimentoService;
        this.whatsAppViewDialog = whatsAppViewDialog;
        this.whatsAppAtendimentoCreate = whatsAppAtendimentoCreate;
        this.usuarioService = usuarioService;
        this.gridOrderService = gridOrderService;
        this.painelAtividadeExportacao = painelAtividadeExportacao;
        this.atividadeView = atividadeView;
        this.pedidoVinculoService = pedidoVinculoService;
        this.hierarquiaService = hierarquiaService;
        this.equipeService = equipeService;
        this.pedidoMovimentacaoService = pedidoMovimentacaoService;
        this.ppr = ppr;
        this.pedidoLogService = pedidoLogService;
        this.pos = pos;
        this.usuarioTagService = usuarioTagService;
        this.estruturaSenhasService = estruturaSenhasService;
        this.pedidoService = pedidoService;
        this.pedidoEtapaService = pedidoEtapaService;
        this.eus = eus;
        this.pedidoTagsService = pedidoTagsService;
        this.hierarquia = this.hasPermission("IGNORAR_HIERARQUIA") ? new HashSet() : hierarquiaService.getHierarquia(this.getEu());
        this.pedidoAnexoService = pedidoAnexoService;
        this.containergrid = new VerticalContainer(new Component[0]);
        this.tempoMaximoPesquisa = configurationsService.get(ConfigurationEnum.TEMPO_MAXIMO_PESQUISA).getLongValue();
        this.complemento = complementoService.getComplementos(this.getEstrutura());
    }

    protected void onAttach(AttachEvent attachEvent) {
        if (this.autenticado()) {
            this.setViewContent(this.createContent());
            this.povoaProdutos();
        }
    }

    protected void onDetach(DetachEvent detachEvent) {
        this.clear();
        this.filter = null;
        this.lblRegistros = null;
        this.bCount = null;
        this.btnFiltroView = null;
        this.bMove = null;
        this.btnTags = null;
        this.bUser = null;
        this.bExport = null;
        this.bExportMovimentacao = null;
        this.bExportStatus = null;
        this.bData = null;
        this.openListner = null;
        this.grid = null;
        super.onDetach(detachEvent);
    }

    private void clear() {
        if (this.openListner != null) {
            this.openListner.remove();
        }
    }

    private Component createContent() {
        this.dd = new DownloadDialog();
        this.removeAll();
        this.containergrid.setHeight("100%");
        VerticalContainer mainContainer = new VerticalContainer(new Component[0]);
        mainContainer.setHeightFull();
        this.lblRegistros = new Span();
        UIUtils.setFontSize((FontSize)FontSize.XXS, (Component[])new Component[]{this.lblRegistros});
        this.bMove = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.ARROW_FORWARD, (String)"Movimentar atividade");
        this.bMove.setId("btnMovimentarAtividade");
        this.bMove.setEnabled(this.hasPermission("PAINEL_ATIVIDADE_ETAPA_CHANGE"));
        this.bMove.addClickListener((ComponentEventListener & Serializable)e -> this.movimentarEmLote(MovimentacaoEnum.ALTERAR_ETAPA));
        this.btnTags = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.TAGS, (String)"Tags da atividade");
        this.btnTags.setId("btnTags");
        this.btnTags.setEnabled(this.hasPermission("ATIVIDADE_TAG_CHANGE"));
        this.btnTags.addClickListener((ComponentEventListener & Serializable)e -> this.movimentarEmLote(MovimentacaoEnum.ALTERAR_TAGS));
        this.bUser = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.USER, (String)"Alterar usu\u00e1rio da atividade");
        this.bUser.setId("btnAlterarUsuario");
        this.bUser.setEnabled(this.hasPermission("PAINEL_ATIVIDADE_USER_CHANGE"));
        this.bUser.addClickListener((ComponentEventListener & Serializable)e -> this.movimentarEmLote(MovimentacaoEnum.ALTERAR_USUARIO));
        this.bExport = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.TABLE, (String)"Exportar atividades");
        this.bExport.setId("btnExportarAtividades");
        this.bExport.setEnabled(this.hasPermission("ATIVIDADE_EXPORTACAO"));
        this.bExport.addClickListener((ComponentEventListener & Serializable)e -> this.movimentarEmLote(MovimentacaoEnum.EXPORTAR));
        this.bExportMovimentacao = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.FILE_TREE_SUB, (String)"Exportar Movimenta\u00e7\u00f5es");
        this.bExportMovimentacao.setId("btnExportarMovimentacoes");
        this.bExportMovimentacao.setEnabled(this.hasPermission("ATIVIDADE_EXPORTACAO"));
        this.bExportMovimentacao.addClickListener((ComponentEventListener & Serializable)e -> this.movimentarEmLote(MovimentacaoEnum.EXPORTAR_MOVIMENTACAO));
        this.bExportStatus = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.CLOCK, (String)"Exportar Movimenta\u00e7\u00f5es de Status");
        this.bExportStatus.setId("btnExportarStatus");
        this.bExportStatus.setEnabled(this.hasPermission("ATIVIDADE_EXPORTACAO"));
        this.bExportStatus.addClickListener((ComponentEventListener & Serializable)e -> this.movimentarEmLote(MovimentacaoEnum.EXPORTAR_STATUS));
        this.bData = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.CALENDAR_CLOCK, (String)"Alterar datas da atividade");
        this.bData.setId("btnAlterarDatas");
        this.bData.setEnabled(this.hasPermission("ATIVIDADE_DATA_CHANGE"));
        this.bData.addClickListener((ComponentEventListener & Serializable)e -> this.movimentarEmLote(MovimentacaoEnum.ALTERAR_DATA));
        this.filter = new PainelAtividadeFilter(this.hierarquia, this.pos, this.pedidoEtapaService, this.pedidoTagsService, this.getEu(), this.estruturaSenhasService, this.equipeService, this.usuarioTagService, this.hierarquiaService, this.usuarioService, this.pegs, this.pedidoCategoriaService, this.pedidoSubCategoriaService, this.estruturaComplementoService);
        this.filter.getBtnPesquisar().addClickListener((ComponentEventListener & Serializable)e -> {
            this.filter.getFireRed().setText("");
            this.filter.getFireGreen().setText("");
            this.filter.setSla(null);
            this.bCount.setVisible(true);
            this.povoa();
        });
        this.filter.getRbTipo().addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            this.configurarColunas();
            this.povoa();
            this.povoaProdutos();
        });
        this.filter.getBtnInserir().addClickListener((ComponentEventListener & Serializable)e -> {
            if (((PedidoTipoEnum)this.filter.getRbTipo().getValue()).equals((Object)PedidoTipoEnum.WHATSAPP)) {
                this.createWhats();
            } else {
                this.abrePedido(null, this.filter.getBtnInserir());
            }
            this.filter.getBtnInserir().setEnabled(true);
        });
        this.filter.getFireGreen().addClickListener((ComponentEventListener & Serializable)e -> {
            this.filter.getFireGreen().setText("Selecionado");
            this.filter.getFireRed().setText("");
            this.filter.setSla(PedidoSlaENUM.NO_PRAZO);
            this.povoa();
        });
        this.filter.getFireRed().addClickListener((ComponentEventListener & Serializable)e -> {
            this.filter.getFireRed().setText("Selecionado");
            this.filter.getFireGreen().setText("");
            this.filter.setSla(PedidoSlaENUM.FORA_DO_PRAZO);
            this.povoa();
        });
        this.btnFiltroView = UIUtils.createSmallButton((String)"Esconder Filtro");
        this.btnFiltroView.setWidthFull();
        this.btnFiltroView.addClickListener((ComponentEventListener & Serializable)e -> this.changeFiltroView());
        this.bCount = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.ABACUS, (String)"Contar Registro");
        this.bCount.addClickListener((ComponentEventListener & Serializable)e -> {
            try {
                this.bCount.setVisible(false);
                ProducaoPedidoFilter f = this.filter.getFilter();
                f.setKanban(false);
                Integer total = (int)this.ppr.countProducaoByPedido(this.getEu(), f);
                this.lblRegistros.setText(total.toString());
            }
            catch (Exception ex) {
                this.showNotification(ex.getMessage());
            }
        });
        this.configurarColunas();
        mainContainer.add(new Component[]{this.filter, this.btnFiltroView, this.containergrid});
        return mainContainer;
    }

    private void povoa() {
        ProducaoPedidoFilter f;
        try {
            this.filter.getBtnPesquisar().setEnabled(true);
            this.filter.getFireGreen().setEnabled(true);
            this.filter.getFireRed().setEnabled(true);
            f = this.filter.getFilter();
            if (!f.getFilterNomeCliente().isEmpty() && f.getFilterNomeCliente().length() < 3) {
                this.showNotification("Nome do cliente deve ter pelo menos 3 letras");
                return;
            }
            if (f.getConsiderarDatas().booleanValue() && f.getDataFinalAtualizacao() == null && f.getDataInicialAtualizacao() == null && f.getDataFinalCadatro() == null && f.getDataInicialCadastro() == null) {
                this.showNotification("Para considerar datas informe um periodo de cadastro ou atualizacao");
                return;
            }
            if (f.getConsiderarDatas().booleanValue() && f.getDataFinalAtualizacao() == null && f.getDataInicialAtualizacao() != null || f.getConsiderarDatas().booleanValue() && f.getDataFinalAtualizacao() != null && f.getDataInicialAtualizacao() == null) {
                this.showNotification("Insira data INICIAL e FINAL de atualiza\u00e7\u00e3o");
                return;
            }
            if (f.getConsiderarDatas().booleanValue() && f.getDataFinalCadatro() == null && f.getDataInicialCadastro() != null || f.getConsiderarDatas().booleanValue() && f.getDataFinalCadatro() != null && f.getDataInicialCadastro() == null) {
                this.showNotification("Insira data INICIAL e FINAL de cadastro");
                return;
            }
            if (!f.getConsiderarDatas().booleanValue() && f.getFilterPedidoEtapa().isEmpty() && f.getFilterNumeroPedido().isEmpty() && f.getFilterCnpj().isEmpty() && this.filter.getCbHierarquia().getValue() == null) {
                this.showNotification("Precisa pelo menos de um filtro de data ou de etapa ou atividade ou cpf/cnpj ou propriet\u00e1rio");
                return;
            }
            if (f.getFilterPedidoEtapa().isEmpty() && f.getFilterNumeroPedido().isEmpty() && f.getFilterCnpj().isEmpty() && this.filter.getCbHierarquia().getValue() == null) {
                long diferencaEmDias;
                if (f.getDataInicialAtualizacao() != null && f.getDataFinalAtualizacao() != null && (diferencaEmDias = DateTimeUtil.diferencaEmDias((LocalDate)f.getDataInicialAtualizacao(), (LocalDate)f.getDataFinalAtualizacao())) > this.tempoMaximoPesquisa) {
                    this.showNotification("M\u00e1ximo de tempo de pesquisa \u00e9 de " + this.tempoMaximoPesquisa + " dias.");
                    return;
                }
                if (f.getDataInicialCadastro() != null && f.getDataFinalCadatro() != null && (diferencaEmDias = DateTimeUtil.diferencaEmDias((LocalDate)f.getDataInicialCadastro(), (LocalDate)f.getDataFinalCadatro())) > this.tempoMaximoPesquisa) {
                    this.showNotification("M\u00e1ximo de tempo de pesquisa \u00e9 de " + this.tempoMaximoPesquisa + " dias.");
                    return;
                }
            }
        }
        catch (Exception e) {
            this.showNotification(e.getMessage());
            return;
        }
        this.grid.setItems(new ArrayList());
        this.lblRegistros.setText("");
        try {
            f = this.filter.getFilter();
            f.setKanban(false);
            this.grid.setPageSize(60);
            this.grid.setItems((CallbackDataProvider.FetchCallback & Serializable)query -> {
                query.getRequestedRangeEnd();
                return this.ppr.getProducaoByPedido(this.getEu(), f, Boolean.valueOf(false), (Pageable)PageRequest.of((int)query.getPage(), (int)query.getPageSize())).stream();
            });
        }
        catch (Exception e) {
            this.showNotification(e.getMessage());
        }
    }

    private void moveEtapa(List<ProducaoPedidoDTO> lista) {
        DialogAlterarEtapa dae = new DialogAlterarEtapa(lista, this.getEu(), this.pedidoService, this.pedidoEtapaService, this.pos, (PedidoTipoEnum)this.filter.getRbTipo().getValue());
        dae.open();
        dae.getDialog().addOpenedChangeListener((ComponentEventListener & Serializable)close -> {
            if (!close.isOpened()) {
                SleepUtil.inSeconds((Integer)3);
                this.povoa();
            }
        });
    }

    private void changeTags(List<ProducaoPedidoDTO> lista) {
        Dialog dialog = new Dialog();
        ComboBox tags = new ComboBox("Tags", (Collection)this.pedidoTagsService.getTags(this.getEstrutura(), (PedidoTipoEnum)this.filter.getRbTipo().getValue()));
        tags.setWidth("100%");
        tags.setItemLabelGenerator(PedidoTags::getTag);
        RadioButtonGroup rb = new RadioButtonGroup();
        rb.setItems((Object[])AtividadeTagsActionEnum.values());
        rb.setValue((Object)AtividadeTagsActionEnum.INSERIR);
        Button b = UIUtils.createSmallButton((String)"Confirmar", (VaadinIcon)VaadinIcon.CHECK);
        b.addClickListener((ComponentEventListener & Serializable)e -> {
            if (tags.getValue() == null && !((AtividadeTagsActionEnum)rb.getValue()).equals((Object)AtividadeTagsActionEnum.LIMPAR)) {
                this.showNotification("Informe pelo menos uma tag");
                return;
            }
            this.pedidoService.alterarTags((AtividadeTagsActionEnum)rb.getValue(), this.getEu(), lista, (PedidoTipoEnum)this.filter.getRbTipo().getValue(), (PedidoTags)tags.getValue(), this.hasPermission("ATIVIDADE_MOVER_NAO_EDITAVEIS"), lista.size() == 1);
            this.povoa();
            UIUtils.showProcessNotification();
            dialog.close();
        });
        Button f = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE);
        f.addClickListener((ComponentEventListener & Serializable)e -> dialog.close());
        dialog.add(new Component[]{new VerticalContainer(new Component[]{rb, tags, new FooterContainer(new Component[]{f, b})})});
        dialog.open();
    }

    private void encarteirar(List<ProducaoPedidoDTO> lista) {
        DialogAlterarUsuario dau = new DialogAlterarUsuario(this.getEu(), lista, this.pedidoService, this.eus, this.hierarquiaService);
        dau.open();
        dau.getDialog().addOpenedChangeListener((ComponentEventListener & Serializable)close -> {
            if (!close.isOpened()) {
                this.povoa();
            }
        });
    }

    private void changeData(List<ProducaoPedidoDTO> lista) {
        Dialog dialog = new Dialog();
        DatePicker data = new DatePicker();
        data.setLabel("Data Referencia");
        data.setValue(LocalDate.now());
        data.setLocale(UIUtils.getLocale());
        Button bClose = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE);
        bClose.addClickListener((ComponentEventListener & Serializable)e -> dialog.close());
        Button bConfirm = UIUtils.createSmallButton((String)"Confirmar", (VaadinIcon)VaadinIcon.CHECK);
        bConfirm.addClickListener((ComponentEventListener & Serializable)e -> {
            if (data.getValue() == null) {
                this.showNotification("Selecione uma data valida");
                return;
            }
            this.pedidoService.alterarData(this.getEu(), lista, (LocalDate)data.getValue(), this.hasPermission("ATIVIDADE_MOVER_NAO_EDITAVEIS"));
            UIUtils.showProcessNotification();
            dialog.close();
        });
        dialog.add(new Component[]{new VerticalContainer(new Component[]{data, new FooterContainer(new Component[]{bClose, bConfirm})})});
        dialog.open();
    }

    private void movimentarEmLote(MovimentacaoEnum tipo) {
        if (!this.grid.getSelectedItems().isEmpty()) {
            this.movimentar(tipo, new ArrayList(this.grid.getSelectedItems()));
            return;
        }
        if (!tipo.equals((Object)MovimentacaoEnum.EXPORTAR) && !this.hasPermission("ATIVIDADE_ALTERACAO_EM_LOTE")) {
            this.showNotification("Voc\u00ea n\u00e3o tem Permiss\u00e3o para movimenta\u00e7\u00e3o em LOTE");
            return;
        }
        try {
            List lista = this.ppr.getProducaoByPedido(this.getEu(), this.filter.getFilter(), Boolean.valueOf(false), null);
            Dialog dialog = new Dialog();
            Div div = new Div();
            div.getElement().setProperty("innerHTML", "<span>Voc\u00ea est\u00e1 prestes a <B>" + String.valueOf(tipo) + "</B> de <B>" + lista.size() + "</b> Atividades, tem certeza que quer fazer isso?<BR>Caso afirmativo, digite o n\u00famero de atividades no campo abaixo.</span>");
            NumberField antiBosta = new NumberField("Confirme nro atividades");
            antiBosta.setWidth("180px");
            Button btnClose = UIUtils.createSmallButton((String)"Cancelar", (VaadinIcon)VaadinIcon.CLOSE);
            btnClose.setId("btnCloseMovimentacao");
            btnClose.addClickListener((ComponentEventListener & Serializable)e -> dialog.close());
            Button btnConfirmar = UIUtils.createSmallButton((String)"Sim, Tenho certeza", (VaadinIcon)VaadinIcon.CHECK);
            btnConfirmar.setId("btnConfirmarMovimentacao");
            btnConfirmar.addClickListener((ComponentEventListener & Serializable)e -> {
                if (antiBosta.getValue() == null || ((Double)antiBosta.getValue()).intValue() != lista.size()) {
                    this.showNotification("Quantidade n\u00e3o bate");
                    return;
                }
                try {
                    this.movimentar(tipo, lista);
                    if (!tipo.name().contains("EXPORTAR")) {
                        this.povoa();
                    }
                    dialog.close();
                }
                catch (Exception ex) {
                    UIUtils.showNotification((String)("Erro ao movimentar em lote " + ex.getMessage()));
                }
            });
            dialog.add(new Component[]{new VerticalContainer(new Component[]{div, antiBosta, new FooterContainer(new Component[]{btnClose, btnConfirmar})})});
            dialog.open();
        }
        catch (Exception e2) {
            this.showNotification(e2.getMessage());
        }
    }

    private void movimentar(MovimentacaoEnum tipo, List<ProducaoPedidoDTO> lista) {
        HashSet<Long> listaId = new HashSet<Long>();
        for (ProducaoPedidoDTO ppd : lista) {
            listaId.add(ppd.getId());
        }
        switch (1.$SwitchMap$br$com$system$app$features$pedido$view$atividade$MovimentacaoEnum[tipo.ordinal()]) {
            case 1: {
                this.encarteirar(lista);
                break;
            }
            case 2: {
                this.moveEtapa(lista);
                break;
            }
            case 3: {
                this.changeTags(lista);
                break;
            }
            case 4: {
                this.changeData(lista);
                break;
            }
            case 5: {
                String url = this.painelAtividadeExportacao.export(this.getEu(), (PedidoTipoEnum)this.filter.getRbTipo().getValue(), lista, this.getEstrutura(), this.complemento);
                this.dd.open(url, "Exportacao Atividade.xlsx", true);
                break;
            }
            case 6: {
                String url = this.painelAtividadeExportacao.exportMovimentacao(this.getEu(), listaId);
                this.dd.open(url, "Exportacao Movimentacao.xlsx", true);
                break;
            }
            case 7: {
                String url = this.painelAtividadeExportacao.exportStatus(this.getEu(), listaId, this.getEstrutura());
                this.dd.open(url, "Exportacao Status.xlsx", true);
                break;
            }
        }
    }

    private HorizontalContainer getOptions(ProducaoPedidoDTO pedidoDto) {
        HorizontalContainer container = new HorizontalContainer(new Component[0]).setSpacingOff();
        container.setSpacing(false);
        Button bMail = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.ENVELOPES_O, (String)"E-mails enviados ao cliente");
        bMail.setVisible(pedidoDto.getPedidoTipo().equals((Object)PedidoTipoEnum.COMERCIAL));
        Button bEdit = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PENCIL, (String)"Abrir atividade");
        bEdit.setDisableOnClick(true);
        Button bClip = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PAPERCLIP, (String)"Anexos da atividade");
        Button bAnchor = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.ANCHOR, (String)"Vincular atividade com operadora");
        bAnchor.setEnabled(this.hasPermission("PAINEL_ATIVIDADE_VINCULO"));
        bAnchor.setVisible(this.isTelefonia());
        Button bInfo = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.INFO_CIRCLE_O, (String)"Informa\u00e7\u00f5es iniciais da atividade");
        bInfo.setVisible(!pedidoDto.getPedidoTipo().equals((Object)PedidoTipoEnum.WHATSAPP));
        Button bRecords = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.RECORDS, (String)"Movimenta\u00e7\u00f5es da atividade");
        Button bContatos = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PHONE_LANDLINE, (String)"Contatos V\u00e1lidos do cliente");
        ((Icon)bContatos.getIcon()).setColor(Color.GREEN.getValue());
        bContatos.setEnabled(pedidoDto.getId() != null);
        bContatos.addClickListener((ComponentEventListener & Serializable)e -> {
            Pedido pedido = this.pedidoService.getById(pedidoDto.getId());
            this.clienteContatoView.show(pedido.getCliente(), pedido.getId());
        });
        Icon iconFire = new Icon(VaadinIcon.FIRE);
        Button bFire = UIUtils.createSmallButton((Icon)iconFire, (String)"SLA");
        Integer tempo = pedidoDto.getTempo() == null || !pedidoDto.getTempo().contains(":") ? 0 : Integer.valueOf(pedidoDto.getTempo().split(":")[0]);
        if (pedidoDto.getTempo() != null && pedidoDto.getSlaHoras() != null && pedidoDto.getSlaHoras() > 0 && tempo > pedidoDto.getSlaHoras()) {
            iconFire.setColor(Color.RED.getValue());
            UIUtils.setTooltip((String)"Fora do Prazo", (Component[])new Component[]{bFire});
        } else {
            iconFire.setColor(Color.GREEN.getValue());
            UIUtils.setTooltip((String)"No Prazo", (Component[])new Component[]{bFire});
        }
        bMail.addClickListener((ComponentEventListener & Serializable)e -> {
            Pedido pedido = this.pedidoService.getById(pedidoDto.getId());
            new PedidoEmailView(pedido, this.pedidoEmailRepository);
        });
        bRecords.addClickListener((ComponentEventListener & Serializable)e -> {
            Pedido pedido = this.pedidoService.getById(pedidoDto.getId());
            new PedidoMovimentacaoView(pedido, this.pedidoMovimentacaoService, this.pedidoLogService, this.pedidoService);
        });
        bInfo.addClickListener((ComponentEventListener & Serializable)e -> {
            Pedido pedido = this.pedidoService.getById(pedidoDto.getId());
            InformationDialog.show((String)"Informa\u00e7\u00f5es", (String)this.pedidoService.getInformacoesPedido(pedido, this.getTipoEstrutura()));
        });
        bClip.addClickListener((ComponentEventListener & Serializable)e -> {
            Pedido pedido = this.pedidoService.getById(pedidoDto.getId());
            new PedidoAnexoView(pedido, this.getEu(), this.pedidoAnexoService);
        });
        bEdit.addClickListener((ComponentEventListener & Serializable)e -> {
            Pedido pedido = this.pedidoService.getById(pedidoDto.getId());
            this.abrePedido(pedido, bEdit);
            bEdit.setEnabled(true);
        });
        bAnchor.addClickListener((ComponentEventListener & Serializable)e -> {
            Pedido pedido = this.pedidoService.getById(pedidoDto.getId());
            if (!this.hasPermission("ATIVIDADE_MOVER_NAO_EDITAVEIS") && !pedido.getPedidoEtapa().isEditavel()) {
                this.showNotification("Etapa n\u00e3o editavel");
                return;
            }
            if (this.getTipoEstrutura().equals((Object)EstruturaTipoEnum.VIVO)) {
                DialogVincularVivo dv = new DialogVincularVivo(pedido, this.getEu(), this.pedidoVinculoService, this.estruturaSenhasService);
                dv.create();
                dv.addOpenedChangeListener((ComponentEventListener & Serializable)close -> {
                    if (!close.isOpened()) {
                        this.povoa();
                    }
                });
            } else if (this.getTipoEstrutura().equals((Object)EstruturaTipoEnum.CLARO)) {
                DialogVincularClaro dv = new DialogVincularClaro(pedido, this.getEu(), this.pedidoVinculoService, this.estruturaSenhasService);
                dv.create();
                dv.addOpenedChangeListener((ComponentEventListener & Serializable)close -> {
                    if (!close.isOpened()) {
                        this.povoa();
                    }
                });
            } else if (this.getTipoEstrutura().equals((Object)EstruturaTipoEnum.TIM)) {
                DialogVincularTim dt = new DialogVincularTim(pedido, this.getEu(), this.pedidoVinculoService, this.estruturaSenhasService);
                dt.create();
                dt.addOpenedChangeListener((ComponentEventListener & Serializable)close -> {
                    if (!close.isOpened()) {
                        this.povoa();
                    }
                });
            } else if (this.getTipoEstrutura().equals((Object)EstruturaTipoEnum.OI)) {
                DialogVincularOi doi = new DialogVincularOi(pedido, this.getEu(), this.pedidoVinculoService, this.estruturaSenhasService);
                doi.create();
                doi.addOpenedChangeListener((ComponentEventListener & Serializable)close -> {
                    if (!close.isOpened()) {
                        this.povoa();
                    }
                });
            } else if (this.getTipoEstrutura().equals((Object)EstruturaTipoEnum.CONSULTORIA)) {
                DialogVincularConsultoria doi = new DialogVincularConsultoria(pedido, this.getEu(), this.pedidoVinculoService, this.estruturaSenhasService);
                doi.create();
                doi.addOpenedChangeListener((ComponentEventListener & Serializable)close -> {
                    if (!close.isOpened()) {
                        this.povoa();
                    }
                });
            } else if (this.getTipoEstrutura().equals((Object)EstruturaTipoEnum.PROVEDOR)) {
                DialogVincularProvedor dvp = new DialogVincularProvedor(pedido, this.getEu(), this.pedidoVinculoService, this.estruturaSenhasService);
                dvp.create();
                dvp.addOpenedChangeListener((ComponentEventListener & Serializable)close -> {
                    if (!close.isOpened()) {
                        this.povoa();
                    }
                });
            }
        });
        Button bExcluir = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.TRASH, (String)"Excluir");
        bExcluir.setVisible(this.isMaster() && !pedidoDto.getPedidoTipo().equals((Object)PedidoTipoEnum.WHATSAPP));
        bExcluir.addClickListener((ComponentEventListener & Serializable)e -> {
            ConfirmationDialog cd = new ConfirmationDialog("Excluir PEDIDO", "Confirma exclus\u00e3o do Pedido? Essa a\u00e7\u00e3o n\u00e3o tem volta.");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                Pedido pedido = this.pedidoService.getById(pedidoDto.getId());
                try {
                    this.pedidoDeleteService.delete(pedido);
                }
                catch (Exception e1) {
                    UIUtils.showError((String)("Erro ao excluir pedido " + e1.getMessage()));
                }
                this.povoa();
                cd.close();
            });
        });
        Button bWhats = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.COMMENTS_O, (String)"Abrir conversa");
        bWhats.setId("btnWhats");
        bWhats.setVisible(pedidoDto.getPedidoTipo().equals((Object)PedidoTipoEnum.WHATSAPP));
        bWhats.addClickListener((ComponentEventListener & Serializable)e -> {
            try {
                WhatsAppAtendimento wa = this.whatsAppAtendimentoService.getByPedido(pedidoDto.getId());
                if (wa == null) {
                    this.whatsAppAtendimentoCreate.create(null, this.pedidoService.getById(pedidoDto.getId()), this.getEu());
                    this.openListner = this.whatsAppAtendimentoCreate.addOpenedChangeListener((ComponentEventListener & Serializable)op -> {
                        if (!op.isOpened()) {
                            bWhats.setIcon((Component)VaadinIcon.COMMENTS_O.create());
                            WhatsAppAtendimento atendimento = this.whatsAppAtendimentoService.getByPedido(pedidoDto.getId());
                            if (atendimento != null) {
                                this.whatsAppViewDialog.create(atendimento);
                            }
                        }
                    });
                } else {
                    bWhats.setIcon((Component)VaadinIcon.COMMENTS_O.create());
                    this.whatsAppViewDialog.create(wa);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        container.add(new Component[]{bFire, bAnchor, bEdit, bClip, bInfo, bRecords, bMail, bContatos, bWhats});
        if (this.isMaster()) {
            container.add(new Component[]{bExcluir});
        }
        return container;
    }

    private void abrePedido(Pedido pedido, Button btnRelease) {
        try {
            this.atividadeView.addOpenedChangeListener((ComponentEventListener & Serializable)s -> {
                if (s.isOpened()) {
                    return;
                }
                this.povoa();
            });
            this.atividadeView.create(pedido, this.getEu(), (PedidoTipoEnum)this.filter.getRbTipo().getValue(), this.produtos);
        }
        catch (Exception e) {
            this.showNotification(e.getMessage());
        }
    }

    private void setOrder() {
        try {
            String[] colunas = this.gridOrderService.getColuns(this.getEu(), this.grid, GridNameEnum.PAINEL_ATIVIDADE, (PedidoTipoEnum)this.filter.getRbTipo().getValue());
            if (colunas == null || colunas.length <= 0) {
                return;
            }
            ArrayList<Grid.Column> lista = new ArrayList<Grid.Column>();
            for (String k : colunas) {
                Grid.Column col = this.grid.getColumnByKey(k);
                if (col == null) continue;
                lista.add(col);
            }
            if (this.grid.getColumns().size() == lista.size()) {
                this.grid.setColumnOrder(lista);
            } else {
                this.gridOrderService.delete(this.getEu(), this.grid, GridNameEnum.PAINEL_ATIVIDADE, (PedidoTipoEnum)this.filter.getRbTipo().getValue());
            }
        }
        catch (Exception e) {
            this.gridOrderService.delete(this.getEu(), this.grid, GridNameEnum.PAINEL_ATIVIDADE, (PedidoTipoEnum)this.filter.getRbTipo().getValue());
        }
    }

    private void save(List<Grid.Column<ProducaoPedidoDTO>> columns) {
        ArrayList cols = new ArrayList();
        columns.forEach(c -> cols.add(c.getKey()));
        this.gridOrderService.save(this.getEu(), GridNameEnum.PAINEL_ATIVIDADE, cols, (PedidoTipoEnum)this.filter.getRbTipo().getValue());
    }

    private void changeFiltroView() {
        if (this.btnFiltroView.getText().equals("Esconder Filtro")) {
            this.btnFiltroView.setText("Mostrar Filtro");
            this.filter.setVisible(false);
        } else {
            this.btnFiltroView.setText("Esconder Filtro");
            this.filter.setVisible(true);
        }
    }

    private void createWhats() {
        this.whatsAppAtendimentoCreate.create(this.getEu());
        this.whatsAppAtendimentoCreate.addOpenedChangeListener((ComponentEventListener & Serializable)e -> {
            if (!e.isOpened()) {
                this.povoa();
            }
        });
    }

    private void povoaProdutos() {
        this.produtos = this.produtoService.getProdutosByOrigem(this.getEstrutura(), this.po);
    }

    private void configurarColunas() {
        this.grid = null;
        this.grid = new Grid(ProducaoPedidoDTO.class);
        this.grid.setMinHeight("350px");
        this.grid.addThemeVariants(new GridVariant[]{GridVariant.LUMO_ROW_STRIPES, GridVariant.LUMO_COMPACT});
        this.grid.setSelectionMode(Grid.SelectionMode.MULTI);
        this.grid.setColumnReorderingAllowed(true);
        this.grid.addColumnReorderListener((ComponentEventListener & Serializable)e -> this.save(e.getColumns()));
        this.containergrid.removeAll();
        this.containergrid.add(new Component[]{this.grid});
        this.grid.removeAllColumns();
        HorizontalContainer optionsContainer = new HorizontalContainer(new Component[]{this.lblRegistros, this.bMove, this.bUser, this.bData, this.btnTags, this.bExport, this.bExportMovimentacao, this.bExportStatus, this.bCount}).setSpacingOff();
        optionsContainer.setAlignItems(FlexComponent.Alignment.CENTER);
        optionsContainer.setSpacing(false);
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> this.getOptions(eg))).setKey("options").setWidth("200px").setHeader((Component)optionsContainer).setResizable(false);
        this.grid.addColumn("numeroPedido").setFlexGrow(0).setWidth("160px").setHeader("Numero").setResizable(true);
        if (this.isTelefonia() && ((PedidoTipoEnum)this.filter.getRbTipo().getValue()).equals((Object)PedidoTipoEnum.COMERCIAL)) {
            this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> {
                ProducaoPedidoDTO p = eg;
                if (p.getNumeroPedidoVinculado() != null && !p.getNumeroPedidoVinculado().isEmpty()) {
                    return UIUtils.createSmallSpan((String)p.getNumeroPedidoVinculado());
                }
                if (p.getNumeroCotacao() != null && !p.getNumeroCotacao().isEmpty()) {
                    return UIUtils.createSmallSpan((String)p.getNumeroCotacao());
                }
                if (p.getNumeroSimulacao() != null && !p.getNumeroSimulacao().isEmpty()) {
                    return UIUtils.createSmallSpan((String)p.getNumeroSimulacao());
                }
                return UIUtils.createSmallSpan((String)"");
            })).setKey("Vinculado").setWidth("180px").setHeader("Vinculado").setResizable(false);
            this.grid.addColumn("loginOperadora").setHeader("Login").setFlexGrow(0).setWidth("150px").setResizable(true);
        }
        if (((PedidoTipoEnum)this.filter.getRbTipo().getValue()).equals((Object)PedidoTipoEnum.WHATSAPP)) {
            this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)(p.getWhatsappNumero() == null ? "" : p.getWhatsappNumero())))).setHeader("Whatsapp").setFlexGrow(0).setWidth("160px");
            this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)(p.getWhatsappNome() == null ? "" : p.getWhatsappNome())))).setHeader("Nome Contato").setFlexGrow(0).setWidth("150px");
        }
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> {
            Span label = UIUtils.createBreakWrapSpan((String)eg.getNomeCliente());
            return label;
        })).setKey("nomeCliente").setHeader("Nome Cliente").setWidth("250px").setResizable(true);
        this.grid.addColumn("cpfCnpj").setFlexGrow(0).setWidth("180px").setResizable(true);
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> {
            String nmEtapa = eg.getNomeStatus() + " (" + eg.getNomeEtapaOrigem() + ")";
            Span label = UIUtils.createBreakWrapSpan((String)nmEtapa);
            return label;
        })).setKey("nomeStatus").setHeader("Etapa").setWidth("250px").setResizable(true);
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> {
            String categoria = eg.getPedidoCategoria();
            Span label = UIUtils.createBreakWrapSpan((String)categoria);
            return label;
        })).setKey("categoria").setHeader(this.complemento.getNomeCampoCategoria()).setWidth("250px").setResizable(true);
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> {
            String sub = eg.getPedidoSubCategoria();
            Span label = UIUtils.createBreakWrapSpan((String)sub);
            return label;
        })).setKey("subcategoria").setHeader(this.complemento.getNomeCampoSubCategoria()).setWidth("250px").setResizable(true);
        this.grid.addColumn("tempo").setFlexGrow(0).setWidth("160px").setHeader("Tempo").setResizable(true);
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataHoraUltimaMov() == null ? "" : UIUtils.formatDateTime((LocalDateTime)p.getDataHoraUltimaMov()))).setHeader("Ultima Mov").setKey("ultimaMovimentacao").setFlexGrow(0).setWidth("180px").setResizable(true);
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> {
            Span label = UIUtils.createBreakWrapSpan((String)eg.getNomeUsuario());
            return label;
        })).setKey("nomeUsuario").setHeader("Propriet\u00e1rio Atividade").setWidth("250px").setResizable(true);
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> {
            Span label = UIUtils.createBreakWrapSpan((String)eg.getNomeUsuarioAdm());
            return label;
        })).setKey("nomeUsuarioAdm").setHeader("Adm Atividade").setWidth("250px").setResizable(true);
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> {
            Span label = UIUtils.createBreakWrapSpan((String)eg.getTags());
            return label;
        })).setKey("tagsAtividade").setHeader("Tags Atividade").setWidth("250px").setResizable(true);
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> {
            Span label = UIUtils.createBreakWrapSpan((String)eg.getTagUsuario());
            return label;
        })).setKey("tagsUsuario").setHeader("Tags Usu\u00e1rio").setWidth("250px").setResizable(true);
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> {
            Span label = UIUtils.createBreakWrapSpan((String)eg.getEquipeUsuario());
            return label;
        })).setKey("equipeUsuario").setHeader("Equipe Usu\u00e1rio").setWidth("250px").setResizable(true);
        this.grid.addColumn("numeroPedidoOrigem").setHeader("Atividade Origem").setFlexGrow(0).setWidth("210px").setResizable(true);
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> UIUtils.formatDateTime((LocalDateTime)p.getDataHoraAtualizacao()))).setHeader("Atualiza\u00e7\u00e3o").setKey("atualizacao").setFlexGrow(0).setWidth("180px").setResizable(true);
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> UIUtils.formatDate((LocalDate)p.getDataCadastro()))).setHeader("Cadastro").setKey("cadastro").setFlexGrow(0).setWidth("180px").setResizable(true);
        this.setOrder();
    }
}

