/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.receitafederal.view;

import br.com.system.app.components.ListField;
import br.com.system.app.components.ListFieldTypeEnum;
import br.com.system.app.components.MultiComboBox;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.features.cep.model.CepLocalidade;
import br.com.system.app.features.cep.model.CepUf;
import br.com.system.app.features.cep.service.CepService;
import br.com.system.app.features.cnae.model.Cnae;
import br.com.system.app.features.cnae.service.CnaeService;
import br.com.system.app.features.configurations.model.ConfigurationEnum;
import br.com.system.app.features.configurations.service.ConfigurationsService;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaTipoService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.size.FontSize;
import br.com.system.app.features.mailing.model.MailingMeiFilterEnum;
import br.com.system.app.features.mailing.model.MailingPorte;
import br.com.system.app.features.mailing.repository.filter.MailingFilter;
import br.com.system.app.features.mailing.repository.filter.MailingFilterRodouEnum;
import br.com.system.app.features.mailing.repository.filter.MailingFilterViewEnum;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.shared.handle.HandlerExcel;
import br.com.system.app.features.util.TempFileMultiBuffer;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.ConversorUtil;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.dom.DomEventListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

public class ReceitaFilterView
implements Serializable,
SecurityContext {
    private static final long serialVersionUID = 1L;
    private final HorizontalContainer card;
    private final EstruturaTipoService estruturaTipoService;
    private final CepService cepService;
    private final CnaeService cnaeService;
    private final ConfigurationsService configurationsService;
    private final EstruturaUsuario euContext;
    private final HandlerExcel handlerExcel = new HandlerExcel();
    private ComboBox<CepUf> cbUf;
    private MultiComboBox<CepLocalidade> cbLocalidade;
    private MultiComboBox<String> cbDdd;
    private MultiComboBox<Cnae> cbCnae;
    private MultiComboBox<MailingPorte> cbPorte;
    private NumberField capitalInicial;
    private NumberField capitalFinal;
    private NumberField mesesAberturaMin;
    private NumberField mesesAberturaMax;
    private ListField listaCpfCnpj;
    private ListField listaCep;
    private ListField listaBairro;
    private TextField txtNome;
    private TextField txtNumero;
    private Checkbox cbFavoritos;
    private Checkbox cbAtivos;
    private Checkbox cbSomenteMatriz;
    private TempFileMultiBuffer mBuffer;
    private Upload upload;
    private Button btnPesquisar;
    private Checkbox cbCobertura;
    private ComboBox<MailingFilterViewEnum> view;
    private ComboBox<MailingFilterRodouEnum> oportunidade;
    private ComboBox<MailingFilterRodouEnum> enriquecimento;
    private ComboBox<MailingFilterRodouEnum> prospectBi;
    private ComboBox<MailingMeiFilterEnum> cbMei;
    private CepUf ufEstrutura;
    private MailingFilter filter;

    public ReceitaFilterView(CepService cepService, CnaeService cnaeService, EstruturaUsuario euContext, ConfigurationsService configurationsService, EstruturaTipoService estruturaTipoService) {
        this.cepService = cepService;
        this.estruturaTipoService = estruturaTipoService;
        this.configurationsService = configurationsService;
        this.cnaeService = cnaeService;
        this.euContext = euContext;
        this.card = new HorizontalContainer(new Component[0]);
        this.getFilterView();
    }

    public HorizontalContainer getCard() {
        return this.card;
    }

    private void getFilterView() {
        this.card.setSpacing(true);
        this.ufEstrutura = this.cepService.getUfBySigla(this.euContext.getEstrutura().getEstado());
        this.cbCobertura = new Checkbox("Somente Com Cobertura");
        this.cbCobertura.setVisible(this.estruturaTipoService.isVivo(this.euContext.getEstrutura()));
        this.listaCpfCnpj = new ListField(ListFieldTypeEnum.CPF_CNPJ, "Cnpj");
        this.listaCep = new ListField(ListFieldTypeEnum.CEP, "Cep");
        this.txtNome = new TextField("Raz\u00e3o Social");
        this.txtNome.setVisible(false);
        this.txtNumero = new TextField("N\u00famero");
        this.capitalInicial = new NumberField("Capital Inicial");
        this.capitalFinal = new NumberField("Capital Final");
        this.mesesAberturaMin = new NumberField("Meses Abertura Min");
        this.mesesAberturaMin.setStep(1.0);
        this.mesesAberturaMin.setMax(999.0);
        this.mesesAberturaMin.setWidth("140px");
        this.mesesAberturaMin.setTitle("Meses Abertura Min");
        this.mesesAberturaMax = new NumberField("Meses Abertura Max");
        this.mesesAberturaMax.setStep(1.0);
        this.mesesAberturaMax.setMax(999.0);
        this.mesesAberturaMax.setWidth("140px");
        this.mesesAberturaMax.setTitle("Meses Abertura Max");
        this.cbDdd = new MultiComboBox("DDD", (Collection)this.cepService.getDdd());
        this.cbDdd.setMaxWidth("80px");
        this.cbCnae = new MultiComboBox("CNAE", (Collection)this.cnaeService.getAll());
        this.cbCnae.setItemLabelGenerator(Cnae::getCodigoEDescricao);
        this.cbFavoritos = new Checkbox();
        this.cbFavoritos.setLabel("Somente Favoritos");
        this.cbFavoritos.setVisible(false);
        this.cbAtivos = new Checkbox();
        this.cbAtivos.setLabel("Somente Ativas");
        this.cbAtivos.setValue((Object)true);
        this.cbMei = new ComboBox("MEI", Arrays.asList(MailingMeiFilterEnum.values()));
        this.cbMei.setItemLabelGenerator(Enum::name);
        this.cbSomenteMatriz = new Checkbox();
        this.cbSomenteMatriz.setLabel("Somente Matriz");
        this.cbLocalidade = new MultiComboBox("Cidade", (Collection)this.cepService.getLocalidadeByUf(this.ufEstrutura));
        this.cbLocalidade.setItemLabelGenerator(CepLocalidade::getNome);
        this.cbUf = new ComboBox("Estado", (Collection)this.cepService.getUf());
        this.cbUf.setItemLabelGenerator(CepUf::getSigla);
        this.cbUf.setMaxWidth("80px");
        this.cbUf.setValue((Object)this.ufEstrutura);
        this.cbUf.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.cbLocalidade.setItems((Collection)this.cepService.getLocalidadeByUf((CepUf)e.getValue())));
        this.listaBairro = new ListField(ListFieldTypeEnum.GENERIC_STRING, "Bairro");
        UIUtils.setTooltip((String)"Para nome composto inserir entre aspas ex: \"Vila Velha\"", (Component[])new Component[]{this.listaBairro});
        this.view = new ComboBox("Visualizados");
        this.view.setItems((Object[])MailingFilterViewEnum.values());
        this.view.setValue((Object)MailingFilterViewEnum.INDIFERENTE);
        this.view.setItemLabelGenerator(Enum::name);
        this.oportunidade = new ComboBox("Rodou Oportunidade");
        this.oportunidade.setItems((Object[])MailingFilterRodouEnum.values());
        this.oportunidade.setValue((Object)MailingFilterRodouEnum.INDIFERENTE);
        this.oportunidade.setItemLabelGenerator(Enum::name);
        this.prospectBi = new ComboBox("Rodou ProspectBi");
        this.prospectBi.setItems((Object[])MailingFilterRodouEnum.values());
        this.prospectBi.setValue((Object)MailingFilterRodouEnum.INDIFERENTE);
        this.prospectBi.setVisible(this.isVivo());
        this.prospectBi.setItemLabelGenerator(Enum::name);
        this.enriquecimento = new ComboBox("Rodou Enriquecimento");
        this.enriquecimento.setItems((Object[])MailingFilterRodouEnum.values());
        this.enriquecimento.setValue((Object)MailingFilterRodouEnum.INDIFERENTE);
        this.enriquecimento.setItemLabelGenerator(Enum::name);
        this.cbPorte = new MultiComboBox("Porte", (Object[])MailingPorte.values());
        this.cbPorte.setItemLabelGenerator(Enum::name);
        UIUtils.setFontSize((FontSize)FontSize.XS, (Component[])new Component[]{this.view, this.oportunidade, this.cbFavoritos, this.cbAtivos, this.cbMei, this.cbSomenteMatriz});
        this.btnPesquisar = UIUtils.createSmallButton((String)"Pesquisar", (VaadinIcon)VaadinIcon.SEARCH, (String)"");
        this.btnPesquisar.setDisableOnClick(true);
        this.mBuffer = new TempFileMultiBuffer();
        this.upload = new Upload((Receiver)this.mBuffer);
        this.upload.setDropAllowed(false);
        this.upload.setMaxFiles(1);
        this.upload.setUploadButton((Component)UIUtils.createSmallButton((String)"Upload CEP/N\u00famero"));
        this.upload.setAcceptedFileTypes(new String[]{".xlsx"});
        this.upload.getElement().setProperty("title", "Inserir lista com CEP/NUMERO para pesquisa");
        this.upload.addFinishedListener((ComponentEventListener & Serializable)e -> UIUtils.showNotification((String)"Arquivo carregado com sucesso, clique em Pesquisar"));
        this.upload.addFileRejectedListener((ComponentEventListener & Serializable)event -> UIUtils.showNotification((String)"Arquivo corrompido ou Formato inv\u00e1lido, aceita apenas .xlxs"));
        this.upload.getElement().addEventListener("file-remove", (DomEventListener)new /* Unavailable Anonymous Inner Class!! */);
        Button btnClear = UIUtils.createSmallButton((String)"Limpar", (VaadinIcon)VaadinIcon.RECYCLE);
        btnClear.addClickListener((ComponentEventListener & Serializable)e -> this.clear());
        this.card.add(new Component[]{this.cbFavoritos, this.cbAtivos, this.cbSomenteMatriz, this.cbUf, this.cbLocalidade, this.listaBairro, this.cbMei, this.cbDdd, this.cbCnae, this.listaCpfCnpj, this.listaCep, this.txtNumero, this.cbPorte, this.capitalInicial, this.capitalFinal, this.mesesAberturaMin, this.mesesAberturaMax, this.txtNome, this.view, this.oportunidade, this.enriquecimento, this.prospectBi, this.cbCobertura, this.upload, this.btnPesquisar, btnClear});
    }

    public MailingFilter getMailigFilter() {
        if (this.filter == null) {
            this.filter = new MailingFilter();
        } else {
            this.filter.setFavorites(((Boolean)this.cbFavoritos.getValue()).booleanValue());
        }
        this.filter.setFilterStatus(((Boolean)this.cbAtivos.getValue()).booleanValue());
        this.filter.setFilterMei((MailingMeiFilterEnum)this.cbMei.getValue());
        this.filter.setOnlyParent(((Boolean)this.cbSomenteMatriz.getValue()).booleanValue());
        this.filter.setEstado(this.cbUf.getValue() != null ? ((CepUf)this.cbUf.getValue()).getSigla() : null);
        this.filter.setCepFilters(this.listaCep.getValue() == null ? new ArrayList() : new ArrayList(this.listaCep.getValue()));
        this.filter.setDocsFilters(this.listaCpfCnpj.getValue() == null ? new ArrayList() : new ArrayList(this.listaCpfCnpj.getValue()));
        this.filter.setBairroFilters(this.listaBairro.getValue() == null ? new ArrayList() : new ArrayList(this.listaBairro.getValue()));
        this.filter.setDddFilters(new ConversorUtil().setStringToInteger(this.cbDdd.getValue()));
        this.filter.setNome(this.txtNome.getValue());
        this.filter.setNumero(this.txtNumero.getValue());
        this.filter.setSomenteComCobertura(((Boolean)this.cbCobertura.getValue()).booleanValue());
        ArrayList cidadeFilters = new ArrayList();
        this.cbLocalidade.getValue().forEach(cid -> cidadeFilters.add(cid.getNome()));
        this.filter.setCidadeFilters(cidadeFilters);
        ArrayList cnaeFilters = new ArrayList();
        this.cbCnae.getValue().forEach(cnae -> cnaeFilters.add(cnae.getCodigo()));
        this.filter.setCnaeFilters(cnaeFilters);
        ArrayList porteFilters = new ArrayList();
        this.cbPorte.getValue().forEach(p -> porteFilters.add(p.toString()));
        this.filter.setPorteFilters(porteFilters);
        this.filter.setCapitalInicial((Double)this.capitalInicial.getValue());
        this.filter.setCapitalFinal((Double)this.capitalFinal.getValue());
        this.filter.setMesesAberturaMin(Integer.valueOf(this.mesesAberturaMin.getValue() == null ? 0 : ((Double)this.mesesAberturaMin.getValue()).intValue()));
        this.filter.setMesesAberturaMax(Integer.valueOf(this.mesesAberturaMax.getValue() == null ? 0 : ((Double)this.mesesAberturaMax.getValue()).intValue()));
        this.filter.setOportunidade((MailingFilterRodouEnum)this.oportunidade.getValue());
        this.filter.setSelectedView((MailingFilterViewEnum)this.view.getValue());
        this.filter.setEnriquecimento((MailingFilterRodouEnum)this.enriquecimento.getValue());
        this.filter.setProspectBi((MailingFilterRodouEnum)this.prospectBi.getValue());
        Set ceps = null;
        try {
            if (this.mBuffer != null && this.mBuffer.getInputStream().available() > 0) {
                ceps = this.handlerExcel.getFilterCep(this.mBuffer.getInputStream());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int limitecep = this.configurationsService.get(ConfigurationEnum.LIMITE_DIARIO_RECEITA_CEP).getIntValue();
        if (ceps != null && ceps.size() > limitecep) {
            throw new BusinessException("Quantidade de CEP's maior que o limit de " + limitecep + " di\u00e1rio");
        }
        this.filter.setFilterCep(ceps);
        return this.filter;
    }

    public ComboBox<CepUf> getCbUf() {
        return this.cbUf;
    }

    public MultiComboBox<CepLocalidade> getCbLocalidade() {
        return this.cbLocalidade;
    }

    public MultiComboBox<String> getCbDdd() {
        return this.cbDdd;
    }

    public MultiComboBox<Cnae> getCbCnae() {
        return this.cbCnae;
    }

    public ListField getListaCpfCnpj() {
        return this.listaCpfCnpj;
    }

    public ListField getListaCep() {
        return this.listaCep;
    }

    public ListField getListaBairro() {
        return this.listaBairro;
    }

    public void setListaBairro(ListField listaBairro) {
        this.listaBairro = listaBairro;
    }

    public TextField getTxtNome() {
        return this.txtNome;
    }

    public Checkbox getCbFavoritos() {
        return this.cbFavoritos;
    }

    public CepService getCepService() {
        return this.cepService;
    }

    public CnaeService getCnaeService() {
        return this.cnaeService;
    }

    public Button getBtnPesquisar() {
        return this.btnPesquisar;
    }

    public void clear() {
        this.cbFavoritos.clear();
        this.cbAtivos.setValue((Object)true);
        this.cbSomenteMatriz.clear();
        this.cbUf.setValue((Object)this.ufEstrutura);
        this.cbLocalidade.clear();
        this.listaBairro.clear();
        this.cbMei.clear();
        this.cbDdd.clear();
        this.cbCnae.clear();
        this.listaCpfCnpj.clear();
        this.listaCep.clear();
        this.txtNumero.clear();
        this.cbPorte.clear();
        this.capitalInicial.clear();
        this.capitalFinal.clear();
        this.mesesAberturaMin.clear();
        this.mesesAberturaMax.clear();
        this.txtNome.clear();
        this.view.setValue((Object)MailingFilterViewEnum.INDIFERENTE);
        this.oportunidade.setValue((Object)MailingFilterRodouEnum.INDIFERENTE);
        this.enriquecimento.setValue((Object)MailingFilterRodouEnum.INDIFERENTE);
        this.prospectBi.setValue((Object)MailingFilterRodouEnum.INDIFERENTE);
        this.cbCobertura.clear();
        this.mBuffer.clear();
        this.upload.clearFileList();
    }
}

