/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.resumoAbr;

import br.com.system.app.MainLayout;
import br.com.system.app.components.Card;
import br.com.system.app.components.DownloadDialog;
import br.com.system.app.components.ListField;
import br.com.system.app.components.ListFieldTypeEnum;
import br.com.system.app.features.layout.FlexBoxLayout;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.resumoAbr.model.ResumoAbrFile;
import br.com.system.app.features.resumoAbr.service.ResumoAbrService;
import br.com.system.app.features.shared.handle.HandlerExcel;
import br.com.system.app.features.util.TempFileMultiBuffer;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.FileUtil;
import br.com.system.commons.SleepUtil;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import elemental.json.Json;
import elemental.json.JsonValue;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;

@Route(value="resumoabr", layout=MainLayout.class)
@PageTitle(value="Consulta Portabilidade(ABR)")
@RolesAllowed(value={"ABR_VIEW"})
public class ResumoAbrView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final HandlerExcel handlerExcel = new HandlerExcel();
    private final ResumoAbrService ras;
    private String nomeArquivo = "";
    private DownloadDialog dd;
    private GridCrud<ResumoAbrFile> crud;

    @Autowired
    public ResumoAbrView(ResumoAbrService ras) {
        this.ras = ras;
    }

    protected void onAttach(AttachEvent attachEvent) {
        if (this.autenticado()) {
            this.setViewContent(this.createContent());
        }
    }

    private Component createContent() {
        this.dd = new DownloadDialog();
        FlexBoxLayout mainContainer = new FlexBoxLayout(FlexLayout.FlexDirection.COLUMN, new Component[0]).setSpacingM();
        Card cardUpload = this.createUpload();
        Card cardCampanha = this.createCampanha();
        FlexBoxLayout filterContainer = new FlexBoxLayout(FlexLayout.FlexDirection.ROW, new Component[]{cardUpload, cardCampanha}).setSpacingM();
        filterContainer.setFlexWrap(FlexLayout.FlexWrap.WRAP);
        filterContainer.setAlignItems(FlexComponent.Alignment.BASELINE);
        mainContainer.add(new Component[]{filterContainer, this.createCrud()});
        return mainContainer;
    }

    private Card createUpload() {
        TempFileMultiBuffer mBuffer = new TempFileMultiBuffer();
        Upload upload = new Upload((Receiver)mBuffer);
        upload.setAcceptedFileTypes(new String[]{".xlsx"});
        upload.setMaxFiles(1);
        upload.addFinishedListener((ComponentEventListener & Serializable)e -> {
            this.nomeArquivo = e.getFileName();
            UIUtils.showNotification((String)"Arquivo carregado, clique em processar");
        });
        upload.addFileRejectedListener((ComponentEventListener & Serializable)event -> UIUtils.showNotification((String)"Formato inv\u00e1lido, apenas .xlxs"));
        Button processar = UIUtils.createSmallButton((String)"Processar", (VaadinIcon)VaadinIcon.COGS, (String)"Iniciar processamento");
        processar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.nomeArquivo.isEmpty()) {
                UIUtils.showNotification((String)"Selecione o arquivo.");
            } else {
                Set lista = this.handlerExcel.getSetInCell(mBuffer.getInputStream(), 0, 0, true);
                this.ras.processar(this.getEu(), lista, this.nomeArquivo);
                upload.getElement().setPropertyJson("files", (JsonValue)Json.createArray());
                SleepUtil.inSeconds((Integer)3);
                this.crud.refreshGrid();
                this.nomeArquivo = "";
                mBuffer.clear();
            }
        });
        Card card = new Card();
        card.setHeader("Upload Arquivo");
        card.setContent(new Component[]{upload});
        card.setFooter(new Component[]{processar});
        card.getContentBox().setJustifyContentMode(FlexComponent.JustifyContentMode.BETWEEN);
        card.getContentBox().setHeightFull();
        card.setWidth("300px");
        card.setHeight("300px");
        return card;
    }

    private Card createCampanha() {
        TextField txtNomeProcesso = new TextField();
        txtNomeProcesso.setLabel("Nome Campanha");
        ListField txtListaNumeros = new ListField(ListFieldTypeEnum.TELEFONE, "Lista Telefones");
        txtListaNumeros.setLabel("Lista N\u00fameros");
        txtListaNumeros.setHeightFull();
        Button btnLista = UIUtils.createSmallButton((String)"Processar", (VaadinIcon)VaadinIcon.COGS, (String)"Iniciar processamento");
        btnLista.addClickListener((ComponentEventListener & Serializable)e -> {
            if (txtNomeProcesso.isEmpty() || txtListaNumeros.isEmpty()) {
                UIUtils.showNotification((String)"Nome Campanha e lista N\u00fameros s\u00e3o obrigat\u00f3rios.");
            } else {
                this.ras.processar(this.getEu(), txtListaNumeros.getValue(), "Campanha: " + txtNomeProcesso.getValue());
                SleepUtil.inSeconds((Integer)3);
                this.crud.refreshGrid();
                txtNomeProcesso.setValue("");
                txtListaNumeros.setValue("");
            }
        });
        Card card = new Card();
        card.setHeader("Criar Campanha");
        card.setContent(new Component[]{txtNomeProcesso, txtListaNumeros});
        card.setFooter(new Component[]{btnLista});
        card.getContentBox().setJustifyContentMode(FlexComponent.JustifyContentMode.BETWEEN);
        card.getContentBox().setHeightFull();
        card.setWidth("300px");
        card.setHeight("300px");
        return card;
    }

    private GridCrud<ResumoAbrFile> createCrud() {
        this.crud = new GridCrud(ResumoAbrFile.class);
        TextField filter = new TextField();
        filter.setPlaceholder("Filtrar por nome");
        filter.setClearButtonVisible(true);
        this.crud.getCrudLayout().addFilterComponent((Component)filter);
        this.crud.getGrid().setColumns(new String[]{"nomeArquivo", "statusProcesso"});
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> UIUtils.formatDateTime((LocalDateTime)p.getDataHoraImportacao())));
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getEstruturaUsuario().getUsuario().getNome())).setHeader("Usu\u00e1rio");
        this.crud.getGrid().addComponentColumn((ValueProvider & Serializable)item -> {
            Button b = UIUtils.createSmallButton((String)"Download");
            b.setVisible(item.getUrlArquivo() != null && !item.getUrlArquivo().isEmpty());
            b.addClickListener((ComponentEventListener & Serializable)e -> {
                String url;
                String string = url = item.getUrlArquivo() == null ? "" : item.getUrlArquivo();
                if (item.getUrlArquivo() == null) {
                    item.setUrlArquivo("");
                }
                if (item.getUrlArquivo().isEmpty()) {
                    b.setVisible(false);
                } else {
                    String ext = FileUtil.getExtension((String)item.getNomeArquivo());
                    if (ext == null || ext.isEmpty()) {
                        ext = FileUtil.getExtension((String)item.getUrlArquivo());
                        item.setNomeArquivo(item.getNomeArquivo() + ext);
                    }
                    this.dd.open(url, item.getNomeArquivo());
                }
            });
            return b;
        }).setHeader("Download");
        this.crud.getCrudFormFactory().setVisibleProperties(new String[]{"nomeArquivo"});
        this.crud.getGrid().addColumn("observacao");
        this.crud.getGrid().setColumnReorderingAllowed(true);
        this.crud.getAddButton().setVisible(false);
        this.crud.getUpdateButton().setVisible(false);
        this.crud.getDeleteButton().setVisible(this.hasPermission("ABR_DELETE_FILE"));
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        filter.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.crud.refreshGrid());
        return this.crud;
    }
}

