/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.serasa.service;

import br.com.system.app.features.serasa.dto.SerasaChequeDTO;
import br.com.system.app.features.serasa.dto.SerasaPendenciaDTO;
import br.com.system.app.features.serasa.dto.SerasaProtestoDTO;
import br.com.system.app.features.serasa.model.Serasa;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class SerasaHandler
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Serasa serasa;

    public SerasaHandler(Serasa serasa) {
        this.serasa = serasa;
    }

    public JSONArray getJsonPendenciasAndScp() {
        Set pendencias = this.getPendencias();
        JSONArray retorno = new JSONArray();
        for (SerasaPendenciaDTO p : pendencias) {
            retorno.put((Object)this.getJPend(p));
        }
        Set spcs = this.getSpc();
        for (SerasaPendenciaDTO spc : spcs) {
            retorno.put((Object)this.getJPend(spc));
        }
        return retorno;
    }

    private JSONObject getJPend(SerasaPendenciaDTO p) {
        JSONObject j = new JSONObject();
        j.put("origem", (Object)p.getOrigem());
        j.put("contrato", (Object)p.getContrato());
        j.put("valor", (Object)p.getValor());
        j.put("dataOcorrencia", (Object)p.getDataOcorrencia());
        j.put("titulo", (Object)p.getTitulo());
        return j;
    }

    public Set<SerasaPendenciaDTO> getPendencias() {
        HashSet<SerasaPendenciaDTO> retorno = new HashSet<SerasaPendenciaDTO>();
        try {
            JSONArray arr;
            JSONObject json = new JSONObject(this.serasa.getJsonResult());
            if (!json.has("pendencia-financeira")) {
                return retorno;
            }
            if (!(json = json.getJSONObject("pendencia-financeira")).has("detalhe-pendencia-financeira")) {
                return retorno;
            }
            try {
                arr = json.getJSONArray("detalhe-pendencia-financeira");
            }
            catch (Exception e) {
                try {
                    arr = new JSONArray();
                    arr.put((Object)json.getJSONObject("detalhe-pendencia-financeira"));
                }
                catch (Exception ex) {
                    return retorno;
                }
            }
            for (int i = 0; i < arr.length(); ++i) {
                SerasaPendenciaDTO s = new SerasaPendenciaDTO();
                JSONObject item = arr.getJSONObject(i);
                s.setContrato(item.get("contrato").toString());
                s.setDataOcorrencia(item.get("data-ocorrencia").toString().substring(0, 10));
                s.setOrigem(item.get("origem").toString());
                s.setTitulo(item.get("titulo-ocorrencia").toString());
                s.setValor(item.get("valor-pendencia").toString());
                retorno.add(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retorno;
    }

    public Set<SerasaPendenciaDTO> getSpc() {
        HashSet<SerasaPendenciaDTO> retorno = new HashSet<SerasaPendenciaDTO>();
        try {
            JSONArray arr;
            JSONObject json = new JSONObject(this.serasa.getJsonResult());
            if (!json.has("spc")) {
                return retorno;
            }
            if (!(json = json.getJSONObject("spc")).has("detalhe-spc")) {
                return retorno;
            }
            try {
                arr = json.getJSONArray("detalhe-spc");
            }
            catch (Exception e) {
                try {
                    arr = new JSONArray();
                    arr.put((Object)json.getJSONObject("detalhe-spc"));
                }
                catch (Exception ex) {
                    return retorno;
                }
            }
            for (int i = 0; i < arr.length(); ++i) {
                SerasaPendenciaDTO s = new SerasaPendenciaDTO();
                JSONObject item = arr.getJSONObject(i);
                s.setContrato(item.get("contrato").toString());
                s.setDataOcorrencia(item.get("data-inclusao").toString().substring(0, 10));
                s.setOrigem(item.get("nome-associado").toString());
                s.setTitulo("");
                s.setValor(item.get("valor").toString());
                retorno.add(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retorno;
    }

    public JSONArray getJsonProtestos() {
        Set protestos = this.getProtestos();
        JSONArray retorno = new JSONArray();
        for (SerasaProtestoDTO item : protestos) {
            JSONObject j = new JSONObject();
            j.put("cartorio", (Object)item.getCartorio());
            j.put("dataProtesto", (Object)item.getDataProtesto());
            j.put("valor", (Object)item.getValor());
            retorno.put((Object)j);
        }
        return retorno;
    }

    public Set<SerasaProtestoDTO> getProtestos() {
        HashSet<SerasaProtestoDTO> retorno = new HashSet<SerasaProtestoDTO>();
        try {
            JSONArray arr;
            JSONObject json = new JSONObject(this.serasa.getJsonResult());
            if (!json.has("protesto")) {
                return retorno;
            }
            if (!(json = json.getJSONObject("protesto")).has("detalhe-protesto")) {
                return retorno;
            }
            try {
                arr = json.getJSONArray("detalhe-protesto");
            }
            catch (Exception e) {
                try {
                    arr = new JSONArray();
                    arr.put((Object)json.getJSONObject("detalhe-protesto"));
                }
                catch (Exception ex) {
                    return retorno;
                }
            }
            for (int i = 0; i < arr.length(); ++i) {
                SerasaProtestoDTO s = new SerasaProtestoDTO();
                JSONObject item = arr.getJSONObject(i);
                JSONObject jCartorio = item.getJSONObject("cartorio");
                String cartorio = String.valueOf(jCartorio.get("nome")) + " " + String.valueOf(jCartorio.getJSONObject("cidade").get("nome")) + "-" + String.valueOf(jCartorio.getJSONObject("cidade").getJSONObject("estado").get("sigla-uf"));
                s.setCartorio(cartorio);
                s.setDataProtesto(item.get("data-protesto").toString().substring(0, 10));
                s.setValor(item.get("valor").toString());
                retorno.add(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retorno;
    }

    public JSONArray getJsonCheques() {
        Set cheques = this.getCheques();
        JSONArray retorno = new JSONArray();
        for (SerasaChequeDTO item : cheques) {
            JSONObject j = new JSONObject();
            j.put("quantidade", (Object)item.getQuantidade());
            j.put("banco", (Object)item.getBanco());
            j.put("agencia", (Object)item.getAgencia());
            j.put("motivo", (Object)item.getMotivo());
            j.put("data", (Object)item.getData());
            retorno.put((Object)j);
        }
        return retorno;
    }

    public Set<SerasaChequeDTO> getCheques() {
        HashSet<SerasaChequeDTO> retorno = new HashSet<SerasaChequeDTO>();
        try {
            JSONArray arr;
            JSONObject json = new JSONObject(this.serasa.getJsonResult());
            if (!json.has("ccf")) {
                return retorno;
            }
            if (!(json = json.getJSONObject("ccf")).has("detalhe-ccf")) {
                return retorno;
            }
            try {
                arr = json.getJSONArray("detalhe-ccf");
            }
            catch (Exception e) {
                try {
                    arr = new JSONArray();
                    arr.put((Object)json.getJSONObject("detalhe-ccf"));
                }
                catch (Exception ex) {
                    return retorno;
                }
            }
            for (int i = 0; i < arr.length(); ++i) {
                SerasaChequeDTO s = new SerasaChequeDTO();
                JSONObject item = arr.getJSONObject(i);
                s.setQuantidade(Integer.valueOf(item.getInt("quantidade")));
                JSONObject jBanco = item.getJSONObject("ultimo-cheque").getJSONObject("dados-bancarios");
                s.setAgencia(jBanco.get("numero-agencia").toString());
                s.setBanco(jBanco.getJSONObject("banco").get("codigo").toString() + "-" + jBanco.getJSONObject("banco").get("nome").toString());
                s.setData(item.get("data-ultimo-cheque").toString().substring(0, 10));
                s.setMotivo(item.getJSONObject("motivo").get("descricao").toString());
                retorno.add(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retorno;
    }

    public JSONArray getJsonTelefones() {
        JSONArray retorno = new JSONArray();
        try {
            JSONArray arr;
            JSONObject jSerasa = new JSONObject(this.serasa.getJsonResult());
            if (!jSerasa.has("ultimo-telefone-informado")) {
                return retorno;
            }
            jSerasa = jSerasa.getJSONObject("ultimo-telefone-informado");
            try {
                arr = jSerasa.getJSONArray("detalhe-ultimo-telefone-informado");
            }
            catch (Exception e) {
                try {
                    arr = new JSONArray();
                    arr.put((Object)jSerasa.getJSONObject("detalhe-ultimo-telefone-informado"));
                }
                catch (Exception ex) {
                    return retorno;
                }
            }
            for (int i = 0; i < arr.length(); ++i) {
                try {
                    JSONObject j = arr.getJSONObject(i);
                    if (!j.has("telefone")) continue;
                    j = j.getJSONObject("telefone");
                    JSONObject jOut = new JSONObject();
                    jOut.put("telefone", (Object)(j.get("numero-ddd").toString() + j.get("numero").toString()));
                    retorno.put((Object)jOut);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retorno;
    }
}

