/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.shared.model;

import br.com.system.app.components.containers.Container;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.shared.model.UploadResult;
import br.com.system.app.features.util.MimeType;
import br.com.system.app.features.util.TempFileMultiBuffer;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import java.io.InputStream;
import java.io.Serializable;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;

public class UploadFile
extends Container {
    private static final long serialVersionUID = 1L;
    private final TempFileMultiBuffer mBuffer = new TempFileMultiBuffer();
    private final Span spanExtension = new Span();
    private final Upload upload = new Upload((Receiver)this.mBuffer);
    private String fileName;
    private String mimeType;
    private Consumer<UploadResult> listener;

    public UploadFile() {
        this.upload.setMaxFiles(1);
        this.makeScreen();
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        this.unload();
    }

    private void makeScreen() {
        this.setHeader("Upload de Arquivos");
        this.setHeight("230px");
        this.upload.addFinishedListener((ComponentEventListener & Serializable)e -> {
            this.fileName = e.getFileName();
            this.mimeType = e.getMIMEType();
        });
        this.upload.addFileRejectedListener((ComponentEventListener & Serializable)event -> UIUtils.showError((String)"Arquivo rejeitado, verifique as extens\u00f5es permitidas"));
        this.getButtonClose().addClickListener((ComponentEventListener & Serializable)e -> this.close());
        this.getButtonSave().setText("Confirmar");
        this.getButtonSave().addClickListener((ComponentEventListener & Serializable)e -> this.confirmar());
        this.insert(new Component[]{this.spanExtension, this.upload});
    }

    private MimeType getMimeType() {
        try {
            return MimeType.getByValue((String)this.mimeType);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setListener(Consumer<UploadResult> listener) {
        this.listener = listener;
    }

    public void setExtensions(String ... extensoes) {
        StringBuilder e = new StringBuilder();
        for (String extensao : extensoes) {
            e.append(extensao).append(",");
        }
        this.spanExtension.setText("Extens\u00f5es Permitidas " + e.toString());
        this.upload.setAcceptedFileTypes(new String[]{e.toString()});
    }

    private void confirmar() {
        try {
            if (this.fileName == null || this.fileName.isEmpty()) {
                UIUtils.showWarning((String)"Selecione um Arquivo");
                return;
            }
            if (this.listener == null) {
                UIUtils.showError((String)"N\u00e3o foi definido um listener para receber o arquivo");
                return;
            }
            UploadResult ur = new UploadResult();
            ur.setContent(this.mBuffer.getInputStream());
            ur.setContentByte(IOUtils.toByteArray((InputStream)this.mBuffer.getInputStream()));
            ur.setFileName(this.fileName);
            ur.setMimeType(this.getMimeType());
            this.listener.accept(ur);
            this.close();
        }
        catch (Exception e) {
            UIUtils.showError((String)e.getMessage());
        }
    }

    private void unload() {
        this.upload.setAcceptedFileTypes(new String[0]);
        this.fileName = null;
        this.mimeType = null;
        this.mBuffer.clear();
    }
}

