/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.storage.google;

import br.com.system.app.features.storage.model.UrlSign;
import br.com.system.commons.ByteArrayUtils;
import br.com.system.commons.FileUtil;
import br.com.system.commons.InputStreamUtil;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.TimeUnit;

/*
 * Exception performing whole class analysis ignored.
 */
public class GoogleStorageService {
    static final String BUCKET = "bucket-neosales";
    static final String PROJECT_ID = "neosales-project";

    public static byte[] getObject(String hashName) {
        return GoogleStorageService.getObject(null, (String)hashName);
    }

    public static byte[] getObject(String bucketName, String hashName) {
        if (hashName == null || hashName.isEmpty()) {
            return null;
        }
        if (bucketName == null || bucketName.isEmpty()) {
            bucketName = "bucket-neosales";
        }
        Storage storage = (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setProjectId("neosales-project")).build().getService();
        BlobId blobId = BlobId.of((String)bucketName, (String)hashName);
        return storage.readAllBytes(blobId, new Storage.BlobSourceOption[0]);
    }

    public static InputStream getObjectInputStream(String bucketName, String hashName) {
        return new ByteArrayInputStream(GoogleStorageService.getObject((String)bucketName, (String)hashName));
    }

    public static InputStream getObjectInputStream(String hashName) {
        return GoogleStorageService.getObjectInputStream((String)"bucket-neosales", (String)hashName);
    }

    public static String uploadObject(String keyName, byte[] byteArray) throws Exception {
        return GoogleStorageService.uploadObject((String)keyName, null, (byte[])byteArray);
    }

    public static String uploadObject(String keyName, String contentType, byte[] byteArray) throws Exception {
        return GoogleStorageService.uploadObject((String)"", (String)keyName, (String)contentType, (byte[])byteArray);
    }

    public static String uploadObject(String bucketName, String keyName, String contentType, byte[] byteArray) throws Exception {
        if (contentType == null || contentType.isEmpty()) {
            contentType = FileUtil.getContentType((String)keyName);
        }
        if (bucketName == null || bucketName.isEmpty()) {
            bucketName = "bucket-neosales";
        }
        Storage storage = (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setProjectId("neosales-project")).build().getService();
        BlobId blobId = BlobId.of((String)bucketName, (String)keyName);
        BlobInfo blobInfo = BlobInfo.newBuilder((BlobId)blobId).setContentType(contentType).build();
        storage.create(blobInfo, byteArray, new Storage.BlobTargetOption[0]);
        return keyName;
    }

    public static String uploadObject(String keyname, InputStream is) throws Exception {
        return GoogleStorageService.uploadObject((String)keyname, null, (InputStream)is);
    }

    public static String uploadObject(String keyname, String contentType, InputStream is) throws Exception {
        return GoogleStorageService.uploadObject(null, (String)keyname, (String)contentType, (InputStream)is);
    }

    public static String uploadObject(String bucketName, String keyname, String contentType, InputStream is) throws Exception {
        GoogleStorageService.uploadObject((String)bucketName, (String)keyname, (String)contentType, (byte[])InputStreamUtil.toByteArray((InputStream)is));
        is.close();
        return keyname;
    }

    public static String uploadFile(String keyname, File file) throws Exception {
        GoogleStorageService.uploadObject((String)keyname, (byte[])ByteArrayUtils.fileToBytearray((File)file));
        return keyname;
    }

    public static void delete(String bucketName, String keyName) throws Exception {
        Storage storage;
        Blob blob;
        if (keyName == null || keyName.isEmpty()) {
            return;
        }
        if (bucketName == null || bucketName.isEmpty()) {
            bucketName = "bucket-neosales";
        }
        if ((blob = (storage = (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setProjectId("neosales-project")).build().getService()).get(bucketName, keyName, new Storage.BlobGetOption[0])) == null) {
            return;
        }
        Storage.BlobSourceOption precondition = Storage.BlobSourceOption.generationMatch((long)blob.getGeneration());
        storage.delete(bucketName, keyName, new Storage.BlobSourceOption[]{precondition});
    }

    public static UrlSign getUrlSign(String keyName, String bucket) {
        Storage storage = (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setProjectId("neosales-project")).build().getService();
        BlobInfo blobInfo = BlobInfo.newBuilder((BlobId)BlobId.of((String)bucket, (String)keyName)).build();
        URL url = storage.signUrl(blobInfo, 2L, TimeUnit.HOURS, new Storage.SignUrlOption[]{Storage.SignUrlOption.withV4Signature()});
        return new UrlSign(url.toString(), bucket, keyName);
    }
}

