/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.trescx.service;

import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.trescx.model.TrescxChamada;
import br.com.system.app.features.trescx.model.TrescxLog;
import br.com.system.app.features.trescx.service.TrescxChamadaService;
import br.com.system.app.features.trescx.service.TrescxLogService;
import br.com.system.commons.HashUtil;
import br.com.system.commons.datetime.DateTimeUtil;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TrescxIntegration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(TrescxIntegration.class);
    @Autowired
    private TrescxLogService trescxLogService;
    @Autowired
    private TrescxChamadaService trescxChamadaService;
    private PrintWriter out;
    private TrescxLog l;
    private String hash;

    public void webhook(ServletRequest request, ServletResponse response) {
        try {
            this.out = response.getWriter();
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            response.setContentType("json");
        }
        catch (IOException e2) {
            return;
        }
        try {
            String token = request.getParameter("token");
            if (!token.equals("5dcafe28-91ac-3a1f9fcd38dc")) {
                this.erro("Token invalido");
            }
            String ramal = request.getParameter("ramal");
            String destino = request.getParameter("destino");
            String dataHoraInicio = request.getParameter("dataHoraInicio");
            String dataHoraAtendimento = request.getParameter("dataHoraAtendimento");
            String dataHoraFim = request.getParameter("dataHoraFim");
            String situacao = request.getParameter("situacao");
            String talking = request.getParameter("talking");
            TrescxLog jaProcessado = this.trescxLogService.getByRamalAndDestinoAndData(ramal, destino, this.parseData(dataHoraInicio).minusHours(3L));
            if (jaProcessado != null) {
                this.erro("exists");
                return;
            }
            this.l = new TrescxLog();
            if (dataHoraFim != null && !dataHoraFim.isEmpty() && dataHoraFim.length() == 14) {
                this.l.setDataHoraFim(this.parseData(dataHoraFim).minusHours(3L));
            }
            if (dataHoraInicio != null && !dataHoraInicio.isEmpty() && dataHoraInicio.length() == 14) {
                this.l.setDataHoraInicio(this.parseData(dataHoraInicio).minusHours(3L));
            }
            if (dataHoraAtendimento != null && !dataHoraAtendimento.isEmpty() && dataHoraAtendimento.length() == 14) {
                this.l.setDataHoraAtendimento(this.parseData(dataHoraAtendimento).minusHours(3L));
            }
            this.l.setRamal(ramal);
            this.l.setDestino(destino);
            this.l.setStatus(situacao);
            try {
                this.l.setTotal(LocalTime.parse(DateTimeUtil.secondsToTime((long)Duration.between(this.l.getDataHoraInicio(), this.l.getDataHoraFim()).getSeconds())));
            }
            catch (Exception e3) {
                this.logger.error("TOTAL CALC " + e3.getMessage());
            }
            try {
                Long diff = ChronoUnit.SECONDS.between(this.l.getDataHoraInicio(), this.l.getDataHoraAtendimento() != null ? this.l.getDataHoraAtendimento() : this.l.getDataHoraFim());
                this.l.setRing(LocalTime.parse(DateTimeUtil.secondsToTime((long)diff.intValue())));
            }
            catch (Exception e4) {
                this.logger.error("RING CALC" + e4.getMessage());
            }
            List listachamada = this.trescxChamadaService.getChamadaSemLog(ramal, destino);
            this.hash = null;
            if (talking != null && !talking.isEmpty()) {
                try {
                    this.l.setTalking(LocalTime.parse(talking));
                    ((HttpServletRequest)request).getParts().forEach(e -> {
                        try {
                            this.hash = HashUtil.getUUI() + ".wav";
                            InputStream is = e.getInputStream();
                            StorageUtil.uploadObjectInputStream((String)this.hash, (String)"audio/mp3", (InputStream)is);
                            this.l.setHashGravacao(this.hash);
                        }
                        catch (Exception ex) {
                            this.logger.error(ex.getMessage());
                        }
                    });
                }
                catch (Exception e5) {
                    this.logger.error(e5.getMessage());
                }
            }
            this.l = this.trescxLogService.save(this.l);
            if (listachamada != null && !listachamada.isEmpty()) {
                TrescxChamada chamada = (TrescxChamada)listachamada.get(0);
                chamada.setTrescxLog(this.l);
                chamada.setHashGravacao(this.hash);
                this.trescxChamadaService.save(chamada);
            }
        }
        catch (Exception e6) {
            this.erro(e6.getMessage());
        }
    }

    private LocalDateTime parseData(String dh) {
        String str = dh.substring(0, 4) + "-" + dh.substring(4, 6) + "-" + dh.substring(6, 8) + " " + dh.substring(8, 10) + ":" + dh.substring(10, 12) + ":" + dh.substring(12, 14);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return LocalDateTime.parse(str, formatter);
    }

    private void erro(String msg) {
        JSONObject jsonRetorno = new JSONObject();
        jsonRetorno.put("success", false);
        jsonRetorno.put("erro", (Object)msg);
        this.out.print(jsonRetorno.toString());
    }
}

