/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.trescx.service;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.repository.projection.HierarquiaDTO;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.trescx.dto.TrescxLogDTO;
import br.com.system.app.features.trescx.dto.TrescxLogResumoDTO;
import br.com.system.app.features.trescx.model.TrescxLog;
import br.com.system.app.features.trescx.repository.TrescxLogRepository;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.features.usuario.service.UsuarioService;
import br.com.system.commons.HashUtil;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.TelefoneUtil;
import br.com.system.commons.datetime.DateTimeUtil;
import br.com.system.commons.datetime.FormatDate;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class TrescxLogService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private TrescxLogRepository logRepository;
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private EstruturaUsuarioService eus;
    @Autowired
    private UsuarioHierarquiaService uhs;

    public List<TrescxLogResumoDTO> resumo(EstruturaUsuario eu, LocalDate di, LocalDate df) {
        return this.logRepository.getResumo(this.uhs.getHierarquia(eu), di.atStartOfDay(), DateTimeUtil.getEndOfDay((LocalDate)df));
    }

    public List<TrescxLogDTO> getByHierarquia(EstruturaUsuario eu, LocalDate di, LocalDate df, HierarquiaDTO usuario, String destino, LocalTime minimoFalado, Pageable pageable) {
        return this.logRepository.filter(this.uhs.getHierarquia(eu), di.atStartOfDay(), DateTimeUtil.getEndOfDay((LocalDate)df), usuario, destino, minimoFalado, pageable);
    }

    public long countByHierarquia(EstruturaUsuario eu, LocalDate di, LocalDate df, HierarquiaDTO usuario, String destino, LocalTime minimoFalado) {
        return this.logRepository.count(this.uhs.getHierarquia(eu), di.atStartOfDay(), DateTimeUtil.getEndOfDay((LocalDate)df), usuario, destino, minimoFalado);
    }

    public TrescxLog getByRamalAndDestinoAndData(String ramal, String destino, LocalDateTime dataHoraInicio) {
        TrescxLog l = this.logRepository.findFirstByRamalAndDestinoAndDataHoraInicio(ramal, destino, dataHoraInicio);
        return l;
    }

    public TrescxLog save(TrescxLog l) {
        TrescxLog e = this.logRepository.findFirstByRamalAndDestinoAndDataHoraInicio(l.getRamal(), l.getDestino(), l.getDataHoraInicio());
        if (e != null) {
            return e;
        }
        Usuario u = this.usuarioService.getByRamal(l.getRamal());
        if (u != null) {
            EstruturaUsuario eu = this.eus.getFirstByUsuario(u);
            if (eu == null) {
                throw new BusinessException("Eu n\u00e3o encontrado");
            }
            l.setEstruturaUsuario(eu);
        }
        return (TrescxLog)this.logRepository.save((Object)l);
    }

    public String export(EstruturaUsuario eu, LocalDate di, LocalDate df, LocalTime lt) {
        List lista = this.logRepository.filter(this.uhs.getHierarquia(eu), di.atStartOfDay(), DateTimeUtil.getEndOfDay((LocalDate)df), null, null, lt, null);
        return this.export(lista);
    }

    public String export(List<TrescxLogDTO> lista) {
        InputStream is = null;
        XSSFWorkbook xls = null;
        try {
            is = StorageUtil.getObjectModelo((String)"ExportacaoTrescx-v3.xlsx");
            xls = new XSSFWorkbook(is);
            Sheet aba = xls.getSheet("Exportacao");
            CellStyle styleCellDouble = xls.createCellStyle();
            styleCellDouble.setDataFormat((short)2);
            int linha = 1;
            for (TrescxLogDTO t : lista) {
                Row row = aba.createRow(linha);
                row.createCell(0).setCellValue(t.getLoginUsuario());
                row.createCell(1).setCellValue(t.getRamal());
                row.createCell(2).setCellValue(TelefoneUtil.isFixo((String)t.getDestino()) ? "FIXO" : "MOVEL");
                row.createCell(3).setCellValue(t.getDestino());
                row.createCell(4).setCellValue(t.getPedidoId() == null ? "" : t.getPedidoId().toString());
                row.createCell(5).setCellValue(t.getCpfCnpj() == null ? "" : t.getCpfCnpj());
                row.createCell(6).setCellValue(t.getStatus());
                row.createCell(7).setCellValue(t.getInicio() == null ? "" : t.getInicio().format(FormatDate.DATETIME_BR.toDTF()));
                row.createCell(8).setCellValue(t.getFim() == null ? "" : t.getFim().format(FormatDate.DATETIME_BR.toDTF()));
                row.createCell(9).setCellValue(t.getTalking() == null ? "" : t.getTalking().toString());
                row.createCell(10).setCellValue(t.getRing() == null ? "" : t.getRing().toString());
                row.createCell(11).setCellValue(t.getTotal() == null ? "" : t.getTotal().toString());
                ++linha;
            }
            String nomeArquivo = HashUtil.getUUI() + ".xlsx";
            InputStream isOutput = InputStreamUtil.workbookToInputStream((Workbook)xls);
            String string = StorageUtil.uploadObjectInputStream((String)nomeArquivo, (String)ContentType.MULTIPART_FORM_DATA.toString(), (InputStream)isOutput);
            return string;
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        finally {
            try {
                xls.close();
                is.close();
                lista = null;
                xls = null;
                is = null;
            }
            catch (Exception exception) {}
        }
    }

    public void deleteByEstrutura(Estrutura e) {
        this.logRepository.deleteByEstruturaUsuarioEstrutura(e);
    }
}

