/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.usuario.repository;

import br.com.system.app.features.equipe.model.Equipe;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.usuario.dto.UsuarioBIDTO;
import br.com.system.app.features.usuario.dto.UsuarioDTO;
import br.com.system.app.features.usuario.repository.UsuarioRepositoryQuery;
import br.com.system.commons.StringUtil;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.transaction.annotation.Transactional;

public class UsuarioRepositoryImpl
implements UsuarioRepositoryQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    private EntityManager manager;

    @Transactional(readOnly=true)
    public long countUsuarios(EstruturaUsuario eu, String login, String nome, String email, Set<String> perfil, Boolean onlyAtivos, Equipe equipe, String ramal, String tags) {
        Query query = this.getQuery(eu, login, nome, email, perfil, onlyAtivos, equipe, ramal, null, true, tags);
        return StringUtil.toLong((String)query.getSingleResult().toString());
    }

    @Transactional(readOnly=true)
    public List<UsuarioDTO> findUsuarios(EstruturaUsuario eu, String login, String nome, String email, Set<String> perfil, Boolean onlyAtivos, Equipe equipe, String ramal, String tags, Pageable pageable) {
        Query query = this.getQuery(eu, login, nome, email, perfil, onlyAtivos, equipe, ramal, pageable, false, tags);
        return query.getResultList();
    }

    private Query getQuery(EstruturaUsuario eu, String login, String nome, String email, Set<String> perfil, Boolean onlyAtivos, Equipe equipe, String ramal, Pageable pageable, boolean count, String tags) {
        StringBuilder sql = new StringBuilder();
        if (count) {
            sql.append("select count(*)");
        } else {
            sql.append(" Select u.id,u.nome,u.email,u.login,u.master,u.tags,u.saldo,u.data_cadastro,");
            sql.append(" u.celular,u.perfil,u.url_bi,");
            sql.append(" eu.id estrutura_usuario_id,eu.ativo,eu.rules,e.nome nome_equipe,u.cpf,u.rg,");
            sql.append(" u.salario,u.ajuda_custo,u.vale_refeicao,u.data_admissao,");
            sql.append(" u.token_integration,u.email_alternativo,u.celular_alternativo,u.sessao_unica,");
            sql.append(" u.ip_fixo,u.ramal,u.whatsapp_conta_id,u.recebe_notificacao_whats,");
            sql.append(" u.vendedor,u.trava_qrcode,u.notificacao_na_view");
        }
        sql.append(" from usuario u");
        sql.append(" join estrutura_usuario eu on (eu.usuario_id=u.id)");
        sql.append(" left join equipe e on (e.id=eu.equipe_id)");
        sql.append(" WHERE eu.estrutura_id=:estruturaId");
        if (!eu.getUsuario().isMaster()) {
            sql.append(" and u.master!=1");
        }
        if (tags != null) {
            sql.append(" AND u.tags like :tags");
        }
        if (!login.isEmpty()) {
            sql.append(" AND u.login like :login");
        }
        if (!nome.isEmpty()) {
            sql.append(" AND u.nome like :nome");
        }
        if (!email.isEmpty()) {
            sql.append(" AND u.email like :email");
        }
        if (!perfil.isEmpty()) {
            sql.append(" AND find_in_set(u.perfil,:perfil)");
        }
        if (equipe != null) {
            sql.append(" and e.id=:equipeId");
        }
        if (onlyAtivos.booleanValue()) {
            sql.append(" and eu.ativo=1");
        }
        if (ramal != null && !ramal.isEmpty()) {
            sql.append(" and u.ramal=:ramal");
        }
        if (pageable != null) {
            sql.append(" limit :limit offset :offset");
        }
        Query query = count ? this.manager.createNativeQuery(sql.toString()) : this.manager.createNativeQuery(sql.toString(), UsuarioDTO.class);
        query.setParameter("estruturaId", (Object)eu.getEstrutura().getId());
        if (!login.isEmpty()) {
            query.setParameter("login", (Object)("%" + login + "%"));
        }
        if (tags != null) {
            query.setParameter("tags", (Object)("%" + tags + "%"));
        }
        if (!nome.isEmpty()) {
            query.setParameter("nome", (Object)("%" + nome + "%"));
        }
        if (!email.isEmpty()) {
            query.setParameter("email", (Object)("%" + email + "%"));
        }
        if (!perfil.isEmpty()) {
            query.setParameter("perfil", (Object)StringUtils.join(perfil, (String)","));
        }
        if (equipe != null) {
            query.setParameter("equipeId", (Object)equipe.getId());
        }
        if (ramal != null && !ramal.isEmpty()) {
            query.setParameter("ramal", (Object)ramal);
        }
        if (!count && pageable != null) {
            query.setParameter("limit", (Object)pageable.getPageSize());
            query.setParameter("offset", (Object)pageable.getOffset());
        }
        return query;
    }

    @Transactional
    public void removeAllTags(String listaIds) {
        StringBuilder sql = new StringBuilder();
        sql.append("update usuario set tags=''");
        sql.append(" where find_in_set(id,:listaIds) ");
        Query query = this.manager.createNativeQuery(sql.toString());
        query.setParameter("listaIds", (Object)listaIds);
        query.executeUpdate();
    }

    @Modifying
    @Transactional
    public void updateTags(String listaIds, String tag, Boolean incluir) {
        StringBuilder sql = new StringBuilder();
        sql.append("update usuario set ");
        if (incluir.booleanValue()) {
            sql.append("tags=CONCAT(tags,'").append(",").append(tag).append("')");
            sql.append(" where find_in_set(id,:listaIds) AND not find_in_set(:tag,tags) ");
        } else {
            sql.append("tags=replace(tags,'").append(",").append(tag).append("','')");
            sql.append(" where find_in_set(id,:listaIds) and find_in_set(:tag,tags) ");
        }
        Query query = this.manager.createNativeQuery(sql.toString());
        query.setParameter("tag", (Object)tag);
        query.setParameter("listaIds", (Object)listaIds);
        query.executeUpdate();
    }

    @Transactional(readOnly=true)
    public List<UsuarioBIDTO> findForBi(Long estruturaId, LocalDateTime dataHoraUltimaCarga) {
        StringBuilder sql = new StringBuilder();
        sql.append(" Select eu.id,eu.estrutura_id,u.nome,u.email,u.login,u.celular,u.perfil,");
        sql.append(" eu.ativo,e.nome nome_equipe");
        sql.append(" from usuario u");
        sql.append(" join estrutura_usuario eu on (eu.usuario_id=u.id)");
        sql.append(" left join equipe e on (e.id=eu.equipe_id)");
        sql.append(" WHERE eu.estrutura_id=:estruturaId");
        sql.append(" and u.data_hora_atualizacao>=:dataHoraUltimaCarga");
        Query query = this.manager.createNativeQuery(sql.toString(), UsuarioBIDTO.class);
        query.setParameter("estruturaId", (Object)estruturaId);
        query.setParameter("dataHoraUltimaCarga", (Object)dataHoraUltimaCarga);
        return query.getResultList();
    }
}

