/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.usuario.service;

import br.com.system.app.features.estrutura.model.EstruturaComplemento;
import br.com.system.app.features.estrutura.service.EstruturaComplementoService;
import br.com.system.app.features.usuario.dto.UsuarioBIDTO;
import br.com.system.app.features.usuario.service.UsuarioService;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.datetime.DateTimeUtil;
import br.com.system.commons.datetime.FormatDate;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UsuarioIntegration
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private EstruturaComplementoService estruturaComplementoService;

    public void doIntegration(ServletRequest request, ServletResponse response) {
        PrintWriter out;
        try {
            out = response.getWriter();
            response.setCharacterEncoding("UTF-8");
        }
        catch (IOException e) {
            return;
        }
        try {
            String body = InputStreamUtil.toString((InputStream)request.getInputStream());
            if (body.isEmpty()) {
                out.print(this.example());
                return;
            }
            JSONObject jsonBody = new JSONObject(body);
            EstruturaComplemento estruturaCompl = this.estruturaComplementoService.getByTokenIntegration(jsonBody.getString("tokenEstrutura"));
            if (estruturaCompl == null) {
                this.printErro("Token Estrutura Inv\u00e1lido", out);
                return;
            }
            if (!jsonBody.has("dataHoraUltimaCarga")) {
                this.printErro("dataHoraUltimaCarga \u00e9 Obrigat\u00f3rio", out);
                return;
            }
            LocalDateTime dataHoraUltimaCarga = DateTimeUtil.toDateTime((String)jsonBody.getString("dataHoraUltimaCarga"), (FormatDate)FormatDate.US_DATETIME);
            response.setContentType("application/json");
            String strOut = this.getJson(estruturaCompl.getEstrutura().getId(), dataHoraUltimaCarga);
            out.print(strOut);
        }
        catch (Exception e) {
            this.printErro(e.getMessage(), out);
        }
    }

    private void printErro(String msg, PrintWriter out) {
        JSONObject jsonRetorno = new JSONObject();
        jsonRetorno.put("success", false);
        jsonRetorno.put("erro", (Object)msg);
        out.print(jsonRetorno.toString());
    }

    private String example() {
        return "<html><head><title>Integra\u00e7\u00e3o Usu\u00e1rios</title></head><body><div><p ><img src=\"images/logos/neo-200.png\"></p>\n<h4 ><strong><u>Integra\u00e7\u00e3o Usu\u00e1rios</u></strong></h4>\n<ul>\n <li>method - POST</li>\n <li>token - Obrigat\u00f3rio</li>\n <li>dataHoraUltimaCarga - Obrigat\u00f3rio</li>\n</ul>\n<p>Json Body :</p>\n<pre>{\n       \"token\":\"SOLICITE_SEU_TOKEN_AO_SUPORTE\",\n       \"estruturaId\":SOLICITE_AO_SUPORTE,\n       \"dataHoraUltimaCarga\":\"2023-01-01 00:00:00\"\n}\n</pre>\n<p style=\"text-align: center\"><br></p></div></body></html>";
    }

    private String getJson(Long estruturaId, LocalDateTime dataHoraUltimaCarga) {
        List lista = this.usuarioService.getForBi(estruturaId, dataHoraUltimaCarga);
        JSONArray arr = new JSONArray();
        for (UsuarioBIDTO e : lista) {
            JSONObject j = new JSONObject();
            j.put("id", (Object)e.getId());
            j.put("nome", (Object)e.getNome());
            j.put("login", (Object)e.getLogin());
            j.put("email", (Object)e.getEmail());
            j.put("celular", (Object)e.getCelular());
            j.put("ativo", (Object)e.getAtivo());
            j.put("equipe", (Object)e.getNomeEquipe());
            j.put("perfil", (Object)e.getPerfil().name());
            arr.put((Object)j);
        }
        return arr.toString();
    }
}

