/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.usuario.views;

import br.com.system.app.components.MultiComboBox;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.equipe.model.Equipe;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.repository.projection.HierarquiaDTO;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.usuario.model.UsuarioPerfilEnum;
import br.com.system.app.features.usuario.model.UsuarioTag;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.H5;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public class HierarquiaView
extends VerticalContainer
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    @Autowired
    private final EstruturaUsuarioService eus;
    private final UsuarioHierarquiaService hierarquiaService;
    private Button btnConfirmar;
    private Button btnFechar;
    private Grid<HierarquiaDTO> grid;
    private Boolean multiple = false;
    private final Boolean outHierarchy;
    private TextField nome;
    private MultiComboBox<UsuarioTag> tags;
    private MultiComboBox<UsuarioPerfilEnum> perfil;
    private MultiComboBox<Equipe> cbEquipe;
    private EstruturaUsuario euSelect;
    private List<HierarquiaDTO> dataProvider;
    private H5 header;
    private RadioButtonGroup<String> rbStatus;
    private final Boolean habilitaFiltroAtivos;
    private final Boolean defaultAtivo;
    private Button btnPesquisa;

    public HierarquiaView(EstruturaUsuario euSelect, EstruturaUsuarioService eus, UsuarioHierarquiaService hierarquiaService) {
        super(new Component[0]);
        this.eus = eus;
        this.hierarquiaService = hierarquiaService;
        this.habilitaFiltroAtivos = true;
        this.euSelect = euSelect;
        this.outHierarchy = false;
        this.defaultAtivo = true;
        this.create();
    }

    public HierarquiaView(EstruturaUsuario euSelect, EstruturaUsuarioService eus, UsuarioHierarquiaService hierarquiaService, Boolean outHierarchy, Boolean habilitaFiltroAtivos, Boolean defaultAtivo) {
        super(new Component[0]);
        this.eus = eus;
        this.defaultAtivo = defaultAtivo;
        this.habilitaFiltroAtivos = habilitaFiltroAtivos;
        this.euSelect = euSelect;
        this.outHierarchy = outHierarchy;
        this.hierarquiaService = hierarquiaService;
        this.create();
    }

    public Button getPesquisaBtn() {
        return this.btnPesquisa;
    }

    private void create() {
        this.setId("mainHierarquia");
        this.setHeightFull();
        this.header = UIUtils.createHeader((String)"Hierarquia");
        this.grid = new Grid();
        this.btnConfirmar = UIUtils.createSmallButton((String)"Confirmar", (VaadinIcon)VaadinIcon.CHECK);
        this.btnFechar = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE);
        this.setWidthFull();
        this.add(new Component[]{this.header});
        this.nome = new TextField("Nome Usu\u00e1rio");
        this.tags = new MultiComboBox("Tags", (Collection)this.eus.getUsuarioTags(this.getEu()));
        this.tags.setItemLabelGenerator(UsuarioTag::getTag);
        this.perfil = new MultiComboBox("Perfil", (Object[])UsuarioPerfilEnum.values());
        this.perfil.setItemLabelGenerator(Enum::name);
        this.cbEquipe = new MultiComboBox("Equipe");
        if (this.hasPermission("EQUIPE_VISUALIZACAO_RESTRITA") && !this.isMaster()) {
            if (this.getEu().getEquipe() != null) {
                this.cbEquipe.setItems((Object[])new Equipe[]{this.getEu().getEquipe()});
            }
        } else {
            this.cbEquipe.setItems((Collection)this.eus.getEquipe(this.getEstrutura()));
        }
        this.cbEquipe.setItemLabelGenerator(Equipe::getNome);
        this.rbStatus = new RadioButtonGroup();
        this.rbStatus.setItems((Object[])new String[]{"Ativos", "Todos"});
        this.rbStatus.setValue((Object)(this.defaultAtivo != false ? "Ativos" : "Todos"));
        this.rbStatus.setVisible(this.habilitaFiltroAtivos.booleanValue());
        this.btnPesquisa = UIUtils.createSmallButton((String)"Pesquisar", (VaadinIcon)VaadinIcon.SEARCH);
        this.btnPesquisa.setDisableOnClick(true);
        this.btnPesquisa.addClickListener((ComponentEventListener & Serializable)e -> {
            this.loadData();
            this.btnPesquisa.setEnabled(true);
        });
        if (this.multiple.booleanValue()) {
            this.grid.setSelectionMode(Grid.SelectionMode.MULTI);
        }
        this.grid.setWidthFull();
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> {
            Span label = UIUtils.createBreakWrapSpan((String)eg.getUsuarioNome());
            return label;
        })).setKey("usuario").setHeader("Usu\u00e1rio").setWidth("250px");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getPerfil() == null ? "" : p.getPerfil())).setHeader("Perfil").setWidth("200px");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> {
            Span label = UIUtils.createBreakWrapSpan((String)eg.getEquipeNome());
            return label;
        })).setKey("equipe").setHeader("Equipe").setWidth("200px");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getLogin())).setHeader("Login").setWidth("200px");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.isAtivo() ? "Ativo" : "Inativo")).setFlexGrow(0).setWidth("100px").setHeader("Status");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> {
            Span label = UIUtils.createBreakWrapSpan((String)eg.getTags());
            return label;
        })).setKey("tags").setHeader("Tags").setWidth("180px");
        HorizontalContainer footer = new HorizontalContainer(new Component[]{this.btnFechar, this.btnConfirmar});
        footer.setJustifyContentMode(FlexComponent.JustifyContentMode.BETWEEN);
        this.add(new Component[]{new VerticalContainer(new Component[]{new HorizontalContainer(new Component[]{this.tags, this.perfil, this.cbEquipe, this.nome, this.rbStatus, this.btnPesquisa}), new HorizontalContainer(new Component[]{this.grid}).setHorizontalFull(), footer})});
        this.loadData();
    }

    public void clearFilter() {
        this.nome.clear();
        this.tags.clear();
        this.cbEquipe.clear();
        this.perfil.clear();
        this.loadData();
    }

    public void loadData() {
        if (this.euSelect == null) {
            return;
        }
        this.dataProvider = ((String)this.rbStatus.getValue()).equals("Ativos") ? this.hierarquiaService.getHierarquiaDto(this.euSelect, this.nome.getValue(), this.tags.getValue(), this.perfil.getValue(), this.cbEquipe.getValue(), Boolean.valueOf(true), this.outHierarchy) : this.hierarquiaService.getHierarquiaDto(this.euSelect, this.nome.getValue(), this.tags.getValue(), this.perfil.getValue(), this.cbEquipe.getValue(), Boolean.valueOf(false), this.outHierarchy);
        this.grid.setItems((Collection)this.dataProvider);
    }

    public Button getBtnConfirmar() {
        return this.btnConfirmar;
    }

    public Button getBtnFechar() {
        return this.btnFechar;
    }

    public void refresh() {
        this.loadData();
    }

    public void setMultiple(Boolean multiple) {
        this.multiple = multiple;
        if (multiple.booleanValue()) {
            this.grid.setSelectionMode(Grid.SelectionMode.MULTI);
        } else {
            this.grid.setSelectionMode(Grid.SelectionMode.SINGLE);
        }
    }

    public void clearSelection() {
        this.grid.deselectAll();
    }

    public Set<Long> getEstruturaUsuarioId() {
        HashSet<Long> ids = new HashSet<Long>();
        for (HierarquiaDTO h : this.getValues()) {
            ids.add(h.getEstruturaUsuarioId());
        }
        return ids;
    }

    public Set<Long> getUsuarioId() {
        HashSet<Long> ids = new HashSet<Long>();
        for (HierarquiaDTO h : this.getValues()) {
            ids.add(h.getUsuarioId());
        }
        return ids;
    }

    public Set<HierarquiaDTO> getValues() {
        return this.grid.getSelectedItems();
    }

    public HierarquiaDTO getValue() {
        if (this.multiple.booleanValue()) {
            throw new BusinessException("Multipla selecao nao permite retorno unico");
        }
        if (!this.grid.getSelectedItems().isEmpty()) {
            return (HierarquiaDTO)this.grid.getSelectedItems().iterator().next();
        }
        return null;
    }

    public EstruturaUsuario getEuSelect() {
        return this.euSelect;
    }

    public void setEuSelect(EstruturaUsuario euSelect) {
        this.euSelect = euSelect;
        this.loadData();
    }

    public List<HierarquiaDTO> getDataProvider() {
        return this.dataProvider;
    }

    public Set<Long> getDataProviderIds() {
        HashSet<Long> ids = new HashSet<Long>();
        for (HierarquiaDTO h : this.getDataProvider()) {
            ids.add(h.getEstruturaUsuarioId());
        }
        return ids;
    }

    public H5 getHeader() {
        return this.header;
    }
}

