/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.usuario.views;

import br.com.system.app.components.MultiComboBox;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.repository.projection.HierarquiaDTO;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.usuario.dto.UsuarioDTO;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.usuario.model.UsuarioPerfilEnum;
import br.com.system.app.features.usuario.model.UsuarioTag;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.features.usuario.service.UsuarioService;
import br.com.system.app.features.usuario.service.UsuarioTagService;
import br.com.system.app.features.whatsapp.model.WhatsAppConta;
import br.com.system.app.features.whatsapp.service.WhatsAppContaService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.EmailField;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class UsuarioFormView
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final UsuarioService usuarioService;
    private final EstruturaUsuario eu;
    private final EstruturaUsuarioService eus;
    private final UsuarioTagService usuarioTagService;
    private final UsuarioHierarquiaService hierarquiaService;
    private final WhatsAppContaService contaService;
    private UsuarioDTO usuario;
    private TextField nome;
    private TextField login;
    private EmailField email;
    private EmailField emailAlternativo;
    private TextField cel;
    private TextField celAlternativo;
    private ComboBox<UsuarioPerfilEnum> cbPerfil;
    private MultiComboBox<UsuarioTag> cbTags;
    private ComboBox<HierarquiaDTO> userModel;
    private TextField cpf;
    private TextField rg;
    private NumberField salario;
    private NumberField ajudaCusto;
    private NumberField valeRefeicao;
    private TextField ramal;
    private DatePicker dataAdmissao;
    private RadioButtonGroup<String> ativo;
    private RadioButtonGroup<String> sessaoUnica;
    private TextField ipFixo;
    private ComboBox<WhatsAppConta> cbContaWhats;
    private Checkbox cbNotificacaoWhats;
    private Checkbox vendedor;
    private Checkbox cbTravaQrcodeWhats;
    private Checkbox cbNotificacaoNaView;

    public UsuarioFormView(UsuarioDTO usuario, EstruturaUsuario eu, UsuarioService usuarioService, EstruturaUsuarioService eus, UsuarioTagService usuarioTagService, UsuarioHierarquiaService hierarquiaService, WhatsAppContaService contaService) {
        this.eu = eu;
        this.contaService = contaService;
        this.hierarquiaService = hierarquiaService;
        this.usuario = usuario;
        this.eus = eus;
        this.usuarioTagService = usuarioTagService;
        this.usuarioService = usuarioService;
        this.createContent();
    }

    private void createContent() {
        if (this.usuario == null) {
            this.usuario = new UsuarioDTO();
        }
        this.nome = new TextField("Nome");
        this.nome.setWidth("300px");
        if (this.usuario.getNome() != null) {
            this.nome.setValue(this.usuario.getNome());
        }
        this.login = new TextField("Login");
        this.login.setWidth("300px");
        if (this.usuario.getLogin() != null) {
            this.login.setValue(this.usuario.getLogin());
        }
        this.email = new EmailField("Email");
        this.email.setWidth("300px");
        if (this.usuario.getEmail() != null) {
            this.email.setValue(this.usuario.getEmail());
        }
        this.emailAlternativo = new EmailField("Email Alternativo");
        this.emailAlternativo.setWidth("300px");
        if (this.usuario.getEmailAlternativo() != null) {
            this.emailAlternativo.setValue(this.usuario.getEmailAlternativo());
        }
        this.cel = new TextField("Celular");
        this.cel.setWidth("160");
        if (this.usuario.getCelular() != null) {
            this.cel.setValue(this.usuario.getCelular());
        }
        this.celAlternativo = new TextField("Celular Alternativo");
        this.celAlternativo.setWidth("160");
        if (this.usuario.getCelularAlternativo() != null) {
            this.celAlternativo.setValue(this.usuario.getCelularAlternativo());
        }
        this.ramal = new TextField("Ramal 3CX");
        this.ramal.setEnabled(this.isMaster());
        if (this.usuario.getRamal() != null) {
            this.ramal.setValue(this.usuario.getRamal());
        }
        this.cbPerfil = new ComboBox("Perfil", (Object[])UsuarioPerfilEnum.values());
        this.cbPerfil.setItemLabelGenerator(Enum::name);
        this.cbPerfil.setWidth("160px");
        if (this.usuario.getPerfil() != null) {
            this.cbPerfil.setValue((Object)this.usuario.getPerfil());
        }
        List listaTags = this.usuarioTagService.getTags(this.eu.getEstrutura());
        this.cbTags = new MultiComboBox("Tags", (Collection)listaTags);
        this.cbTags.setItemLabelGenerator(UsuarioTag::getTag);
        this.cbTags.setWidth("160px");
        if (this.usuario.getTags() != null) {
            ArrayList<UsuarioTag> tags = new ArrayList<UsuarioTag>();
            for (String s : this.usuario.getTags().split(",")) {
                for (UsuarioTag ut : listaTags) {
                    if (!ut.getTag().equals(s)) continue;
                    tags.add(ut);
                }
            }
            this.cbTags.setValue(tags);
        }
        this.userModel = new ComboBox("Modelo", (Collection)this.hierarquiaService.getHierarquiaDto(this.eu, Boolean.TRUE));
        this.userModel.setItemLabelGenerator(HierarquiaDTO::getLoginAndPerfil);
        this.userModel.setWidth("400px");
        this.userModel.setVisible(this.usuario.getId() == null);
        this.cpf = new TextField("Cpf");
        this.cpf.setMaxLength(11);
        this.cpf.setMinLength(11);
        if (this.usuario.getCpf() != null) {
            this.cpf.setValue(this.usuario.getCpf());
        }
        this.rg = new TextField("RG");
        if (this.usuario.getRg() != null) {
            this.rg.setValue(this.usuario.getRg());
        }
        this.salario = new NumberField("Sal\u00e1rio");
        if (this.usuario.getSalario() != null) {
            this.salario.setValue((Number)this.usuario.getSalario().doubleValue());
        }
        this.ajudaCusto = new NumberField("Ajuda Custo");
        if (this.usuario.getAjudaCusto() != null) {
            this.ajudaCusto.setValue((Number)this.usuario.getAjudaCusto().doubleValue());
        }
        this.valeRefeicao = new NumberField("Vale Refei\u00e7\u00e3o");
        if (this.usuario.getValeRefeicao() != null) {
            this.valeRefeicao.setValue((Number)this.usuario.getValeRefeicao().doubleValue());
        }
        this.dataAdmissao = new DatePicker();
        this.dataAdmissao.setLabel("Admiss\u00e3o");
        this.dataAdmissao.setValue(LocalDate.now().withDayOfMonth(1));
        this.dataAdmissao.setLocale(UIUtils.getLocale());
        if (this.usuario.getDataAdmissao() != null) {
            this.dataAdmissao.setValue(this.usuario.getDataAdmissao());
        }
        this.ipFixo = new TextField("IP FIXO");
        if (this.usuario.getIpFixo() != null) {
            this.ipFixo.setValue(this.usuario.getIpFixo());
        }
        this.ativo = new RadioButtonGroup();
        this.ativo.setLabel("Situa\u00e7\u00e3o");
        this.ativo.setItems((Object[])new String[]{"Ativo", "Inativo"});
        if (this.usuario.getId() == null || this.usuario.getAtivo().booleanValue()) {
            this.ativo.setValue((Object)"Ativo");
        } else {
            this.ativo.setValue((Object)"Inativo");
        }
        this.sessaoUnica = new RadioButtonGroup();
        this.sessaoUnica.setLabel("Sess\u00e3o \u00danica");
        this.sessaoUnica.setItems((Object[])new String[]{"SIM", "N\u00c3O"});
        if (this.usuario.getId() == null || this.usuario.isSessaoUnica()) {
            this.sessaoUnica.setValue((Object)"SIM");
        } else {
            this.sessaoUnica.setValue((Object)"N\u00c3O");
        }
        this.sessaoUnica.setVisible(false);
        this.sessaoUnica.setValue((Object)"SIM");
        List contas = this.contaService.getContaByEstruturaAtendimento(this.getEstrutura());
        this.cbContaWhats = new ComboBox("Conta Whats", (Collection)contas);
        this.cbContaWhats.setWidth("300px");
        this.cbContaWhats.setItemLabelGenerator(WhatsAppConta::getNumeroAndFornecedor);
        if (this.usuario.getWhatsappContaId() != null) {
            for (WhatsAppConta wc : contas) {
                if (!wc.getId().equals(this.usuario.getWhatsappContaId())) continue;
                this.cbContaWhats.setValue((Object)wc);
            }
        }
        this.cbNotificacaoWhats = new Checkbox("Notifica\u00e7\u00e3o Whats");
        if (this.usuario.getRecebeNotificacaoWhats() != null) {
            this.cbNotificacaoWhats.setValue((Object)this.usuario.getRecebeNotificacaoWhats());
        }
        this.vendedor = new Checkbox("Executa Vendas");
        if (this.usuario.getVendedor() != null) {
            this.vendedor.setValue((Object)this.usuario.getVendedor());
        }
        this.cbTravaQrcodeWhats = new Checkbox("Travar Tela se pedir QRCODE Whats?");
        if (this.usuario.getTravaQrcode() != null) {
            this.cbTravaQrcodeWhats.setValue((Object)this.usuario.getTravaQrcode());
        }
        this.cbNotificacaoNaView = new Checkbox("Mostrar Notifica\u00e7\u00f5es na Tela?", true);
        if (this.usuario.getNotificacaoNaView() != null) {
            this.cbNotificacaoNaView.setValue((Object)this.usuario.getNotificacaoNaView());
        }
        Button btnFechar = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE);
        btnFechar.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        Button btnSalvar = UIUtils.createSmallButton((String)"Salvar", (VaadinIcon)VaadinIcon.INBOX);
        btnSalvar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (!this.getErros().isEmpty()) {
                UIUtils.showNotification((String)this.getErros());
                return;
            }
            this.usuario.setAtivo(Boolean.valueOf(((String)this.ativo.getValue()).equals("Ativo")));
            this.usuario.setCelular(this.cel.getValue());
            this.usuario.setCelularAlternativo(this.celAlternativo.getValue());
            this.usuario.setRamal(this.ramal.getValue() == null || this.ramal.getValue().isEmpty() ? null : this.ramal.getValue());
            this.usuario.setDataCadastro(LocalDate.now());
            this.usuario.setEmail(this.email.getValue());
            this.usuario.setEmailAlternativo(this.emailAlternativo.getValue());
            this.usuario.setLogin(this.login.getValue());
            this.usuario.setNome(this.nome.getValue());
            this.usuario.setPerfil((UsuarioPerfilEnum)this.cbPerfil.getValue());
            this.usuario.setTags(this.usuarioService.getStringtags(this.cbTags.getValue()));
            this.usuario.setCpf(this.cpf.getValue());
            this.usuario.setRg(this.rg.getValue());
            this.usuario.setSalario(this.salario.getValue() == null ? BigDecimal.ZERO : new BigDecimal((Double)this.salario.getValue()));
            this.usuario.setAjudaCusto(this.ajudaCusto.getValue() == null ? BigDecimal.ZERO : new BigDecimal((Double)this.ajudaCusto.getValue()));
            this.usuario.setValeRefeicao(this.valeRefeicao.getValue() == null ? BigDecimal.ZERO : new BigDecimal((Double)this.valeRefeicao.getValue()));
            this.usuario.setDataAdmissao((LocalDate)this.dataAdmissao.getValue());
            this.usuario.setIpFixo(this.ipFixo.getValue());
            this.usuario.setSessaoUnica(((String)this.sessaoUnica.getValue()).equals("SIM"));
            this.usuario.setWhatsappContaId(this.cbContaWhats.getValue() == null ? null : ((WhatsAppConta)this.cbContaWhats.getValue()).getId());
            this.usuario.setRecebeNotificacaoWhats((Boolean)this.cbNotificacaoWhats.getValue());
            this.usuario.setVendedor((Boolean)this.vendedor.getValue());
            this.usuario.setTravaQrcode((Boolean)this.cbTravaQrcodeWhats.getValue());
            this.usuario.setNotificacaoNaView((Boolean)this.cbNotificacaoNaView.getValue());
            try {
                if (this.usuario.getId() != null) {
                    this.usuario = this.usuarioService.saveAndCreate(this.usuario, this.eu.getEstrutura());
                } else if (this.userModel.getValue() == null) {
                    this.usuario = this.usuarioService.saveAndCreate(this.usuario, this.eu.getEstrutura());
                } else {
                    Optional uModel = this.usuarioService.getById(((HierarquiaDTO)this.userModel.getValue()).getUsuarioId());
                    if (!uModel.isPresent()) {
                        this.usuario = this.usuarioService.saveAndCreate(this.usuario, this.eu.getEstrutura());
                    } else {
                        Optional euModelo = this.eus.getByUsuarioAndEstrutura((Usuario)uModel.get(), this.getEstrutura());
                        this.usuario = this.usuarioService.saveAndCreate(this.usuario, this.eu.getEstrutura(), euModelo.isPresent() ? (EstruturaUsuario)euModelo.get() : null);
                    }
                }
                UIUtils.showNotification((String)"Salvo com sucesso");
                this.close();
            }
            catch (Exception ex) {
                UIUtils.showNotification((String)ex.getMessage());
            }
        });
        VerticalContainer v = new VerticalContainer(new Component[0]);
        v.add(new Component[]{new HorizontalContainer(new Component[]{this.nome, this.login})});
        v.add(new Component[]{new HorizontalContainer(new Component[]{this.email, this.emailAlternativo})});
        v.add(new Component[]{new HorizontalContainer(new Component[]{this.cel, this.celAlternativo, this.ramal})});
        v.add(new Component[]{new HorizontalContainer(new Component[]{this.cbPerfil, this.cbTags})});
        v.add(new Component[]{new HorizontalContainer(new Component[]{this.cpf, this.rg, this.salario})});
        v.add(new Component[]{new HorizontalContainer(new Component[]{this.ajudaCusto, this.valeRefeicao, this.dataAdmissao})});
        v.add(new Component[]{this.userModel, this.ativo, this.sessaoUnica, this.ipFixo, this.cbContaWhats, this.cbNotificacaoWhats, this.vendedor, this.cbTravaQrcodeWhats, this.cbNotificacaoNaView});
        v.add(new Component[]{new FooterContainer(new Component[]{btnFechar, btnSalvar})});
        this.add(new Component[]{v});
    }

    private String getErros() {
        Usuario r;
        Object erros = "";
        if (this.nome.getValue().isEmpty()) {
            erros = (String)erros + "Informe o nome<BR>";
        }
        if (this.login.getValue().isEmpty()) {
            erros = (String)erros + "Informe o login<BR>";
        }
        if (this.email.isInvalid() || this.email.getValue().isEmpty()) {
            erros = (String)erros + "Informe o email<BR>";
        }
        if (this.cbPerfil.getValue() == null) {
            erros = (String)erros + "Selecione o perfil<BR>";
        }
        if (this.userModel.getValue() == null && this.usuario.getId() == null) {
            erros = (String)erros + "Modelo de usu\u00e1rio \u00e9 obrigat\u00f3rio<BR>";
        }
        if (this.ramal.getValue() != null && !this.ramal.getValue().isEmpty() && (r = this.usuarioService.getByRamal(this.ramal.getValue())) != null && !r.getId().equals(this.usuario.getId())) {
            erros = (String)erros + "Este ramal j\u00e1 est\u00e1 em uso<BR>";
        }
        return erros;
    }
}

