/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.waha.service;

import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.waha.service.WahaConnection;
import br.com.system.app.features.whatsapp.model.WhatsApp;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendimento;
import br.com.system.app.features.whatsapp.model.WhatsAppConta;
import br.com.system.app.features.whatsapp.model.WhatsAppContentTipoEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppEtapaEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppMensagem;
import br.com.system.app.features.whatsapp.model.WhatsAppMensagemTipoEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppStatusEnum;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendimentoService;
import br.com.system.app.features.whatsapp.service.WhatsAppContaService;
import br.com.system.app.features.whatsapp.service.WhatsAppControleService;
import br.com.system.app.features.whatsapp.service.WhatsAppMensagemService;
import br.com.system.app.features.whatsapp.service.WhatsAppService;
import br.com.system.commons.FileUtil;
import br.com.system.commons.HashUtil;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.RandomUtil;
import br.com.system.commons.SleepUtil;
import br.com.system.integreation.conexaoExterna.ExternalConnection;
import com.vdurmont.emoji.EmojiParser;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WahaWebhook
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private WhatsAppMensagemService whatsappMessageService;
    @Autowired
    private WhatsAppControleService whatsAppControleService;
    @Autowired
    private WhatsAppContaService whatsappContaService;
    @Autowired
    private WhatsAppService whatsAppService;
    @Autowired
    private WhatsAppAtendimentoService whatsAppAtendimentoService;
    @Autowired
    private EstruturaUsuarioService eus;

    public void webhook(ServletRequest request, ServletResponse response) {
        PrintWriter out;
        try {
            out = response.getWriter();
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            response.setContentType("json");
        }
        catch (IOException e) {
            return;
        }
        try {
            boolean isMidia;
            String token = request.getParameter("token");
            if (!token.equals("6262f94f0c79dedb1fda444dc283ec8b531087b412dc2ffa20a4cbf5300eeed7")) {
                this.printErro("Token invalido", out);
                return;
            }
            String body = InputStreamUtil.toString((InputStream)request.getInputStream());
            if (body.isEmpty()) {
                this.printErro("Body is empty", out);
                return;
            }
            SleepUtil.inSeconds((Integer)3);
            JSONObject jsonBody = new JSONObject(body);
            JSONObject payload = jsonBody.getJSONObject("payload");
            JSONObject dataJson = payload.getJSONObject("_data");
            if (!jsonBody.has("event")) {
                this.printErro("Nao achei atributio event", out);
                return;
            }
            if (!jsonBody.has("payload")) {
                this.printErro("Nao consegui localizar o payload", out);
                return;
            }
            String mediaUrl = payload.has("mediaUrl") ? payload.getString("mediaUrl") : "";
            String msgContent = dataJson.has("body") ? dataJson.getString("body") : "";
            boolean isTexto = msgContent != null && !msgContent.trim().isEmpty();
            boolean bl = isMidia = mediaUrl != null && !mediaUrl.trim().isEmpty();
            if (!isTexto && !isMidia) {
                System.out.println("Ignorando...");
                return;
            }
            if (jsonBody.getString("event").equals("message.ack")) {
                if (!payload.has("_data")) {
                    this.printErro("Nao consegui localizar a mensagem", out);
                    return;
                }
                if (!dataJson.has("type")) {
                    this.printErro("Nao consegui localizar o tipo de mensagem", out);
                    return;
                }
                if (!dataJson.has("id")) {
                    this.printErro("Nao achei o ID", out);
                    return;
                }
                JSONObject idJson = dataJson.getJSONObject("id");
                String messageId = idJson.getString("id");
                WhatsAppMensagem mensagem = this.whatsappMessageService.getByMessageId(messageId);
                if (mensagem == null) {
                    mensagem = this.createMessage(jsonBody, out);
                }
                switch (payload.getInt("ack")) {
                    case 1: {
                        return;
                    }
                    case 2: {
                        mensagem.setStatus(WhatsAppStatusEnum.RECEBIDA);
                        mensagem.setDataHoraRecebimento(LocalDateTime.now());
                        break;
                    }
                    case 3: {
                        mensagem.setStatus(WhatsAppStatusEnum.LIDA);
                        mensagem.setDataHoraLeitura(LocalDateTime.now());
                        break;
                    }
                    default: {
                        this.printErro("Nao consegui localizar o status", out);
                        return;
                    }
                }
                this.whatsappMessageService.saveMessage(mensagem);
                this.whatsAppControleService.gravarAlteracao(mensagem, mensagem.getStatus());
            } else if (jsonBody.getString("event").equals("message")) {
                this.createMessage(jsonBody, out);
            }
            this.printSucesso(out);
        }
        catch (Exception e) {
            this.printErro("Erro " + e.getMessage(), out);
        }
    }

    private WhatsAppMensagem createMessage(JSONObject jsonBody, PrintWriter out) throws Exception {
        this.emojiToDecimal(jsonBody);
        if (!jsonBody.getJSONObject("payload").has("_data")) {
            this.printErro("Nao consegui localizar a mensagem", out);
            return null;
        }
        JSONObject payload = jsonBody.getJSONObject("payload");
        JSONObject dataJson = payload.getJSONObject("_data");
        if (!dataJson.has("type")) {
            this.printErro("Nao consegui localizar o tipo de mensagem", out);
            return null;
        }
        if (!dataJson.has("id")) {
            this.printErro("Nao achei o ID", out);
            return null;
        }
        JSONObject idJson = dataJson.getJSONObject("id");
        String from = dataJson.getString("from");
        if (!from.contains("@c.us")) {
            return null;
        }
        from = from.replace("@c.us", "");
        String to = dataJson.getString("to");
        if (!to.contains("@c.us")) {
            return null;
        }
        to = to.replace("@c.us", "");
        WhatsAppConta conta = this.whatsappContaService.getContaByMoorseId(jsonBody.getString("session"));
        List listaAtendente = this.eus.getByWhatsappConta(conta);
        EstruturaUsuario atendente = listaAtendente.isEmpty() ? this.eus.getMasterEstrutura(conta.getEstrutura()) : (EstruturaUsuario)listaAtendente.get(RandomUtil.getRandom((Integer)0, (Integer)(listaAtendente.size() - 1)));
        WhatsApp w = payload.getBoolean("fromMe") ? this.whatsAppService.getByNumeroAndConta(to, conta) : this.whatsAppService.getByNumeroAndConta(from, conta);
        if (w == null) {
            w = this.whatsAppService.criar(from, atendente, conta, WhatsAppEtapaEnum.ATENDENTE);
        } else {
            w.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
            this.whatsAppService.save(w);
        }
        WhatsAppAtendimento whatsappAtendimento = this.whatsAppAtendimentoService.getAndCreate(w, null, WhatsAppEtapaEnum.ATENDENTE);
        WhatsAppMensagem m = new WhatsAppMensagem();
        m.setWhatsappAtendimento(whatsappAtendimento);
        whatsappAtendimento.setLida(Boolean.FALSE);
        if (idJson.has("fromMe") && idJson.getBoolean("fromMe")) {
            m.setStatus(WhatsAppStatusEnum.ENVIADA);
            m.setDataHoraEnvio(LocalDateTime.now());
            m.setTipo(WhatsAppMensagemTipoEnum.ENVIADA);
        } else {
            m.setStatus(WhatsAppStatusEnum.RESPONDIDA);
            m.setTipo(WhatsAppMensagemTipoEnum.RECEBIDA);
        }
        m.setDataHoraCriacao(LocalDateTime.now());
        m.setEstruturaUsuario(atendente);
        String tipo = dataJson.getString("type");
        if (tipo.equals("audio") || tipo.equals("ptt")) {
            String mediaUrl = payload.getString("mediaUrl");
            String hash = HashUtil.getUUI() + ".ogg";
            ExternalConnection conexao = WahaConnection.getConnection();
            StorageUtil.uploadObjectInputStream((String)hash, (String)"audio/ogg; codecs=opus", (InputStream)conexao.executeGet(mediaUrl).execute().getEntity().getContent());
            m.setContentTipo(WhatsAppContentTipoEnum.AUDIO);
            m.setFileName(hash);
            m.setContent("");
            m.setMessageId(idJson.getString("id"));
            m.setUrlFile(hash);
            m.setNomeOriginal(hash);
        } else if (tipo.equals("videoMessage")) {
            String hash = HashUtil.getUUI() + ".mpeg";
            m.setContentTipo(WhatsAppContentTipoEnum.VIDEO);
            m.setFileName(hash);
            m.setContent("Video ");
            m.setMessageId(idJson.getString("id"));
            m.setUrlFile(hash);
            m.setNomeOriginal(hash);
        } else if (tipo.equals("chat")) {
            m.setContent(dataJson.getString("body"));
            m.setContentTipo(WhatsAppContentTipoEnum.TEXTO);
            m.setMessageId(idJson.getString("id"));
        } else if (tipo.equals("contactMessage")) {
            m.setContentTipo(WhatsAppContentTipoEnum.CONTATO);
            m.setMessageId(idJson.getString("id"));
        } else if (tipo.equals("image")) {
            String mediaUrl = payload.getString("mediaUrl");
            String hash = HashUtil.getUUI() + ".jpg";
            ExternalConnection conexao = WahaConnection.getConnection();
            StorageUtil.uploadObjectInputStream((String)hash, (String)"image/jpeg", (InputStream)conexao.executeGet(mediaUrl).execute().getEntity().getContent());
            m.setContentTipo(WhatsAppContentTipoEnum.IMAGEM);
            m.setFileName(hash);
            m.setContent("");
            m.setMessageId(idJson.getString("id"));
            m.setUrlFile(hash);
            m.setNomeOriginal("");
        } else if (tipo.equals("document")) {
            String fileName = dataJson.getString("filename");
            String extensao = FileUtil.getExtension((String)fileName);
            String mediaUrl = payload.getString("mediaUrl");
            String hash = HashUtil.getUUI() + extensao;
            ExternalConnection conexao = WahaConnection.getConnection();
            StorageUtil.uploadObjectInputStream((String)hash, (String)FileUtil.getContentType((String)fileName), (InputStream)conexao.executeGet(mediaUrl).execute().getEntity().getContent());
            m.setContentTipo(WhatsAppContentTipoEnum.ARQUIVO);
            if (fileName != null && !fileName.isEmpty()) {
                m.setFileName(fileName);
            } else {
                m.setFileName(hash);
            }
            m.setContent("");
            m.setMessageId(idJson.getString("id"));
            m.setUrlFile(hash);
            m.setNomeOriginal("");
        } else {
            this.printErro("Nao consegui entender o tipo da mensagem(documentMessage,imageMessage,conversation,audioMessage", out);
            return null;
        }
        m = this.whatsappMessageService.saveMessage(m);
        this.whatsAppControleService.gravarNova(m, m.getStatus());
        return m;
    }

    private void printSucesso(PrintWriter out) {
        JSONObject jsonRetorno = new JSONObject();
        jsonRetorno.put("success", true);
        jsonRetorno.put("erro", (Object)"");
        out.print(jsonRetorno.toString());
    }

    private void printErro(String msg, PrintWriter out) {
        JSONObject jsonRetorno = new JSONObject();
        jsonRetorno.put("success", false);
        jsonRetorno.put("erro", (Object)msg);
        out.print(jsonRetorno.toString());
    }

    private void emojiToDecimal(JSONObject jsonBody) {
        try {
            JSONObject j;
            if (jsonBody.has("content") || !jsonBody.isNull("content")) {
                jsonBody.put("content", (Object)EmojiParser.parseToHtmlDecimal((String)jsonBody.getString("content")));
            }
            if (jsonBody.has("contactUser") && (j = jsonBody.getJSONObject("contactUser")).has("name") && !j.isNull("name")) {
                j.put("name", (Object)"");
                jsonBody.put("contactUser", (Object)j);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

