/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp;

import br.com.system.app.MainLayout;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.whatsapp.WhatsAppAtendenteForm;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendente;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendenteService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;

@Route(value="whatsapp-atendente-view", layout=MainLayout.class)
@PageTitle(value="Cadastro de Atendente")
@RolesAllowed(value={"ATENDENTE_VIEW"})
public class WhatsAppAtendenteView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final WhatsAppAtendenteService waas;
    private final WhatsAppAtendenteForm form;
    private GridCrud<WhatsAppAtendente> crud;

    @Autowired
    public WhatsAppAtendenteView(WhatsAppAtendenteService waas, WhatsAppAtendenteForm form) {
        this.waas = waas;
        this.form = form;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent(this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private Component createContent() {
        this.crud = new GridCrud(WhatsAppAtendente.class);
        this.crud.getAddButton().setText("Adicionar");
        Button btnInserir = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PLUS, (String)"Inserir novo Atendente");
        btnInserir.addClickListener((ComponentEventListener & Serializable)e -> {
            this.form.show(null, this.getEu());
            this.form.addOpenedChangeListener((ComponentEventListener & Serializable)close -> {
                if (!close.isOpened()) {
                    this.crud.refreshGrid();
                }
            });
        });
        Button btnEditar = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PENCIL, (String)"Editar Atendente");
        btnEditar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.crud.getGrid().getSelectedItems().size() <= 0) {
                UIUtils.showNotification((String)"Selecione um atendente para editar");
                return;
            }
            this.form.show((WhatsAppAtendente)this.crud.getGrid().getSelectedItems().iterator().next(), this.getEu());
            this.form.addOpenedChangeListener((ComponentEventListener & Serializable)close -> {
                if (!close.isOpened()) {
                    this.crud.refreshGrid();
                }
            });
        });
        HorizontalContainer cTools = new HorizontalContainer(new Component[]{btnInserir, btnEditar});
        cTools.getElement().getStyle().set("background", "transparent");
        this.crud.getCrudLayout().addToolbarComponent((Component)cTools);
        this.crud.getGrid().setColumns(new String[0]);
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getEstruturaUsuario().getUsuario().getNome()))).setHeader("Nome").setFlexGrow(0).setWidth("250px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getEstruturaUsuario().getUsuario().getLogin()))).setHeader("Login").setFlexGrow(0).setWidth("250px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)(p.getEstruturaUsuario().getEquipe() == null ? "" : p.getEstruturaUsuario().getEquipe().getNome())))).setHeader("Equipe").setFlexGrow(0).setWidth("250px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getOnline() != false ? "SIM" : "N\u00c3O")).setHeader("Na Tela");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getRecebeAutomatico() != false ? "SIM" : "N\u00c3O")).setHeader("Autom\u00e1tico");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getPrioritario() != false ? "SIM" : "N\u00c3O")).setHeader("Priorit\u00e1rio");
        this.crud.getCrudFormFactory().setVisibleProperties(new String[0]);
        this.crud.getAddButton().setVisible(false);
        this.crud.getUpdateButton().setVisible(false);
        this.crud.getDeleteButton().setVisible(false);
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        return this.crud;
    }
}

