/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp;

import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.features.layout.Border;
import br.com.system.app.features.layout.Color;
import br.com.system.app.features.layout.FlexBoxLayout;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.shared.service.TranscricaoAudioService;
import br.com.system.app.features.whatsapp.WhatsAppMessageView;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendimento;
import br.com.system.app.features.whatsapp.model.WhatsAppMensagem;
import br.com.system.app.features.whatsapp.service.WhatsAppMensagemService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;

@Component
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class WhatsAppConversasDialog
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    @Autowired
    private WhatsAppMensagemService whatsAppMensagemService;
    @Autowired
    private TranscricaoAudioService transcricaoAudioService;

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public void show(WhatsAppAtendimento wa) {
        this.removeAll();
        this.setWidth("80%");
        this.setHeight("80%");
        FlexBoxLayout divMensagem = new FlexBoxLayout(FlexLayout.FlexDirection.COLUMN, new com.vaadin.flow.component.Component[0]);
        divMensagem.setWidth("100%");
        divMensagem.setHeight("90%");
        divMensagem.getStyle().set("overflow-x", "auto");
        divMensagem.setBorder(Border.Style.SOLID, "1px", Color.AQUAMARINE);
        List mensagens = this.whatsAppMensagemService.getByAtendimento(wa);
        for (WhatsAppMensagem m : mensagens) {
            divMensagem.addComponentAsFirst((com.vaadin.flow.component.Component)new WhatsAppMessageView().getMessage(m, this.transcricaoAudioService, this.isDarkTheme()));
        }
        divMensagem.getElement().executeJs("$0.scrollTo(0,$0.scrollHeight);", new Serializable[]{divMensagem.getElement()});
        Button bClose = UIUtils.createSmallButton((String)"Fechar");
        bClose.addClickListener((ComponentEventListener & Serializable)close -> this.close());
        this.add(new com.vaadin.flow.component.Component[]{divMensagem, new FooterContainer(new com.vaadin.flow.component.Component[]{bClose})});
        this.open();
    }
}

