/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp;

import br.com.system.app.MainLayout;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.whatsapp.model.WhatsAppConta;
import br.com.system.app.features.whatsapp.model.WhatsAppDayOff;
import br.com.system.app.features.whatsapp.service.WhatsAppContaService;
import br.com.system.app.features.whatsapp.service.WhatsAppDayOffService;
import br.com.system.app.features.whatsapp.service.WhatsAppService;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;

@Route(value="whatsapp-day-off", layout=MainLayout.class)
@PageTitle(value="WhatsApp Day Off")
@RolesAllowed(value={"ATENDIMENTO_DAY_OFF_VIEW"})
public class WhatsAppDayOffView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final WhatsAppDayOffService service;
    private final WhatsAppContaService whatsappContaService;
    private WhatsAppConta whatsAppConta;

    @Autowired
    public WhatsAppDayOffView(WhatsAppDayOffService service, WhatsAppService whatsappService, WhatsAppContaService whatsappContaService) {
        this.service = service;
        this.whatsappContaService = whatsappContaService;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent((Component)this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private VerticalContainer createContent() {
        List lwc = this.whatsappContaService.getContaByEstruturaAtendimento(this.getEstrutura());
        if (!lwc.isEmpty()) {
            this.whatsAppConta = (WhatsAppConta)lwc.get(0);
        } else {
            this.showNotification("N\u00e3o h\u00e1 conta de whatsapp Business criada nesta estrutura");
        }
        return new VerticalContainer(new Component[]{this.getGrid()});
    }

    private GridCrud<WhatsAppDayOff> getGrid() {
        GridCrud crud = new GridCrud(WhatsAppDayOff.class);
        crud.getGrid().setColumns(new String[0]);
        crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getData().format(FormatDate.DATE_BR.toDTF())))).setHeader("Data").setFlexGrow(0).setWidth("200px");
        crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getMensagem()))).setHeader("Mensagem").setFlexGrow(0).setWidth("350px");
        crud.getCrudFormFactory().setUseBeanValidation(true);
        crud.getCrudFormFactory().setVisibleProperties(new String[]{"data", "mensagem"});
        crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        return crud;
    }
}

