/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp;

import br.com.system.app.MainLayout;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.whatsapp.WhatsAppTemplateFormView;
import br.com.system.app.features.whatsapp.model.WhatsAppTemplate;
import br.com.system.app.features.whatsapp.service.WhatsAppTemplateService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;

@Route(value="cadastro-template-whatsapp", layout=MainLayout.class)
@PageTitle(value="Cadastro de template de Whatsapp")
@RolesAllowed(value={"MASTER"})
public class WhatsAppTemplateView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final WhatsAppTemplateService wts;
    private final WhatsAppTemplateFormView wtfv;
    private GridCrud<WhatsAppTemplate> crud;
    private Button bInsert;
    private Button bUpdate;

    @Autowired
    public WhatsAppTemplateView(WhatsAppTemplateService wts, WhatsAppTemplateFormView wtfv) {
        this.wts = wts;
        this.wtfv = wtfv;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado() && this.isMaster()) {
            this.setViewContent(this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private Component createContent() {
        this.wtfv.addOpenedChangeListener((ComponentEventListener & Serializable)e -> {
            if (!e.isOpened()) {
                this.crud.refreshGrid();
            }
        });
        this.bInsert = UIUtils.createSmallButton((String)"Inserir");
        this.bInsert.addClickListener((ComponentEventListener & Serializable)e -> this.wtfv.create(null));
        this.bUpdate = UIUtils.createSmallButton((String)"Editar");
        this.bUpdate.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.crud.getGrid().getSelectedItems() == null || this.crud.getGrid().getSelectedItems().size() <= 0) {
                UIUtils.showNotification((String)"Selecione um campo para Excluir");
                return;
            }
            WhatsAppTemplate t = (WhatsAppTemplate)this.crud.getGrid().getSelectedItems().iterator().next();
            this.wtfv.create(t);
        });
        this.crud = new GridCrud(WhatsAppTemplate.class);
        this.crud.getAddButton().setText("Adicionar");
        this.crud.getGrid().setColumns(new String[0]);
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getTemplateName()))).setHeader("Nome do Template").setFlexGrow(0).setWidth("200px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)(p.getCampos() != null && !p.getCampos().isEmpty() ? "SIM" : "N\u00c3O")))).setHeader("Tem Campos").setFlexGrow(0).setWidth("200px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)(p.getObrigaImagem() != null && p.getObrigaImagem() != false ? "SIM" : "N\u00c3O")))).setHeader("Obriga Imagem").setFlexGrow(0).setWidth("200px");
        this.crud.getAddButton().setVisible(false);
        this.crud.getUpdateButton().setVisible(false);
        this.crud.getDeleteButton().setVisible(false);
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        VerticalLayout mainLayout = new VerticalLayout();
        mainLayout.add(new Component[]{new HorizontalLayout(new Component[]{this.bInsert, this.bUpdate})});
        mainLayout.add(new Component[]{this.crud});
        return mainLayout;
    }
}

