/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp;

import br.com.system.app.components.AudioPlayer;
import br.com.system.app.components.Card;
import br.com.system.app.components.VideoView;
import br.com.system.app.components.containers.Container;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.layout.Color;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.shared.model.TranscricaoAudio;
import br.com.system.app.features.shared.service.TranscricaoAudioService;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.whatsapp.WhatsStatusImage;
import br.com.system.app.features.whatsapp.model.WhatsAppContentTipoEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppMensagem;
import br.com.system.app.features.whatsapp.model.WhatsAppMensagemTipoEnum;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.StreamResource;
import java.io.Serializable;

public class WhatsMsgView
extends VerticalContainer
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final WhatsAppMensagem msg;
    private final TranscricaoAudioService transcricaoAudioService;
    private final Container containerImage = new Container();
    private final HorizontalContainer containerStatus = new HorizontalContainer(new Component[0]);
    private final Span spanReacoes = new Span();
    private final Span spanError = new Span();
    private final Anchor anchorDownload = new Anchor();

    public WhatsMsgView(WhatsAppMensagem msg, TranscricaoAudioService transcricaoAudioService) {
        super(new Component[0]);
        this.msg = msg;
        this.transcricaoAudioService = transcricaoAudioService;
        this.create();
    }

    public void setStatus(WhatsAppMensagem msg) {
        this.containerStatus.removeAll();
        this.containerStatus.add(new Component[]{new WhatsStatusImage(msg.getStatus(), msg.getTipo())});
        if (msg.getReacoes() != null) {
            this.spanReacoes.setText(msg.getReacoes());
        }
        if (msg.getErro() != null && !msg.getErro().isEmpty()) {
            this.spanError.getElement().setProperty("innerHTML", msg.getErro());
        }
    }

    private void create() {
        this.getElement().getStyle().set("width", "auto");
        this.getElement().getStyle().set("border-radius", "10px");
        this.addClassNames(new String[]{"shadow-m"});
        this.setHorizontalAlign(FlexComponent.Alignment.END);
        if (!this.isMobileDevice()) {
            this.setMaxWidth("80%");
        } else {
            this.setMaxWidth("90%");
        }
        this.setPadding(true);
        this.setSpacing(false);
        this.spanReacoes.setTitle("Re\u00e7\u00f5es \u00e0 mensagem");
        this.spanError.setTitle("Erro ao enviar a mensagem");
        this.spanError.getStyle().set("color", "#410606");
        this.spanError.getStyle().set("font-weight", "bolder");
        this.containerStatus.setWidth("20px");
        this.containerStatus.setHeight("20px");
        this.containerStatus.setVerticalAlign(FlexComponent.Alignment.CENTER);
        this.containerImage.getButtonClose().addClickListener((ComponentEventListener & Serializable)e -> this.containerImage.close());
        this.containerImage.getButtonSave().setText("Download");
        this.containerImage.getFooter().add(new Component[]{this.anchorDownload});
        this.containerImage.setHeader("Visualiza\u00e7\u00e3o Imagem");
        this.anchorDownload.getElement().setAttribute("download", true);
        this.anchorDownload.add(new Component[]{this.containerImage.getButtonSave()});
        if (this.msg.getTipo().equals((Object)WhatsAppMensagemTipoEnum.ANOTACAO)) {
            this.createAnotationContent();
        } else if (this.msg.getContentTipo().equals((Object)WhatsAppContentTipoEnum.AUDIO)) {
            this.createAudioContent();
        } else if (this.msg.getContentTipo().equals((Object)WhatsAppContentTipoEnum.ARQUIVO)) {
            this.createDocContent();
        } else if (this.msg.getContentTipo().equals((Object)WhatsAppContentTipoEnum.IMAGEM)) {
            this.createImageContent();
        } else if (this.msg.getContentTipo().equals((Object)WhatsAppContentTipoEnum.TEXTO)) {
            this.createTextContent();
        } else if (this.msg.getContentTipo().equals((Object)WhatsAppContentTipoEnum.TEMPLATE)) {
            this.createTemplateContent();
        } else if (this.msg.getContentTipo().equals((Object)WhatsAppContentTipoEnum.BUTTONS)) {
            this.createButtonContent();
        } else if (this.msg.getContentTipo().equals((Object)WhatsAppContentTipoEnum.VIDEO)) {
            this.createVideoContent();
        }
        this.add(new Component[]{this.spanReacoes});
        this.setFooter();
        this.add(new Component[]{this.spanError});
        this.setStatus(this.msg);
    }

    private void setFooter() {
        HorizontalContainer footerContainer = new HorizontalContainer(new Component[0]);
        Span footerSpan = new Span();
        footerSpan.setEnabled(false);
        footerSpan.getStyle().set("text-align-last", "end");
        footerSpan.setWidth("100%");
        if (this.msg.getTipo().equals((Object)WhatsAppMensagemTipoEnum.ENVIADA)) {
            footerSpan.setText(this.msg.getEstruturaUsuario().getUsuario().getNome() + " " + this.msg.getDataHoraCriacao().format(FormatDate.DATETIME_BR.toDTF()));
            this.getStyle().set("align-self", "end");
            this.getStyle().set("background-color", "#005C4B");
            footerContainer.add(new Component[]{footerSpan, this.containerStatus});
            footerContainer.setNoWrap().setHorizontalAlign(FlexComponent.JustifyContentMode.END);
        } else if (this.msg.getTipo().equals((Object)WhatsAppMensagemTipoEnum.RECEBIDA)) {
            footerSpan.setText(this.msg.getDataHoraCriacao().format(FormatDate.DATETIME_BR.toDTF()));
            this.getStyle().set("align-self", "start");
            this.getStyle().set("background-color", "#202C33");
            footerContainer.add(new Component[]{footerSpan});
            footerContainer.setNoWrap().setHorizontalAlign(FlexComponent.JustifyContentMode.END);
        } else if (this.msg.getTipo().equals((Object)WhatsAppMensagemTipoEnum.ANOTACAO)) {
            footerSpan.setText(this.msg.getEstruturaUsuario().getUsuario().getNome() + " " + this.msg.getDataHoraCriacao().format(FormatDate.DATETIME_BR.toDTF()));
            footerContainer.add(new Component[]{footerSpan});
            footerContainer.setNoWrap().setHorizontalAlign(FlexComponent.JustifyContentMode.END);
        }
        this.add(new Component[]{footerContainer});
    }

    private void createButtonContent() {
        this.add(new Component[]{UIUtils.createButton((String)this.msg.getContent(), (VaadinIcon)VaadinIcon.REPLY)});
    }

    private void createTemplateContent() {
        try {
            String content = "Template " + this.msg.getContent();
            Span span = new Span(content);
            span.getStyle().set("color", Color.WHITE.getValue());
            this.add(new Component[]{span});
        }
        catch (Exception e) {
            this.add(new Component[]{new Span("Erro ao enviar Template ")});
        }
    }

    private void createAudioContent() {
        try {
            AudioPlayer player = new AudioPlayer();
            player.setSource(StorageUtil.getUrlSign((String)this.msg.getUrlFile(), (String)"bucket-neosales").getUrl());
            this.add(new Component[]{player});
            Button btnTranscription = UIUtils.createSmallButton((String)"Transcri\u00e7\u00e3o", (VaadinIcon)VaadinIcon.ELLIPSIS_CIRCLE, (String)"Transcri\u00e7\u00e3o do \u00e1udio");
            btnTranscription.addClickListener((ComponentEventListener & Serializable)t -> this.showTranscription(this.transcricaoAudioService, this.msg.getUrlFile()));
            this.add(new Component[]{btnTranscription});
            if (this.msg.getContent() != null) {
                this.createTextContent();
            }
        }
        catch (Exception e) {
            this.add(new Component[]{new Span("N\u00e3o consegui acessar o audio")});
        }
    }

    private void createDocContent() {
        try {
            if (this.msg.getUrlFile() == null || this.msg.getUrlFile().isEmpty()) {
                this.createTextContent();
                return;
            }
            Anchor anchor = new Anchor(StorageUtil.getUrlSign((String)this.msg.getUrlFile(), (String)"bucket-neosales").getUrl(), this.msg.getFileName());
            anchor.getElement().setAttribute("download", true);
            anchor.setTarget("_blank");
            this.add(new Component[]{anchor});
            if (this.msg.getFileName() != null && !this.msg.getFileName().isEmpty()) {
                this.add(new Component[]{new Span(this.msg.getFileName())});
            }
        }
        catch (Exception e) {
            this.add(new Component[]{new Span("N\u00e3o consegui acessar o Documento")});
        }
    }

    private void createVideoContent() {
        try {
            String url = StorageUtil.getUrlSign((String)this.msg.getUrlFile(), (String)"bucket-neosales").getUrl();
            VideoView video = new VideoView();
            video.show(url);
            video.setMaxHeight("200px");
            video.setMaxWidth("200px");
            this.add(new Component[]{video});
            video.addClickListener((ComponentEventListener & Serializable)e -> {
                VideoView videoExpanded = new VideoView();
                videoExpanded.show(url);
                videoExpanded.setMaxHeight("450px");
                this.anchorDownload.setHref(url);
                this.containerImage.clear();
                this.containerImage.insert(new Component[]{videoExpanded});
                this.containerImage.open();
            });
        }
        catch (Exception e2) {
            this.add(new Component[]{new Span("N\u00e3o consegui baixar o arquivo " + this.msg.getFileName())});
        }
    }

    private void createImageContent() {
        try {
            StreamResource sr = StorageUtil.getStreamResource((String)this.msg.getUrlFile(), (String)this.msg.getFileName(), (String)"bucket-neosales");
            Image image = new Image((AbstractStreamResource)sr, this.msg.getFileName());
            image.setMaxWidth("200px");
            image.setMaxHeight("200px");
            this.add(new Component[]{image});
            if (this.msg.getContent() != null && !this.msg.getContent().isEmpty()) {
                this.createTextContent();
            }
            image.addClickListener((ComponentEventListener & Serializable)e -> {
                this.anchorDownload.setHref((AbstractStreamResource)sr);
                this.containerImage.clear();
                this.containerImage.insert(new Component[]{new Image((AbstractStreamResource)sr, this.msg.getFileName())});
                this.containerImage.open();
            });
        }
        catch (Exception e2) {
            this.add(new Component[]{new Span("N\u00e3o consegui baixar o arquivo " + this.msg.getFileName())});
        }
    }

    private void createTextContent() {
        if (this.msg.getContent() == null) {
            return;
        }
        Div div = new Div();
        div.setMaxWidth("100%");
        div.getStyle().set("overflow-wrap", "anywhere");
        div.getElement().setProperty("innerHTML", this.msg.getContent().replace("\n", "<BR>"));
        div.getElement().setProperty("color", Color.WHITE.getValue());
        this.add(new Component[]{div});
    }

    private void createAnotationContent() {
        if (this.msg.getContent() == null) {
            return;
        }
        this.setWidth("100%");
        this.setMaxWidth("100%");
        this.getStyle().set("align-items", "center");
        this.getStyle().set("background-color", "#205371");
        this.setHorizontalAlign(FlexComponent.Alignment.CENTER);
        Object content = "Anotacao, o usuario nao vera essa mensagem";
        content = (String)content + "<BR><BR>" + this.msg.getContent();
        ((String)content).replace("\n", "<BR>");
        Div div = new Div();
        div.setMaxWidth("100%");
        div.getStyle().set("overflow-wrap", "anywhere");
        div.getElement().setProperty("innerHTML", (String)content);
        div.getElement().setProperty("color", Color.WHITE.getValue());
        this.add(new Component[]{div});
    }

    private void showTranscription(TranscricaoAudioService tas, String urlFile) {
        Dialog d = new Dialog();
        try {
            TranscricaoAudio ta = tas.get(urlFile);
            Card card = new Card();
            card.setMaxWidth("350px");
            Button btnClose = UIUtils.createSmallButton((String)"Fechar");
            btnClose.addClickListener((ComponentEventListener & Serializable)close -> d.close());
            Div div = new Div();
            div.getElement().setProperty("innerHTML", "<span style='font-size=small'><BR>" + ta.getTranscricao() + "<BR></span>");
            card.setContent(new Component[]{div});
            card.setHeader("Transcri\u00e7\u00e3o do \u00e1udio");
            card.setFooter(new Component[]{btnClose});
            d.add(new Component[]{card});
            d.setMaxWidth("400px");
            d.open();
        }
        catch (Exception e) {
            UIUtils.showNotification((String)"N\u00e3o consegui fazer a transcri\u00e7\u00e3o deste audio, desculpe");
            d.close();
        }
    }
}

