/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp.model;

import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.whatsapp.model.WhatsAppSetores;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.io.Serializable;
import org.hibernate.annotations.DynamicUpdate;

@Entity
@Table(name="whatsapp_atendente")
@DynamicUpdate
public class WhatsAppAtendente
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @OneToOne
    private EstruturaUsuario estruturaUsuario;
    private Boolean online;
    private String equipeIds;
    private Boolean ativo;
    private Boolean recebeAutomatico;
    private Boolean prioritario;
    @OneToOne
    private WhatsAppSetores whatsappSetores;

    public WhatsAppAtendente() {
    }

    public WhatsAppAtendente(EstruturaUsuario estruturaUsuario) {
        this.estruturaUsuario = estruturaUsuario;
    }

    public String getNome() {
        return this.estruturaUsuario.getUsuario().getNome();
    }

    public String getNomeAndLoginAndEquipe() {
        if (this.estruturaUsuario.getUsuario().isMaster()) {
            return "Bot " + this.estruturaUsuario.getUsuario().getLogin().replace("master@", "bot@");
        }
        return this.estruturaUsuario.getNomeUsuarioAndLoginUsuarioAndNomeEquipe();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public EstruturaUsuario getEstruturaUsuario() {
        return this.estruturaUsuario;
    }

    public void setEstruturaUsuario(EstruturaUsuario estruturaUsuario) {
        this.estruturaUsuario = estruturaUsuario;
    }

    public Boolean getOnline() {
        return this.online;
    }

    public void setOnline(Boolean online) {
        this.online = online;
    }

    public String getEquipeIds() {
        return this.equipeIds;
    }

    public void setEquipeIds(String equipeIds) {
        this.equipeIds = equipeIds;
    }

    public Boolean getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    public Boolean getRecebeAutomatico() {
        return this.recebeAutomatico;
    }

    public void setRecebeAutomatico(Boolean recebeAutomatico) {
        this.recebeAutomatico = recebeAutomatico;
    }

    public Boolean getPrioritario() {
        return this.prioritario;
    }

    public void setPrioritario(Boolean prioritario) {
        this.prioritario = prioritario;
    }

    public WhatsAppSetores getWhatsappSetores() {
        return this.whatsappSetores;
    }

    public void setWhatsappSetores(WhatsAppSetores whatsappSetores) {
        this.whatsappSetores = whatsappSetores;
    }
}

