/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp.repository;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.whatsapp.model.WhatsApp;
import br.com.system.app.features.whatsapp.model.WhatsAppConta;
import br.com.system.app.features.whatsapp.model.WhatsAppEtapaEnum;
import br.com.system.app.features.whatsapp.repository.WhatsAppRepositoryQuery;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

public interface WhatsAppRepository
extends JpaRepository<WhatsApp, Long>,
Serializable,
WhatsAppRepositoryQuery {
    public WhatsApp findByNumeroAndWhatsappConta(String var1, WhatsAppConta var2);

    public WhatsApp findFirstByNumeroAndWhatsappContaEstruturaAndWhatsappContaAtendimento(String var1, Estrutura var2, boolean var3);

    @Query(value="select w.* FROM whatsapp w,whatsapp_conta c WHERE w.whatsapp_conta_id=c.id AND find_in_set(:cpfCnpj, w.cpf_cnpj) and c.estrutura_id=:estruturaId", nativeQuery=true)
    public List<WhatsApp> findByCpfCnpjAndEstrutura(@Param(value="cpfCnpj") String var1, @Param(value="estruturaId") Long var2);

    public List<WhatsApp> findByUltimoAtendenteAndEtapaOrderByIdDesc(EstruturaUsuario var1, WhatsAppEtapaEnum var2);

    public List<WhatsApp> findByWhatsappContaEstruturaAndNomeContains(Estrutura var1, String var2);

    public List<WhatsApp> findByWhatsappContaEstruturaAndDataHoraCriacaoBetween(Estrutura var1, LocalDateTime var2, LocalDateTime var3);

    public List<WhatsApp> findByWhatsappConta(WhatsAppConta var1);

    @Query(value="select w.cpf_cnpj FROM whatsapp w,whatsapp_conta c WHERE w.whatsapp_conta_id=c.id and c.estrutura_id=:estruturaId", nativeQuery=true)
    public Set<String> findCnpjs(@Param(value="estruturaId") Long var1);

    @Modifying
    @Transactional
    public void deleteByWhatsappConta(WhatsAppConta var1);
}

