/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp.service;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.whatsapp.dto.WhatsAppFornecedorEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppConta;
import br.com.system.app.features.whatsapp.repository.WhatsAppContaRepository;
import br.com.system.app.features.whatsapp.service.WhatsAppMoorseApi;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class WhatsAppContaService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private WhatsAppContaRepository whatsAppContaRepository;
    @Autowired
    private WhatsAppMoorseApi WhatsAppMoorseApi;
    @Autowired
    private EstruturaUsuarioService eus;

    public List<WhatsAppConta> getByEstrutura(EstruturaUsuario eu, Pageable pageable) {
        if (eu.getUsuario().getWhatsappConta() != null && !this.eus.hasPermission(eu, "WHATSAPP_VER_TODAS_AS_CONTAS").booleanValue()) {
            return Collections.singletonList(eu.getUsuario().getWhatsappConta());
        }
        return this.whatsAppContaRepository.findByEstrutura(eu.getEstrutura(), pageable);
    }

    public List<WhatsAppConta> getByEstrutura(Estrutura e) {
        return this.whatsAppContaRepository.findByEstrutura(e);
    }

    public long contByEstrutura(EstruturaUsuario eu) {
        if (eu.getUsuario().getWhatsappConta() != null && !this.eus.hasPermission(eu, "WHATSAPP_VER_TODAS_AS_CONTAS").booleanValue()) {
            return 1L;
        }
        return this.whatsAppContaRepository.countByEstrutura(eu.getEstrutura());
    }

    public boolean checkIntegration(WhatsAppConta wc) {
        try {
            boolean ativo = this.WhatsAppMoorseApi.checkIntegration(wc.getMooseId());
            if (ativo != wc.isAtivo()) {
                wc.setObservacao(!ativo ? "Problemas integracao" : null);
                wc.setAtivo(ativo);
                this.save(wc);
            }
            return ativo;
        }
        catch (Exception e) {
            return false;
        }
    }

    public List<WhatsAppConta> getAtivos(Estrutura e) {
        return this.whatsAppContaRepository.findByEstruturaAndAtivo(e, true);
    }

    public WhatsAppConta getById(Long id) {
        return (WhatsAppConta)this.whatsAppContaRepository.findById((Object)id).get();
    }

    public List<WhatsAppConta> getContaByFornecedorAndAtivo(WhatsAppFornecedorEnum fornecedor, Boolean ativo) {
        return this.whatsAppContaRepository.findByFornecedorAndAtivo(fornecedor, ativo);
    }

    public WhatsAppConta getContaByMoorseId(String mi) {
        return this.whatsAppContaRepository.findByMooseId(mi);
    }

    public List<WhatsAppConta> getContaAtendimento(Boolean oficial) {
        return this.whatsAppContaRepository.findByAtendimentoAndAtivoAndApiOficial(true, Boolean.TRUE, oficial);
    }

    public List<WhatsAppConta> getContaNotificacao() {
        return this.whatsAppContaRepository.findByNotificacaoAndAtivoAndApiOficial(true, Boolean.TRUE, Boolean.valueOf(true));
    }

    public List<WhatsAppConta> getContaByEstruturaAtendimento(Estrutura e) {
        return this.whatsAppContaRepository.findByEstruturaAndAtendimentoAndAtivo(e, true, true);
    }

    public List<WhatsAppConta> getContaByEstruturaAndAtendimentoAndMarketing(Estrutura e, boolean atendimento, boolean marketing) {
        return this.whatsAppContaRepository.findByEstruturaAndAtendimentoAndMarketing(e, atendimento, marketing);
    }

    public List<WhatsAppConta> getContaMarketing(Boolean oficial) {
        return this.whatsAppContaRepository.findByMarketingAndAtivoAndApiOficial(true, Boolean.TRUE, oficial);
    }

    public List<WhatsAppConta> getContaByEstruturaMarketing(Estrutura e) {
        return this.whatsAppContaRepository.findByEstruturaAndMarketingAndAtivo(e, true, true);
    }

    public WhatsAppConta save(WhatsAppConta conta) {
        return (WhatsAppConta)this.whatsAppContaRepository.save((Object)conta);
    }

    public void delete(WhatsAppConta conta) {
        this.whatsAppContaRepository.delete((Object)conta);
    }
}

