/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp.service;

import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.waha.service.WahaSendService;
import br.com.system.app.features.whatsapp.model.WhatsApp;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendimento;
import br.com.system.app.features.whatsapp.model.WhatsAppContentTipoEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppHave;
import br.com.system.app.features.whatsapp.model.WhatsAppMensagem;
import br.com.system.app.features.whatsapp.model.WhatsAppMensagemTipoEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppStatusEnum;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendimentoService;
import br.com.system.app.features.whatsapp.service.WhatsAppHaveService;
import br.com.system.app.features.whatsapp.service.WhatsAppMensagemService;
import br.com.system.app.features.whatsapp.service.WhatsAppMoorseApi;
import br.com.system.app.features.whatsapp.service.WhatsAppSendService;
import br.com.system.commons.FileUtil;
import br.com.system.commons.HashUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class WhatsAppSendService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private WhatsAppMensagemService whatsAppMensagemService;
    @Autowired
    private EstruturaUsuarioService eus;
    @Autowired
    private WhatsAppAtendimentoService whatsAppAtendimentoService;
    @Autowired
    private WhatsAppMoorseApi api;
    @Autowired
    private WhatsAppHaveService whatsAppHaveService;
    @Autowired
    private WahaSendService wahaSendService;

    @Async(value="asyncDefault")
    public void sendAutenticacao(String numero, String codigo) {
        this.sendNeoMessage(numero, codigo);
    }

    public void sendNeoMessage(String numero, String mesage) {
        WhatsAppHave have = this.whatsAppHaveService.getHave(numero);
        if (have == null || !have.getHave().booleanValue()) {
            return;
        }
    }

    public WhatsAppMensagem sendButton(WhatsAppAtendimento wa, EstruturaUsuario eu, String title, String subtitle, List<String> buttons) {
        if (buttons == null || buttons.isEmpty()) {
            return null;
        }
        WhatsAppMensagem m = new WhatsAppMensagem();
        m.setContentTipo(WhatsAppContentTipoEnum.BUTTONS);
        m.setEstruturaUsuario(eu);
        m.setTipo(WhatsAppMensagemTipoEnum.ENVIADA);
        m.setWhatsappAtendimento(wa);
        m.setTitle(title);
        m.setSubtitle(subtitle);
        m.setButtons(StringUtils.join(buttons, (String)","));
        m = this.sendMensagem(wa, m);
        return m;
    }

    @Async(value="asyncDefault")
    public void sendTemplate(WhatsAppAtendimento wa, EstruturaUsuario eu, String message, Consumer<WhatsAppMensagem> listener) {
        Thread.currentThread().setName("asyncDefault-whatsapp-send-message-template");
        WhatsAppMensagem m = this.sendTemplate(wa, eu, message);
        if (listener != null) {
            listener.accept(m);
        }
    }

    public WhatsAppMensagem sendTemplate(WhatsAppAtendimento wa, EstruturaUsuario eu, String message) {
        WhatsAppMensagem m = new WhatsAppMensagem();
        m.setContentTipo(WhatsAppContentTipoEnum.TEMPLATE);
        m.setContent(message);
        m.setEstruturaUsuario(eu);
        m.setTipo(WhatsAppMensagemTipoEnum.ENVIADA);
        m.setWhatsappAtendimento(wa);
        m = this.sendMensagem(wa, m);
        return m;
    }

    @Async(value="asyncDefault")
    public void sendMessageText(WhatsAppAtendimento wa, EstruturaUsuario eu, String mensagem, Consumer<WhatsAppMensagem> listener) {
        Thread.currentThread().setName("asyncDefault-whatsapp-send-message-text");
        WhatsAppMensagem m = this.sendMessageText(wa, eu, mensagem);
        if (listener != null) {
            listener.accept(m);
        }
    }

    public WhatsAppMensagem sendMessageText(WhatsAppAtendimento wa, EstruturaUsuario eu, String mensagem) {
        if (mensagem == null || mensagem.isEmpty()) {
            return null;
        }
        WhatsAppMensagem m = new WhatsAppMensagem();
        m.setContent(mensagem);
        m.setContentTipo(WhatsAppContentTipoEnum.TEXTO);
        m.setEstruturaUsuario(eu);
        m.setTipo(WhatsAppMensagemTipoEnum.ENVIADA);
        m.setWhatsappAtendimento(wa);
        m = this.sendMensagem(wa, m);
        return m;
    }

    public WhatsAppMensagem sendListMenu(WhatsAppAtendimento wa, EstruturaUsuario eu, List<String> lista) {
        if (lista == null || lista.isEmpty()) {
            return null;
        }
        WhatsAppMensagem m = new WhatsAppMensagem();
        m.setContent(StringUtils.join(lista, (String)","));
        m.setContentTipo(WhatsAppContentTipoEnum.LISTA);
        m.setEstruturaUsuario(eu);
        m.setTipo(WhatsAppMensagemTipoEnum.ENVIADA);
        m.setWhatsappAtendimento(wa);
        m = this.sendMensagem(wa, m);
        return m;
    }

    @Async(value="asyncDefault")
    public void sendMessageFile(WhatsAppAtendimento wa, EstruturaUsuario eu, byte[] bytes, String nomeArquivo, Consumer<WhatsAppMensagem> listener) {
        if (bytes == null) {
            return;
        }
        Thread.currentThread().setName("asyncDefault-whatsapp-send-message-file");
        try {
            String extensao = FileUtil.getExtension((String)nomeArquivo);
            String fileName = HashUtil.getUUI() + extensao;
            String url = StorageUtil.uploadObjectByteArray((String)fileName, (byte[])bytes);
            WhatsAppMensagem m = new WhatsAppMensagem();
            m.setContent("");
            m.setUrlFile(url);
            m.setFileName(nomeArquivo);
            String tipos = ".PNG,.JPG,.JPEG";
            if (tipos.contains(extensao.toUpperCase())) {
                m.setContentTipo(WhatsAppContentTipoEnum.IMAGEM);
            } else {
                m.setContentTipo(WhatsAppContentTipoEnum.ARQUIVO);
            }
            m.setEstruturaUsuario(eu);
            m.setTipo(WhatsAppMensagemTipoEnum.ENVIADA);
            m.setWhatsappAtendimento(wa);
            m = this.sendMensagem(wa, m);
            if (listener != null) {
                listener.accept(m);
            }
        }
        catch (Exception e) {
            throw new BusinessException("Erro ao enviar arquivo " + e.getMessage());
        }
    }

    @Async(value="asyncDefault")
    public void sendMessageAudio(WhatsAppAtendimento wa, EstruturaUsuario eu, String hash, Consumer<WhatsAppMensagem> listener) {
        Thread.currentThread().setName("asyncDefault-whatsapp-send-message-audio");
        try {
            if (hash == null || hash.isEmpty()) {
                return;
            }
            WhatsAppMensagem m = new WhatsAppMensagem();
            m.setContent("");
            m.setUrlFile(hash);
            m.setFileName("audio.mp3");
            m.setContentTipo(WhatsAppContentTipoEnum.AUDIO);
            m.setEstruturaUsuario(eu);
            m.setTipo(WhatsAppMensagemTipoEnum.ENVIADA);
            m.setWhatsappAtendimento(wa);
            m = this.sendMensagem(wa, m);
            if (listener != null) {
                listener.accept(m);
            }
        }
        catch (Exception e) {
            throw new BusinessException("Erro ao enviar arquivo " + e.getMessage());
        }
    }

    @Async(value="asyncDefault")
    public void sendMessageVideo(WhatsAppAtendimento wa, EstruturaUsuario eu, String hash, String fileName, Consumer<WhatsAppMensagem> listener) {
        Thread.currentThread().setName("asyncDefault-whatsapp-send-message-video");
        try {
            if (hash == null || hash.isEmpty()) {
                return;
            }
            WhatsAppMensagem m = new WhatsAppMensagem();
            m.setContent("");
            m.setUrlFile(hash);
            m.setFileName(fileName);
            m.setContentTipo(WhatsAppContentTipoEnum.VIDEO);
            m.setEstruturaUsuario(eu);
            m.setTipo(WhatsAppMensagemTipoEnum.ENVIADA);
            m.setWhatsappAtendimento(wa);
            m = this.sendMensagem(wa, m);
            if (listener != null) {
                listener.accept(m);
            }
        }
        catch (Exception e) {
            throw new BusinessException("Erro ao enviar arquivo " + e.getMessage());
        }
    }

    private WhatsAppMensagem sendMensagem(WhatsAppAtendimento wa, WhatsAppMensagem message) {
        JSONObject jsonReturn = null;
        try {
            WhatsApp w = message.getWhatsappAtendimento().getWhatsapp();
            if (w == null || w.getWhatsappConta() == null || w.getWhatsappConta().getMooseId() == null) {
                throw new BusinessException("Erro nas configuracoes");
            }
            if (message.getStatus() == null) {
                message.setStatus(WhatsAppStatusEnum.PENDENTE);
            }
            if (message.getDataHoraCriacao() == null) {
                message.setDataHoraCriacao(LocalDateTime.now());
            }
            if (message.getEstruturaUsuario() == null) {
                message.setEstruturaUsuario(this.eus.getMasterEstrutura(w.getWhatsappConta().getEstrutura()));
            }
            switch (1.$SwitchMap$br$com$system$app$features$whatsapp$dto$WhatsAppFornecedorEnum[wa.getWhatsapp().getWhatsappConta().getFornecedor().ordinal()]) {
                case 1: {
                    jsonReturn = message.getUrlFile() == null ? this.api.send(message) : this.api.sendFile(message, message.getUrlFile());
                    message.setMessageId(jsonReturn.getJSONObject("data").getString("control"));
                    break;
                }
                case 2: {
                    message.setMessageId(this.wahaSendService.sendMessage(message));
                    break;
                }
                default: {
                    throw new Exception("Fornecedor nao encontrado");
                }
            }
            message.setContent(message.getContent());
            message = this.whatsAppMensagemService.saveMessage(message);
            wa.setDataHoraUltimoEnvio(LocalDateTime.now());
            this.whatsAppAtendimentoService.save(wa);
            return message;
        }
        catch (Exception e) {
            message.setObservacoes(e.getMessage());
            message.setStatus(WhatsAppStatusEnum.ERRO);
            this.whatsAppMensagemService.saveMessage(message);
            throw new BusinessException("Erro ao enviar " + e.getMessage() + (jsonReturn == null ? "" : jsonReturn.toString()));
        }
    }

    public void mostraCnpj(WhatsApp w, WhatsAppAtendimento wa, EstruturaUsuario master) {
        ArrayList<String> buttons = new ArrayList<String>();
        String[] cnpjs = w.getCpfCnpj().split(",");
        if (cnpjs.length > 3) {
            Object msg = "Para qual CNPJ voc\u00ea quer atendimento?\n";
            int i = 1;
            for (String cnpj : cnpjs) {
                msg = (String)msg + "\nDigite " + i + " para CNPJ " + cnpj + " ou";
                ++i;
            }
            msg = (String)msg + "\nDigite 0 para cadastrar um novo CNPJ";
            this.sendMessageText(wa, master, (String)msg);
        } else {
            for (String cnpj : cnpjs) {
                if (buttons.contains(cnpj)) continue;
                buttons.add(cnpj);
            }
            this.sendButton(wa, master, "Para qual cnpj deseja atendimento?", "", buttons);
            buttons.clear();
            buttons.add("Inserir Novo");
            this.sendButton(wa, master, "Clique abaixo para inserir um novo", "", buttons);
        }
    }
}

