/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp.service;

import br.com.system.app.features.whatsapp.model.WhatsApp;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendimento;
import br.com.system.app.features.whatsapp.model.WhatsAppConta;
import br.com.system.app.features.whatsapp.model.WhatsAppEtapaEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppMensagem;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendimentoService;
import br.com.system.app.features.whatsapp.service.WhatsAppSendService;
import br.com.system.app.features.whatsapp.service.WhatsAppService;
import br.com.system.commons.datetime.FormatDate;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WhatsAppTimeService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private WhatsAppSendService send;
    @Autowired
    private WhatsAppService whatsAppService;
    @Autowired
    private WhatsAppAtendimentoService whatsAppAtendimentoService;

    public boolean isAlmoco(WhatsAppConta conta) {
        if (conta.getHoraFinal1() == null || conta.getHoraInicial2() == null) {
            return false;
        }
        LocalTime fim1 = conta.getHoraFinal1().plusMinutes(1L);
        LocalTime ini2 = conta.getHoraInicial2().minusMinutes(1L);
        return LocalTime.now().isAfter(fim1) && LocalTime.now().isBefore(ini2);
    }

    public boolean noHorario(WhatsAppAtendimento wa) {
        WhatsApp w = wa.getWhatsapp();
        if (w.getEtapa().equals((Object)WhatsAppEtapaEnum.ATENDENTE)) {
            return true;
        }
        return this.noHorario(w.getWhatsappConta());
    }

    public boolean noHorario(WhatsAppConta conta) {
        DayOfWeek dow = LocalDate.now().getDayOfWeek();
        if (dow == DayOfWeek.SUNDAY) {
            return false;
        }
        if (dow == DayOfWeek.SATURDAY && conta.getHoraInicialSabado() == null) {
            return false;
        }
        if (conta.getHoraInicial1() == null || conta.getHoraFinal2() == null) {
            return true;
        }
        LocalTime ini1 = conta.getHoraInicial1().minusMinutes(1L);
        LocalTime fim2 = conta.getHoraFinal2().plusMinutes(1L);
        return LocalTime.now().isAfter(ini1) && LocalTime.now().isBefore(fim2);
    }

    public WhatsAppMensagem sendAlmoco(WhatsAppAtendimento wa) {
        WhatsApp w = wa.getWhatsapp();
        LocalTime ini2 = w.getWhatsappConta().getHoraInicial2();
        String msg = "Nosso atendimento est\u00e1 em hor\u00e1rio de almo\u00e7o e retorna \u00e0s " + ini2.format(FormatDate.TIME_BR_NO_SEC.toDTF()) + ".\nMas n\u00e3o se preocupe, assim que voltarmos trataremos sua solicita\u00e7\u00e3o!";
        return this.send.sendMessageText(wa, wa.getWhatsapp().getUltimoAtendente(), msg);
    }

    public WhatsAppMensagem sendOffTime(WhatsAppAtendimento wa) {
        WhatsApp w = wa.getWhatsapp();
        LocalTime ini1 = w.getWhatsappConta().getHoraInicial1();
        LocalTime fim1 = w.getWhatsappConta().getHoraFinal1();
        LocalTime ini2 = w.getWhatsappConta().getHoraInicial2();
        LocalTime fim2 = w.getWhatsappConta().getHoraFinal2();
        LocalTime sabadoIni = w.getWhatsappConta().getHoraInicialSabado();
        LocalTime sabadoFim = w.getWhatsappConta().getHoraFinalSabado();
        Object msg = ini1 != null && fim1 != null ? "Neste momento n\u00e3o estamos online.\nNosso hor\u00e1rio de atendimento \u00e9 de:\nSegunda \u00e0 sexta das " + ini1.format(FormatDate.TIME_BR_NO_SEC.toDTF()) + " \u00e0s " + fim1.format(FormatDate.TIME_BR_NO_SEC.toDTF()) : (ini1 != null && fim2 != null ? "Neste momento n\u00e3o estamos online.\nNosso hor\u00e1rio de atendimento \u00e9 de:\nSegunda \u00e0 sexta das " + ini1.format(FormatDate.TIME_BR_NO_SEC.toDTF()) + " \u00e0s " + fim2.format(FormatDate.TIME_BR_NO_SEC.toDTF()) : "Neste momento n\u00e3o estamos online, por favor tente mais tarde.");
        if (ini2 != null && fim2 != null) {
            msg = (String)msg + " e " + ini2.format(FormatDate.TIME_BR_NO_SEC.toDTF()) + " \u00e0s " + fim2.format(FormatDate.TIME_BR_NO_SEC.toDTF());
        }
        if (sabadoIni != null && sabadoFim != null) {
            msg = (String)msg + "\nS\u00e1bado das " + sabadoIni.format(FormatDate.TIME_BR_NO_SEC.toDTF()) + " \u00e0s " + sabadoFim.format(FormatDate.TIME_BR_NO_SEC.toDTF());
        }
        WhatsAppMensagem m = this.send.sendMessageText(wa, wa.getWhatsapp().getUltimoAtendente(), (String)msg);
        w.setEtapa(WhatsAppEtapaEnum.FECHADO);
        this.whatsAppService.save(w);
        wa.setEtapa(WhatsAppEtapaEnum.FECHADO);
        wa.setFechado(true);
        this.whatsAppAtendimentoService.save(wa);
        return m;
    }
}

