/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.commons.decimal;

import br.com.system.commons.CurrencyUtil;
import br.com.system.commons.decimal.DecimalParser;
import java.math.BigDecimal;

public class DecimalNumber {
    private DecimalParser decimalParser;
    private BigDecimal store;
    private int precision;

    public DecimalNumber() {
        this(BigDecimal.ZERO);
    }

    public DecimalNumber(int precision) {
        this(BigDecimal.ZERO, precision);
    }

    public DecimalNumber(Integer value) {
        this((Object)value);
    }

    public DecimalNumber(Long value) {
        this((Object)value);
    }

    public DecimalNumber(Double value) {
        this((Object)value);
    }

    public DecimalNumber(Float value) {
        this((Object)value);
    }

    public DecimalNumber(String value) {
        this((Object)value);
    }

    public DecimalNumber(BigDecimal value) {
        this((Object)value);
    }

    private DecimalNumber(Object value) {
        this(value, 2);
    }

    public DecimalNumber(Integer value, int precision) {
        this((Object)value, precision);
    }

    public DecimalNumber(Long value, int precision) {
        this((Object)value, precision);
    }

    public DecimalNumber(Double value, int precision) {
        this((Object)value, precision);
    }

    public DecimalNumber(Float value, int precision) {
        this((Object)value, precision);
    }

    public DecimalNumber(String value, int precision) {
        this((Object)value, precision);
    }

    public DecimalNumber(BigDecimal value, int precision) {
        this((Object)value, precision);
    }

    private DecimalNumber(Object value, int precision) {
        this.precision = precision;
        this.decimalParser = new DecimalParser(precision);
        this.store = this.parseOrElseGet(value);
    }

    public DecimalNumber setPrecision(int precision) {
        this.precision = precision;
        return this;
    }

    public DecimalNumber plus(Integer value) {
        return this.plus((Object)value);
    }

    public DecimalNumber plus(Long value) {
        return this.plus((Object)value);
    }

    public DecimalNumber plus(Double value) {
        return this.plus((Object)value);
    }

    public DecimalNumber plus(Float value) {
        return this.plus((Object)value);
    }

    public DecimalNumber plus(String value) {
        return this.plus((Object)value);
    }

    public DecimalNumber plus(BigDecimal value) {
        return this.plus((Object)value);
    }

    public DecimalNumber minus(Integer value) {
        return this.minus((Object)value);
    }

    public DecimalNumber minus(Long value) {
        return this.minus((Object)value);
    }

    public DecimalNumber minus(Double value) {
        return this.minus((Object)value);
    }

    public DecimalNumber minus(Float value) {
        return this.minus((Object)value);
    }

    public DecimalNumber minus(String value) {
        return this.minus((Object)value);
    }

    public DecimalNumber minus(BigDecimal value) {
        return this.minus((Object)value);
    }

    public DecimalNumber mult(Integer value) {
        return this.mult((Object)value);
    }

    public DecimalNumber mult(Long value) {
        return this.mult((Object)value);
    }

    public DecimalNumber mult(Double value) {
        return this.mult((Object)value);
    }

    public DecimalNumber mult(Float value) {
        return this.mult((Object)value);
    }

    public DecimalNumber mult(String value) {
        return this.mult((Object)value);
    }

    public DecimalNumber mult(BigDecimal value) {
        return this.mult((Object)value);
    }

    public DecimalNumber divide(Integer value) {
        return this.divide((Object)value);
    }

    public DecimalNumber divide(Long value) {
        return this.divide((Object)value);
    }

    public DecimalNumber divide(Double value) {
        return this.divide((Object)value);
    }

    public DecimalNumber divide(Float value) {
        return this.divide((Object)value);
    }

    public DecimalNumber divide(String value) {
        return this.divide((Object)value);
    }

    public DecimalNumber divide(BigDecimal value) {
        return this.divide((Object)value);
    }

    public BigDecimal result() {
        return this.result(this.precision);
    }

    public BigDecimal result(int precision) {
        return new BigDecimal(this.setPrecision(precision).parseStore());
    }

    public Integer resultAsInteger() {
        return this.result().intValue();
    }

    public Long resultAsLong() {
        return this.result().longValue();
    }

    public Double resultAsDouble() {
        return this.result().doubleValue();
    }

    public Float resultAsFloat() {
        return Float.valueOf(this.result().floatValue());
    }

    public Boolean lessThanZero() {
        return this.result().compareTo(BigDecimal.ZERO) < 0;
    }

    public Boolean lessOrEqualThanZero() {
        return this.result().compareTo(BigDecimal.ZERO) <= 0;
    }

    public Boolean greaterThanZero() {
        return this.result().compareTo(BigDecimal.ZERO) > 0;
    }

    public String toString() {
        return this.result().toString();
    }

    public DecimalNumber abs() {
        this.store = this.store.abs();
        return this;
    }

    public DecimalNumber pow(int n) {
        this.store = this.store.pow(n);
        return this;
    }

    private DecimalNumber plus(Object value) {
        this.store = this.store.add(this.parseOrElseGet(value));
        return this;
    }

    private DecimalNumber minus(Object value) {
        this.store = this.store.subtract(this.parseOrElseGet(value));
        return this;
    }

    private DecimalNumber mult(Object value) {
        this.store = this.store.multiply(this.parseOrElseGet(value));
        return this;
    }

    private DecimalNumber divide(Object value) {
        this.store = this.store.divide(this.parseOrElseGet(value));
        return this;
    }

    private BigDecimal parseOrElseGet(Object value) {
        if (value instanceof String) {
            return CurrencyUtil.parse((String)value.toString());
        }
        return new BigDecimal(value.toString());
    }

    private String parseStore() {
        return this.decimalParser.parse((Object)this.store, this.precision);
    }
}

