/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.integreation.conexaoExterna.method;

import br.com.system.integreation.conexaoExterna.exception.ExternalConnectionException;
import br.com.system.integreation.conexaoExterna.method.Request;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.protocol.HttpContext;

public class Post
extends Request {
    private HttpPost method;

    public Post(String url, HttpHost serverProxy, Integer timeOut) {
        super(url, serverProxy, timeOut);
    }

    public Request execute() throws ExternalConnectionException {
        try {
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.timeOut.intValue()).setConnectTimeout(this.timeOut.intValue()).setProxy(this.serverProxy).build();
            this.method = new HttpPost(this.url);
            this.method.setConfig(requestConfig);
            this.header.setMethodHeaders((AbstractHttpMessage)this.method).resetHeaders();
            this.method.setEntity(this.parameters.getParametersPost());
            this.response = this.httpClient.execute((HttpUriRequest)this.method, (HttpContext)this.httpContext.getHttpContext());
            this.entity = this.response.getEntity();
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException ex) {
            throw new ExternalConnectionException("Connection error.");
        }
        return this;
    }

    public void releaseConnection() {
        if (this.method != null) {
            this.method.releaseConnection();
        }
    }
}

