/*
 * Decompiled with CFR 0.152.
 */
import com.github.anastaciocintra.output.PrinterOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;

public class LinuxPrinterFix {
    private static final String TAG = "LinuxPrinterFix";

    public static PrinterOutputStream createFixedPrinterOutputStream(String printerName) throws IOException {
        PrintService printService = LinuxPrinterFix.findPrintServiceByName(printerName);
        if (printService == null) {
            throw new IOException("Impressora n\u00e3o encontrada: " + printerName);
        }
        boolean isLinuxARM = LinuxPrinterFix.isLinuxARM();
        if (isLinuxARM) {
            System.out.println("LinuxPrinterFix: Linux ARM detectado - aplicando corre\u00e7\u00f5es");
            return new ARMPrinterOutputStream(printService);
        }
        return new PrinterOutputStream(printService);
    }

    private static boolean isLinuxARM() {
        String os = System.getProperty("os.name", "").toLowerCase();
        String arch = System.getProperty("os.arch", "").toLowerCase();
        return os.contains("linux") && (arch.contains("arm") || arch.contains("aarch"));
    }

    private static PrintService findPrintServiceByName(String printerName) {
        PrintService[] services;
        for (PrintService service : services = PrintServiceLookup.lookupPrintServices(null, null)) {
            String serviceName = service.getName();
            if (serviceName == null || !serviceName.equalsIgnoreCase(printerName)) continue;
            return service;
        }
        return null;
    }

    public static void testPrinterFix(String printerName) {
        try {
            System.out.println("LinuxPrinterFix: Testando corre\u00e7\u00e3o para " + printerName);
            PrinterOutputStream pos = LinuxPrinterFix.createFixedPrinterOutputStream(printerName);
            Object testText = "=== TESTE LINUX ARM CORRE\u00c7\u00c3O ===\n";
            testText = (String)testText + "Data: " + String.valueOf(new Date()) + "\n";
            testText = (String)testText + "Arquitetura: " + System.getProperty("os.arch") + "\n";
            testText = (String)testText + "OS: " + System.getProperty("os.name") + "\n";
            testText = (String)testText + "============================\n\n";
            pos.write(((String)testText).getBytes());
            pos.close();
            System.out.println("LinuxPrinterFix: \u2705 Teste completado com sucesso");
        }
        catch (Exception e) {
            System.err.println("LinuxPrinterFix: \u274c Erro no teste: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static class ARMPrinterOutputStream
    extends PrinterOutputStream {
        private PrintService printService;
        private ByteArrayOutputStream buffer;
        private boolean closed = false;
        private boolean useWorkaround = true;

        public ARMPrinterOutputStream(PrintService printService) throws IOException {
            super(printService);
            this.printService = printService;
            this.buffer = new ByteArrayOutputStream();
        }

        @Override
        public void write(int b) throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            if (this.useWorkaround) {
                this.buffer.write(b);
            } else {
                super.write(b);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            if (this.useWorkaround) {
                this.buffer.write(b, off, len);
            } else {
                super.write(b, off, len);
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.closed) {
                return;
            }
            if (this.useWorkaround && this.buffer.size() > 0) {
                try {
                    byte[] data = this.buffer.toByteArray();
                    this.printWithWorkaround(data);
                    this.buffer.reset();
                    System.out.println("LinuxPrinterFix: Dados enviados usando workaround ARM");
                }
                catch (Exception e) {
                    System.err.println("LinuxPrinterFix: Workaround falhou, tentando m\u00e9todo padr\u00e3o: " + e.getMessage());
                    this.useWorkaround = false;
                    try {
                        super.write(this.buffer.toByteArray());
                        super.flush();
                        this.buffer.reset();
                    }
                    catch (Exception fallbackError) {
                        throw new IOException("Ambos os m\u00e9todos de impress\u00e3o falharam. ARM: " + e.getMessage() + ", Padr\u00e3o: " + fallbackError.getMessage(), e);
                    }
                }
            } else {
                super.flush();
            }
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                try {
                    this.flush();
                }
                finally {
                    super.close();
                    this.closed = true;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void printWithWorkaround(byte[] data) throws IOException {
            Path tempFile = null;
            try {
                boolean finished;
                Process process;
                String cmd;
                Path tempDir = Paths.get("/tmp", new String[0]);
                if (!Files.exists(tempDir, new LinkOption[0])) {
                    tempDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
                }
                tempFile = Files.createTempFile(tempDir, "armprint_", ".prn", new FileAttribute[0]);
                Files.write(tempFile, data, new OpenOption[0]);
                try {
                    Process permProcess = Runtime.getRuntime().exec(new String[]{"chmod", "644", tempFile.toString()});
                    permProcess.waitFor(2L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    System.err.println("LinuxPrinterFix: Aviso - n\u00e3o foi poss\u00edvel alterar permiss\u00f5es: " + e.getMessage());
                }
                Thread.sleep(100L);
                if (!Files.exists(tempFile, new LinkOption[0])) throw new IOException("Arquivo tempor\u00e1rio n\u00e3o foi criado corretamente");
                if (Files.size(tempFile) == 0L) {
                    throw new IOException("Arquivo tempor\u00e1rio n\u00e3o foi criado corretamente");
                }
                boolean success = false;
                Object lastError = "";
                if (!success) {
                    try {
                        cmd = new String[]{"lpr", "-P" + this.printService.getName(), tempFile.toString()};
                        process = Runtime.getRuntime().exec((String[])cmd);
                        finished = process.waitFor(10L, TimeUnit.SECONDS);
                        if (finished && process.exitValue() == 0) {
                            System.out.println("LinuxPrinterFix: \u2705 Sucesso com lpr direto");
                            success = true;
                        } else {
                            lastError = "lpr retornou c\u00f3digo: " + String.valueOf(finished ? Integer.valueOf(process.exitValue()) : "timeout");
                        }
                    }
                    catch (Exception e) {
                        lastError = "lpr direto falhou: " + e.getMessage();
                        System.err.println("LinuxPrinterFix: " + (String)lastError);
                    }
                }
                if (!success) {
                    try {
                        cmd = new String[]{"lpr", "-P" + this.printService.getName(), "-o", "raw", tempFile.toString()};
                        process = Runtime.getRuntime().exec((String[])cmd);
                        finished = process.waitFor(10L, TimeUnit.SECONDS);
                        if (finished && process.exitValue() == 0) {
                            System.out.println("LinuxPrinterFix: \u2705 Sucesso com lpr raw");
                            success = true;
                        } else {
                            lastError = "lpr raw retornou c\u00f3digo: " + String.valueOf(finished ? Integer.valueOf(process.exitValue()) : "timeout");
                        }
                    }
                    catch (Exception e) {
                        lastError = "lpr raw falhou: " + e.getMessage();
                        System.err.println("LinuxPrinterFix: " + (String)lastError);
                    }
                }
                if (!success) {
                    try {
                        cmd = "cat \"" + tempFile.toString() + "\" | lpr -P" + this.printService.getName();
                        process = Runtime.getRuntime().exec(new String[]{"bash", "-c", cmd});
                        finished = process.waitFor(10L, TimeUnit.SECONDS);
                        if (finished && process.exitValue() == 0) {
                            System.out.println("LinuxPrinterFix: \u2705 Sucesso com cat + lpr pipe");
                            success = true;
                        } else {
                            lastError = "cat+lpr retornou c\u00f3digo: " + String.valueOf(finished ? Integer.valueOf(process.exitValue()) : "timeout");
                        }
                    }
                    catch (Exception e) {
                        lastError = "cat+lpr falhou: " + e.getMessage();
                        System.err.println("LinuxPrinterFix: " + (String)lastError);
                    }
                }
                if (!success) {
                    try {
                        cmd = new String[]{"lp", "-d", this.printService.getName(), tempFile.toString()};
                        process = Runtime.getRuntime().exec((String[])cmd);
                        finished = process.waitFor(10L, TimeUnit.SECONDS);
                        if (finished && process.exitValue() == 0) {
                            System.out.println("LinuxPrinterFix: \u2705 Sucesso com lp");
                            success = true;
                        } else {
                            lastError = "lp retornou c\u00f3digo: " + String.valueOf(finished ? Integer.valueOf(process.exitValue()) : "timeout");
                        }
                    }
                    catch (Exception e) {
                        lastError = "lp falhou: " + e.getMessage();
                        System.err.println("LinuxPrinterFix: " + (String)lastError);
                    }
                }
                if (!success) {
                    throw new IOException("Todas as estrat\u00e9gias de impress\u00e3o falharam. \u00daltimo erro: " + (String)lastError);
                }
                if (tempFile == null) return;
            }
            catch (InterruptedException e) {
                try {
                    Thread.currentThread().interrupt();
                    throw new IOException("Interrompido durante impress\u00e3o", e);
                }
                catch (Throwable throwable) {
                    if (tempFile == null) throw throwable;
                    try {
                        Files.deleteIfExists(tempFile);
                        throw throwable;
                    }
                    catch (Exception e2) {
                        System.err.println("LinuxPrinterFix: Aviso - n\u00e3o foi poss\u00edvel deletar arquivo tempor\u00e1rio: " + e2.getMessage());
                    }
                    throw throwable;
                }
            }
            try {
                Files.deleteIfExists(tempFile);
                return;
            }
            catch (Exception e) {
                System.err.println("LinuxPrinterFix: Aviso - n\u00e3o foi poss\u00edvel deletar arquivo tempor\u00e1rio: " + e.getMessage());
                return;
            }
        }
    }
}

