/*
 * Decompiled with CFR 0.152.
 */
package com.itautec.scope;

public class ScopeRegistroMedicamento {
    private String codigoEAN;
    private int qtdProdutos;
    private String precoPMC;
    private String precoVenda;
    private String precoFabrica;
    private String precoAquisicao;
    private String precoRepasse;
    private char reservadoFuturo;
    private String motivoRejeicao;
    private String crm;
    private String numeroConvenio;

    public String getCrm() {
        return this.crm;
    }

    public void setCrm(String string) {
        this.crm = string;
    }

    public String getCodigoEAN() {
        return this.codigoEAN;
    }

    public void setCodigoEAN(String string) {
        this.codigoEAN = string;
    }

    public int getQtdProdutos() {
        return this.qtdProdutos;
    }

    public void setQtdProdutos(int n) {
        this.qtdProdutos = n;
    }

    public String getPrecoPMC() {
        return this.precoPMC;
    }

    public void setPrecoPMC(String string) {
        this.precoPMC = string;
    }

    public String getPrecoVenda() {
        return this.precoVenda;
    }

    public void setPrecoVenda(String string) {
        this.precoVenda = string;
    }

    public String getPrecoFabrica() {
        return this.precoFabrica;
    }

    public void setPrecoFabrica(String string) {
        this.precoFabrica = string;
    }

    public String getPrecoAquisicao() {
        return this.precoAquisicao;
    }

    public void setPrecoAquisicao(String string) {
        this.precoAquisicao = string;
    }

    public String getPrecoRepasse() {
        return this.precoRepasse;
    }

    public void setPrecoRepasse(String string) {
        this.precoRepasse = string;
    }

    public String getMotivoRejeicao() {
        return this.motivoRejeicao;
    }

    public void setMotivoRejeicao(String string) {
        this.motivoRejeicao = string;
    }

    public String getNumeroConvenio() {
        return this.numeroConvenio;
    }

    public void setNumeroConvenio(String string) {
        this.numeroConvenio = string;
    }

    protected char getReservadoFuturo() {
        return this.reservadoFuturo;
    }

    protected void setReservadoFuturo(char c) {
        this.reservadoFuturo = c;
    }

    public static ScopeRegistroMedicamento build(byte by, byte[] byArray) {
        switch (by) {
            case 1: {
                return ScopeRegistroMedicamento.buildRegistro01(byArray);
            }
            case 2: {
                return ScopeRegistroMedicamento.buildRegistro02(byArray);
            }
            case 3: {
                return ScopeRegistroMedicamento.buildRegistro03(byArray);
            }
        }
        return null;
    }

    public static ScopeRegistroMedicamento build(byte by, String string) {
        switch (by) {
            case 1: {
                return ScopeRegistroMedicamento.buildRegistro01(string);
            }
            case 2: {
                return ScopeRegistroMedicamento.buildRegistro02(string);
            }
            case 3: {
                return ScopeRegistroMedicamento.buildRegistro03(string);
            }
        }
        return null;
    }

    private static ScopeRegistroMedicamento buildRegistro01(String string) {
        ScopeRegistroMedicamento scopeRegistroMedicamento = new ScopeRegistroMedicamento();
        scopeRegistroMedicamento.setCodigoEAN(string.substring(0, 13));
        scopeRegistroMedicamento.setQtdProdutos(Integer.parseInt(string.substring(13, 15)));
        scopeRegistroMedicamento.setPrecoPMC(string.substring(15, 22));
        scopeRegistroMedicamento.setPrecoVenda(string.substring(22, 29));
        scopeRegistroMedicamento.setPrecoFabrica(string.substring(29, 36));
        scopeRegistroMedicamento.setPrecoAquisicao(string.substring(36, 43));
        scopeRegistroMedicamento.setPrecoRepasse(string.substring(43, 50));
        scopeRegistroMedicamento.setReservadoFuturo(string.charAt(50));
        scopeRegistroMedicamento.setMotivoRejeicao(string.substring(51, 53));
        return scopeRegistroMedicamento;
    }

    private static ScopeRegistroMedicamento buildRegistro02(String string) {
        ScopeRegistroMedicamento scopeRegistroMedicamento = new ScopeRegistroMedicamento();
        scopeRegistroMedicamento.setCodigoEAN(string.substring(0, 13));
        scopeRegistroMedicamento.setQtdProdutos(Integer.parseInt(string.substring(13, 15)));
        scopeRegistroMedicamento.setPrecoPMC(string.substring(15, 22));
        scopeRegistroMedicamento.setPrecoVenda(string.substring(22, 29));
        scopeRegistroMedicamento.setPrecoFabrica(string.substring(29, 36));
        scopeRegistroMedicamento.setPrecoAquisicao(string.substring(36, 43));
        scopeRegistroMedicamento.setPrecoRepasse(string.substring(43, 50));
        scopeRegistroMedicamento.setReservadoFuturo(string.charAt(50));
        scopeRegistroMedicamento.setMotivoRejeicao(string.substring(51, 53));
        scopeRegistroMedicamento.setCrm(string.substring(53, 62));
        return scopeRegistroMedicamento;
    }

    private static ScopeRegistroMedicamento buildRegistro03(String string) {
        ScopeRegistroMedicamento scopeRegistroMedicamento = new ScopeRegistroMedicamento();
        scopeRegistroMedicamento.setCodigoEAN(string.substring(0, 13));
        scopeRegistroMedicamento.setQtdProdutos(Integer.parseInt(string.substring(13, 15)));
        scopeRegistroMedicamento.setMotivoRejeicao(string.substring(15, 17));
        scopeRegistroMedicamento.setNumeroConvenio(string.substring(17, 25));
        scopeRegistroMedicamento.setPrecoPMC(string.substring(25, 32));
        scopeRegistroMedicamento.setPrecoVenda(string.substring(32, 39));
        scopeRegistroMedicamento.setPrecoFabrica(string.substring(39, 46));
        scopeRegistroMedicamento.setPrecoAquisicao(string.substring(46, 53));
        scopeRegistroMedicamento.setPrecoRepasse(string.substring(53, 60));
        scopeRegistroMedicamento.setCrm(string.substring(60, 69));
        return scopeRegistroMedicamento;
    }

    private static ScopeRegistroMedicamento buildRegistro01(byte[] byArray) {
        ScopeRegistroMedicamento scopeRegistroMedicamento = new ScopeRegistroMedicamento();
        scopeRegistroMedicamento.setCodigoEAN(ScopeRegistroMedicamento.convert2String(byArray, 0, 13));
        scopeRegistroMedicamento.setQtdProdutos(Integer.parseInt(ScopeRegistroMedicamento.convert2String(byArray, 13, 2)));
        scopeRegistroMedicamento.setPrecoPMC(ScopeRegistroMedicamento.convert2String(byArray, 15, 7));
        scopeRegistroMedicamento.setPrecoVenda(ScopeRegistroMedicamento.convert2String(byArray, 22, 7));
        scopeRegistroMedicamento.setPrecoFabrica(ScopeRegistroMedicamento.convert2String(byArray, 29, 7));
        scopeRegistroMedicamento.setPrecoAquisicao(ScopeRegistroMedicamento.convert2String(byArray, 36, 7));
        scopeRegistroMedicamento.setPrecoRepasse(ScopeRegistroMedicamento.convert2String(byArray, 43, 7));
        scopeRegistroMedicamento.setReservadoFuturo((char)byArray[50]);
        scopeRegistroMedicamento.setMotivoRejeicao(ScopeRegistroMedicamento.convert2String(byArray, 51, 2));
        return scopeRegistroMedicamento;
    }

    private static ScopeRegistroMedicamento buildRegistro02(byte[] byArray) {
        ScopeRegistroMedicamento scopeRegistroMedicamento = new ScopeRegistroMedicamento();
        scopeRegistroMedicamento.setCodigoEAN(ScopeRegistroMedicamento.convert2String(byArray, 0, 13));
        scopeRegistroMedicamento.setQtdProdutos(Integer.parseInt(ScopeRegistroMedicamento.convert2String(byArray, 13, 2)));
        scopeRegistroMedicamento.setPrecoPMC(ScopeRegistroMedicamento.convert2String(byArray, 15, 7));
        scopeRegistroMedicamento.setPrecoVenda(ScopeRegistroMedicamento.convert2String(byArray, 22, 7));
        scopeRegistroMedicamento.setPrecoFabrica(ScopeRegistroMedicamento.convert2String(byArray, 29, 7));
        scopeRegistroMedicamento.setPrecoAquisicao(ScopeRegistroMedicamento.convert2String(byArray, 36, 7));
        scopeRegistroMedicamento.setPrecoRepasse(ScopeRegistroMedicamento.convert2String(byArray, 43, 7));
        scopeRegistroMedicamento.setReservadoFuturo((char)byArray[50]);
        scopeRegistroMedicamento.setMotivoRejeicao(ScopeRegistroMedicamento.convert2String(byArray, 51, 2));
        scopeRegistroMedicamento.setCrm(ScopeRegistroMedicamento.convert2String(byArray, 53, 9));
        return scopeRegistroMedicamento;
    }

    private static ScopeRegistroMedicamento buildRegistro03(byte[] byArray) {
        ScopeRegistroMedicamento scopeRegistroMedicamento = new ScopeRegistroMedicamento();
        scopeRegistroMedicamento.setCodigoEAN(ScopeRegistroMedicamento.convert2String(byArray, 0, 13));
        scopeRegistroMedicamento.setQtdProdutos(Integer.parseInt(ScopeRegistroMedicamento.convert2String(byArray, 13, 2)));
        scopeRegistroMedicamento.setMotivoRejeicao(ScopeRegistroMedicamento.convert2String(byArray, 15, 2));
        scopeRegistroMedicamento.setNumeroConvenio(ScopeRegistroMedicamento.convert2String(byArray, 17, 8));
        scopeRegistroMedicamento.setPrecoPMC(ScopeRegistroMedicamento.convert2String(byArray, 25, 7));
        scopeRegistroMedicamento.setPrecoVenda(ScopeRegistroMedicamento.convert2String(byArray, 32, 7));
        scopeRegistroMedicamento.setPrecoFabrica(ScopeRegistroMedicamento.convert2String(byArray, 39, 7));
        scopeRegistroMedicamento.setPrecoAquisicao(ScopeRegistroMedicamento.convert2String(byArray, 46, 7));
        scopeRegistroMedicamento.setPrecoRepasse(ScopeRegistroMedicamento.convert2String(byArray, 53, 7));
        scopeRegistroMedicamento.setCrm(ScopeRegistroMedicamento.convert2String(byArray, 60, 9));
        return scopeRegistroMedicamento;
    }

    private static String convert2String(byte[] byArray, int n, int n2) {
        int n3;
        for (n3 = n + n2; n3 > n && byArray[n3 - 1] == 0; --n3) {
        }
        return new String(byArray, n, n3 - n);
    }
}

