/*
 * Decompiled with CFR 0.152.
 */
package com.itautec.scope;

import com.itautec.scope.Bandeira;
import com.itautec.scope.Buffer;
import com.itautec.scope.Rede;
import com.itautec.scope.Servico;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Servicos {
    public static final int SERVICO_FORMATO_1 = 1;
    public static final int SERVICO_FORMATO_2 = 2;
    private boolean aceitaDigitacao;
    private int aceitaDigitacaoInt;
    private boolean solicita4UltimosDigitos;
    private int pedeUlt4Digitos;
    private boolean aceitaTaxaServico;
    private int aceitaTxServico;
    private int maxTaxPercent;
    private boolean solicitaSenha;
    private int obtemSenha;
    private boolean solicitaCVV2;
    private int pedeCVV2;
    private List<Atributo> atributos;
    private int posicaoMK;
    private int tamCampoAtributos;
    private int numServicos;
    private byte[] workingKey;
    private String workingKeyDecode = "";

    public Servicos(Buffer buffer, int n, int n2) {
        int n3 = 0;
        byte[] byArray = buffer.bArray;
        this.aceitaDigitacaoInt = byArray[n3];
        this.aceitaDigitacao = byArray[n3++] == 1;
        this.pedeUlt4Digitos = byArray[n3];
        this.solicita4UltimosDigitos = byArray[n3++] == 1;
        this.aceitaTxServico = byArray[n3];
        boolean bl = this.aceitaTaxaServico = byArray[n3++] == 1;
        if (this.requerFiller()) {
            ++n3;
        }
        this.maxTaxPercent = this.getShort(Arrays.copyOfRange(byArray, n3, n3 + 2));
        this.obtemSenha = byArray[n3 += 2];
        this.solicitaSenha = byArray[n3++] == 1;
        this.pedeCVV2 = byArray[n3];
        this.solicitaCVV2 = byArray[n3++] == 1;
        this.posicaoMK = byArray[n3++];
        this.workingKey = Arrays.copyOfRange(byArray, n3, n3 + 16);
        try {
            this.workingKeyDecode = new String(this.workingKey, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        n3 += 17;
        this.numServicos = byArray[n3++];
        if (this.requerFiller()) {
            ++n3;
        }
        this.tamCampoAtributos = this.getShort(Arrays.copyOfRange(byArray, n3, n3 + 2));
        n3 += 2;
        this.atributos = new ArrayList<Atributo>();
        for (int i = 0; i < this.numServicos; ++i) {
            Atributo atributo = new Atributo(n2, byArray, n3);
            this.atributos.add(atributo);
            n3 += atributo.getOffset();
        }
    }

    public int getAceitaTxServico() {
        return this.aceitaTxServico;
    }

    public int getTamCampoAtributos() {
        return this.tamCampoAtributos;
    }

    public int getNumServicos() {
        return this.numServicos;
    }

    public int getPosicaoMK() {
        return this.posicaoMK;
    }

    public int getObtemSenha() {
        return this.obtemSenha;
    }

    public String getWorkingKeyDecode() {
        return this.workingKeyDecode;
    }

    public int getPedeCVV2() {
        return this.pedeCVV2;
    }

    public int getAceitaDigitacaoInt() {
        return this.aceitaDigitacaoInt;
    }

    public int getPedeUlt4Digitos() {
        return this.pedeUlt4Digitos;
    }

    public int getMaxTaxPercent() {
        return this.maxTaxPercent;
    }

    private void parseBufferVersao1(byte[] byArray) {
        int n = 0;
        this.aceitaDigitacao = this.isUm(byArray, n++);
        this.solicita4UltimosDigitos = this.isUm(byArray, n++);
        this.aceitaTaxaServico = this.isUm(byArray, n++);
        if (this.requerFiller()) {
            ++n;
        }
        this.maxTaxPercent = this.getShort(Arrays.copyOfRange(byArray, n, n + 2));
        n += 2;
        this.solicitaSenha = this.isUm(byArray, n++);
        this.solicitaCVV2 = this.isUm(byArray, n++);
        byte by = byArray[n++];
        byte[] byArray2 = Arrays.copyOfRange(byArray, n, n + 16);
        n += 17;
        int n2 = byArray[n++];
        if (this.requerFiller()) {
            ++n;
        }
        int n3 = this.getShort(Arrays.copyOfRange(byArray, n, n + 2));
        n += 2;
        this.atributos = new ArrayList<Atributo>();
        for (int i = 0; i < n2; ++i) {
            Atributo atributo = new Atributo(1, byArray, n);
            this.atributos.add(atributo);
            n += atributo.getOffset();
        }
    }

    private void parseBufferVersao2(byte[] byArray) {
        int n = 0;
        this.aceitaDigitacao = byArray[n++] == 1;
        this.solicita4UltimosDigitos = byArray[n++] == 1;
        boolean bl = this.aceitaTaxaServico = byArray[n++] == 1;
        if (this.requerFiller()) {
            ++n;
        }
        this.maxTaxPercent = this.getShort(Arrays.copyOfRange(byArray, n, n + 2));
        n += 2;
        this.solicitaSenha = byArray[n++] == 1;
        this.solicitaCVV2 = byArray[n++] == 1;
        byte by = byArray[n++];
        byte[] byArray2 = Arrays.copyOfRange(byArray, n, n + 16);
        n += 17;
        int n2 = byArray[n++];
        if (this.requerFiller()) {
            ++n;
        }
        int n3 = this.getShort(Arrays.copyOfRange(byArray, n, n + 2));
        n += 2;
        this.atributos = new ArrayList<Atributo>();
        for (int i = 0; i < n2; ++i) {
            Atributo atributo = new Atributo(2, byArray, n);
            this.atributos.add(atributo);
            n += atributo.getOffset();
        }
    }

    private boolean requerFiller() {
        return true;
    }

    private int getShort(byte[] byArray) {
        int n = byArray[1] & 0xFF;
        n <<= 8;
        return n += byArray[0] & 0xFF;
    }

    private boolean isUm(byte[] byArray, int n) {
        return byArray[n] == 1;
    }

    private long arrayStringToLong(byte[] byArray, int n, int n2) {
        long l = 0L;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i < n2; ++i) {
            if (byArray[i] < 48 || byArray[i] > 57) continue;
            stringBuffer.append((char)byArray[i]);
        }
        l = Long.parseLong(stringBuffer.toString());
        return l;
    }

    public boolean isAceitaDigitacao() {
        return this.aceitaDigitacao;
    }

    public boolean isSolicita4UltimosDigitos() {
        return this.solicita4UltimosDigitos;
    }

    public boolean isAceitaTaxaServico() {
        return this.aceitaTaxaServico;
    }

    public boolean isSolicitaSenha() {
        return this.solicitaSenha;
    }

    public boolean isSolicitaCVV2() {
        return this.solicitaCVV2;
    }

    public List<Atributo> getAtributos() {
        return this.atributos;
    }

    public Atributo getAtributos(int n) {
        return this.atributos.get(n);
    }

    public int getAtributoEmitePromissoriaInt(int n) {
        return this.atributos.get(n).emitePromissoriaInt;
    }

    public int getAtributoCodRede(int n) {
        return this.atributos.get(n).rede.getCodigo();
    }

    public int getAtributoTipoDiaParcela(int n) {
        return this.atributos.get(n).tipoDiaParcela;
    }

    public int getAtributoDiaPredatado(int n) {
        return this.atributos.get(n).diaPredatado;
    }

    public int getAtributoQtdParcela(int n) {
        return this.atributos.get(n).qtdParcela;
    }

    public long getAtributoLimiteSupValor(int n) {
        return this.atributos.get(n).limiteSupValor;
    }

    public long getAtributoLimiteInfValor(int n) {
        return this.atributos.get(n).limiteInfValor;
    }

    public int getAtributoLimiteInfParcelas(int n) {
        return this.atributos.get(n).limiteInfParcelas;
    }

    public int getAtributoLimitePreDatado(int n) {
        return this.atributos.get(n).limitePreDatado;
    }

    public int getAtributoTipoConsultaCheque(int n) {
        return this.atributos.get(n).tipoConsultaCheque;
    }

    public int getAtributoPreAutorizacao(int n) {
        return this.atributos.get(n).PreAutorizacao;
    }

    public int getAtributoTipoDiaPrimParcela(int n) {
        return this.atributos.get(n).tipoDiaPrimParcela;
    }

    public int getAtributoAceitaValorSaqueInt(int n) {
        return this.atributos.get(n).aceitaValorSaqueInt;
    }

    public int getAtributoCodBandeira(int n) {
        return this.atributos.get(n).bandeira.getCodigo();
    }

    public int getAtributoDiaParcela(int n) {
        return this.atributos.get(n).diaParcela;
    }

    public int getAtributoTipoGarantiaPreDatado(int n) {
        return this.atributos.get(n).tipoGarantiaPreDatado;
    }

    public int getAtributoCodServico(int n) {
        return this.atributos.get(n).codServico.getCodigo();
    }

    public int getAtributoRedeInativa(int n) {
        return this.atributos.get(n).redeInativa;
    }

    public int getAtributoTipoDiaPredatado(int n) {
        return this.atributos.get(n).tipoDiaPredatado;
    }

    public int getAtributoMoedaServicoCredito(int n) {
        return this.atributos.get(n).moedaServicoCredito;
    }

    public int getAtributoLimiteSupParcelas(int n) {
        return this.atributos.get(n).limiteSupParcelas;
    }

    public int getAtributoSolicitaCodPlPagtoInt(int n) {
        return this.atributos.get(n).solicitaCodPlPagtoInt;
    }

    public int getAtributoTipoQtdParcela(int n) {
        return this.atributos.get(n).tipoQtdParcela;
    }

    public int getAtributoDiaPrimParcela(int n) {
        return this.atributos.get(n).diaPrimParcela;
    }

    public int getAtributoLimite1aParcela(int n) {
        return this.atributos.get(n).limite1aParcela;
    }

    private void appendIfNotZero(StringBuffer stringBuffer, String string, int n) {
        if (n > 0) {
            stringBuffer.append("{").append(string).append("=").append(n).append("}");
        }
    }

    private void appendIfTrue(StringBuffer stringBuffer, String string, boolean bl) {
        if (bl) {
            stringBuffer.append("{").append(string).append("}");
        }
    }

    private int unsignedByteToInt(byte by) {
        return by & 0xFF;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendIfTrue(stringBuffer, "Aceita digitacao", this.aceitaDigitacao);
        this.appendIfTrue(stringBuffer, "Solicita 4 ultimos digitos", this.solicita4UltimosDigitos);
        this.appendIfTrue(stringBuffer, "Aceita taxa de servico", this.aceitaTaxaServico);
        this.appendIfNotZero(stringBuffer, "Maxima taxa percentual", this.maxTaxPercent);
        this.appendIfTrue(stringBuffer, "Solicita senha", this.solicitaSenha);
        this.appendIfTrue(stringBuffer, "Solicita codigo de seguranca", this.solicitaCVV2);
        stringBuffer.append("------------------ SERVICOS ------------------");
        for (Atributo atributo : this.atributos) {
            stringBuffer.append(">>>>>>>>>>>>>>");
            stringBuffer.append(atributo.toString());
        }
        return stringBuffer.toString();
    }

    public class Atributo {
        private Bandeira bandeira;
        private Servico codServico;
        private boolean redeAtiva;
        private int redeInativa;
        private Rede rede;
        private boolean isPreAutorizacao;
        private int PreAutorizacao;
        private boolean emitePromissoria;
        private int emitePromissoriaInt;
        private int tipoDiaPredatado;
        private int tipoQtdParcela;
        private int tipoDiaParcela;
        private int tipoDiaPrimParcela;
        private int moedaServicoCredito;
        private int tipoConsultaCheque;
        private int limiteInfParcelas;
        private int limiteSupParcelas;
        private int limitePreDatado;
        private int diaPredatado;
        private int qtdParcela;
        private int diaParcela;
        private int diaPrimParcela;
        private long limiteInfValor;
        private long limiteSupValor;
        private boolean solicitaCodPlPagto;
        private int solicitaCodPlPagtoInt;
        private int tipoGarantiaPreDatado;
        private boolean aceitaValorSaque;
        private int aceitaValorSaqueInt;
        private int limite1aParcela;
        private int offset;

        public Atributo(int n, byte[] byArray, int n2) {
            int n3 = n2;
            if (n == 1) {
                this.bandeira = Bandeira.getBandeira(Servicos.this.unsignedByteToInt(byArray[n2++]));
            } else if (n == 2) {
                this.bandeira = Bandeira.getBandeira(Servicos.this.getShort(Arrays.copyOfRange(byArray, n2, n2 + 2)));
            }
            n2 += 2;
            this.codServico = Servico.getServico(Servicos.this.unsignedByteToInt(byArray[n2++]));
            this.redeInativa = byArray[n2];
            this.redeAtiva = !Servicos.this.isUm(byArray, n2++);
            this.rede = Rede.getRede(Servicos.this.unsignedByteToInt(byArray[n2++]));
            this.PreAutorizacao = byArray[n2];
            this.isPreAutorizacao = Servicos.this.isUm(byArray, n2++);
            this.emitePromissoriaInt = byArray[n2];
            this.emitePromissoria = Servicos.this.isUm(byArray, n2++);
            this.tipoDiaPredatado = Servicos.this.unsignedByteToInt(byArray[n2++]);
            this.tipoQtdParcela = Servicos.this.unsignedByteToInt(byArray[n2++]);
            this.tipoDiaParcela = Servicos.this.unsignedByteToInt(byArray[n2++]);
            this.tipoDiaPrimParcela = Servicos.this.unsignedByteToInt(byArray[n2++]);
            this.moedaServicoCredito = Servicos.this.unsignedByteToInt(byArray[n2++]);
            this.tipoConsultaCheque = Servicos.this.unsignedByteToInt(byArray[n2++]);
            this.limiteInfParcelas = Servicos.this.unsignedByteToInt(byArray[n2++]);
            this.limiteSupParcelas = Servicos.this.unsignedByteToInt(byArray[n2++]);
            this.limitePreDatado = Servicos.this.unsignedByteToInt(byArray[n2++]);
            this.diaPredatado = Servicos.this.unsignedByteToInt(byArray[n2++]);
            this.qtdParcela = Servicos.this.unsignedByteToInt(byArray[n2++]);
            this.diaParcela = Servicos.this.unsignedByteToInt(byArray[n2++]);
            this.diaPrimParcela = Servicos.this.unsignedByteToInt(byArray[n2++]);
            this.limiteInfValor = Servicos.this.arrayStringToLong(byArray, n2, n2 + 11);
            this.limiteSupValor = Servicos.this.arrayStringToLong(byArray, n2 += 12, n2 + 11);
            this.solicitaCodPlPagtoInt = byArray[n2 += 12];
            this.solicitaCodPlPagto = Servicos.this.isUm(byArray, n2++);
            this.tipoGarantiaPreDatado = Servicos.this.unsignedByteToInt(byArray[n2++]);
            this.aceitaValorSaqueInt = byArray[n2];
            this.aceitaValorSaque = Servicos.this.isUm(byArray, n2++);
            this.limite1aParcela = Servicos.this.getShort(Arrays.copyOfRange(byArray, n2, n2 + 2));
            n2 += 2;
            this.offset = ++n2 - n3;
        }

        public int getOffset() {
            return this.offset;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append((Object)this.rede).append(this.redeAtiva ? "-on " : "-off").append("|");
            stringBuffer.append((Object)this.bandeira).append("|").append((Object)this.codServico).append("\n");
            Servicos.this.appendIfTrue(stringBuffer, "Pre-autorizacao", this.isPreAutorizacao);
            Servicos.this.appendIfTrue(stringBuffer, "Emite promissoria", this.emitePromissoria);
            Servicos.this.appendIfNotZero(stringBuffer, "Tipo dia pre-datado", this.tipoDiaPredatado);
            Servicos.this.appendIfNotZero(stringBuffer, "Tipo dia de parcela", this.tipoDiaParcela);
            Servicos.this.appendIfNotZero(stringBuffer, "Tipo dia primeira parcela", this.tipoDiaPrimParcela);
            Servicos.this.appendIfNotZero(stringBuffer, "Moeda de servico de credito", this.moedaServicoCredito);
            Servicos.this.appendIfNotZero(stringBuffer, "Consulta cheque", this.tipoConsultaCheque);
            if (this.limiteInfParcelas > 0 || this.limiteSupParcelas > 0) {
                stringBuffer.append("{Limites de parcelas=").append(this.limiteInfParcelas).append("-").append(this.limiteSupParcelas).append("}");
            }
            Servicos.this.appendIfNotZero(stringBuffer, "Limite de pre-datado", this.limitePreDatado);
            Servicos.this.appendIfNotZero(stringBuffer, "Dia pre-datado", this.diaPredatado);
            if (this.qtdParcela > 0) {
                stringBuffer.append("{Quantidade de parcela=").append(this.qtdParcela).append("-");
                stringBuffer.append(this.tipoQtdParcela == 1 ? "mandat\u00c3\u00b3rio" : "sugerido").append("}");
            }
            Servicos.this.appendIfNotZero(stringBuffer, "Dia parcela", this.diaParcela);
            Servicos.this.appendIfNotZero(stringBuffer, "Dia primeira parcela", this.diaPrimParcela);
            if (this.limiteInfValor > 0L || this.limiteSupValor > 0L) {
                stringBuffer.append("{Limites de valor=").append(this.limiteInfValor).append("-").append(this.limiteSupValor).append("}");
            }
            Servicos.this.appendIfTrue(stringBuffer, "Solicita plano de pagamento", this.solicitaCodPlPagto);
            Servicos.this.appendIfNotZero(stringBuffer, "Tipo garantia pre-datado", this.tipoGarantiaPreDatado);
            Servicos.this.appendIfTrue(stringBuffer, "Aceita valor de saque", this.aceitaValorSaque);
            Servicos.this.appendIfNotZero(stringBuffer, "Limite da primeira parcela", this.limite1aParcela);
            return stringBuffer.toString();
        }
    }
}

