/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.components;

import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.util.Shadow;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.H4;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;

public class Card
extends VerticalContainer {
    private static final long serialVersionUID = 1L;
    private final VerticalContainer headerBox = new VerticalContainer(new Component[0]);
    private final VerticalContainer contentBox = new VerticalContainer(new Component[0]);
    private final HorizontalContainer footerBox = new HorizontalContainer(new Component[0]);

    public Card() {
        super(new Component[0]);
        this.setPadding(false);
        this.headerBox.setAlignItems(FlexComponent.Alignment.START);
        this.headerBox.setWidthFull();
        this.headerBox.setPadding(false);
        this.contentBox.setAlignItems(FlexComponent.Alignment.START);
        this.contentBox.setId("contentBox");
        this.footerBox.setMaxHeight("40px");
        this.footerBox.setAlignItems(FlexComponent.Alignment.CENTER);
        this.footerBox.setPadding(false);
        this.setDefaultParam();
        this.add(new Component[]{this.headerBox, this.contentBox});
    }

    public void removeHeader() {
        this.remove(new Component[]{this.headerBox});
    }

    private void setDefaultParam() {
        this.setWidthFull();
        this.setHeightFull();
        this.setPadding(false);
        this.setJustifyContentMode(FlexComponent.JustifyContentMode.BETWEEN);
        UIUtils.setShadow((Shadow)Shadow.S, (Component[])new Component[]{this});
    }

    public Card setHeader(String header) {
        H4 h4 = new H4(header.toUpperCase());
        h4.setWidthFull();
        this.headerBox.removeAll();
        this.headerBox.add(new Component[]{h4});
        return this;
    }

    public Card addContent(Component component) {
        this.contentBox.add(new Component[]{component});
        return this;
    }

    public Card setContent(Component ... components) {
        for (Component component : components) {
            if (component == null) continue;
            this.contentBox.add(new Component[]{component});
        }
        return this;
    }

    public Card setFooter(Component ... footers) {
        if (footers == null || footers.length <= 0) {
            return this;
        }
        for (Component footer : footers) {
            if (footer == null) continue;
            this.footerBox.add(new Component[]{footer});
        }
        this.add(new Component[]{this.footerBox});
        return this;
    }

    public VerticalLayout getHeaderBox() {
        return this.headerBox;
    }

    public VerticalLayout getContentBox() {
        return this.contentBox;
    }

    public HorizontalLayout getFooterBox() {
        return this.footerBox;
    }
}

