/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.components;

import br.com.system.app.components.InformationDialog;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.shared.service.TelefoneService;
import br.com.system.app.features.whatsapp.util.WhatsAppUtil;
import br.com.system.commons.StringUtil;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;

public class TelefoneField
extends CustomField<String> {
    private static final long serialVersionUID = 1L;
    private final TextField field = new TextField();
    private final Div anchor = new Div();
    private final Image anchorTel = new Image("images/phone20.png", "3CX");
    private TelefoneService telefoneService;
    private EstruturaUsuario eu;
    private Long atividadeId;
    private String cpfCnpj;
    private Boolean ignorarNaoPerturbe;
    private Boolean bloqueioNaoperturbe;
    private String msg;

    public TelefoneField(Boolean bloqueioNaoperturbe, Boolean ignorarNaoPerturbe, EstruturaUsuario eu, TelefoneService telefoneService, String label, String value, Boolean readOnly, String msg, String cpfCnpj, Long atividadeId) {
        this.create(bloqueioNaoperturbe, ignorarNaoPerturbe, eu, telefoneService, label, value, msg, readOnly.booleanValue(), cpfCnpj, atividadeId);
    }

    public String getValue() {
        return this.field.getValue();
    }

    public TextField getField() {
        return this.field;
    }

    private void create(Boolean bloqueioNaoperturbe, Boolean ignorarNaoPerturbe, EstruturaUsuario eu, TelefoneService telefoneService, String label, String value, String msg, boolean readOnly, String cpfCnpj, Long atividadeId) {
        this.msg = msg == null ? "" : msg;
        this.bloqueioNaoperturbe = bloqueioNaoperturbe;
        this.ignorarNaoPerturbe = ignorarNaoPerturbe;
        this.telefoneService = telefoneService;
        this.eu = eu;
        this.atividadeId = atividadeId;
        this.cpfCnpj = cpfCnpj;
        HorizontalContainer h = new HorizontalContainer(new Component[0]);
        h.setNoWrap();
        this.field.setReadOnly(readOnly);
        this.setLabel(label);
        this.setValue(value);
        this.setReadOnly(readOnly);
        this.anchor.setWidth("20px");
        this.anchor.setHeight("20px");
        this.anchor.getStyle().set("vertical-align", "middle");
        this.anchorTel.setWidth("20px");
        this.anchorTel.setHeight("20px");
        h.add(new Component[]{this.field, this.anchor, this.anchorTel});
        this.add(new Component[]{h});
    }

    public void setValue(String value) {
        if (value == null || value.isEmpty()) {
            this.anchorTel.setVisible(false);
            return;
        }
        String telefone = StringUtil.numbersOnly((String)value);
        this.field.setValue(telefone);
        if (this.field.getValue().length() > 11 && this.field.getValue().startsWith("55")) {
            this.field.setValue(this.field.getValue().substring(2));
        }
        if (this.telefoneService != null) {
            this.mostraWhats();
        }
    }

    public void mostraWhats() {
        this.mostraWhats(Boolean.valueOf(this.telefoneService.temWhats(this.field.getValue())));
    }

    private void mostraWhats(Boolean b) {
        try {
            if (!this.ignorarNaoPerturbe.booleanValue() && (this.telefoneService.isNaoPerturbe(this.field.getValue()) || this.bloqueioNaoperturbe.booleanValue())) {
                this.anchorTel.setVisible(false);
                this.anchor.setVisible(false);
                return;
            }
            if (this.telefoneService != null && this.field.getValue().length() >= 10 && this.field.getValue().length() <= 11) {
                if (b.booleanValue()) {
                    this.anchor.getElement().setProperty("innerHTML", "<span>" + WhatsAppUtil.getLink((String)this.field.getValue(), (String)this.msg) + "</span>");
                } else {
                    this.anchor.getElement().setProperty("innerHTML", "<span><img src='images/whats-cinza20.png'></span>");
                }
                this.anchorTel.setVisible(this.eu.getUsuario().getRamal() != null);
                this.anchorTel.addClickListener((ComponentEventListener & Serializable)e -> {
                    if (this.telefoneService.isNaoPerturbe(this.field.getValue())) {
                        InformationDialog.show((String)"N\u00e3o Perturbe", (String)"Este n\u00famero est\u00e1 na base de N\u00c3O PERTURBE, imposs\u00edvel continuar com a liga\u00e7\u00e3o.");
                        return;
                    }
                    if (this.eu.getUsuario().getRamal() == null) {
                        UIUtils.showNotification((String)"Ramal 3CX n\u00e3o definido no cadastro do Usu\u00e1rio");
                        return;
                    }
                    UI.getCurrent().getPage().executeJs("window.open('https://neocrm.my3cx.com.br/webclient/#/people?phone=" + this.field.getValue() + "','3cxWindow','width=500,height=500')", new Serializable[0]);
                    if (this.atividadeId != null || this.cpfCnpj != null) {
                        this.telefoneService.gravarChamada3cx(this.eu, this.field.getValue(), this.cpfCnpj, this.atividadeId);
                    }
                });
                this.anchor.setEnabled(b.booleanValue());
                return;
            }
            this.anchorTel.setVisible(false);
            this.anchor.setEnabled(Boolean.FALSE.booleanValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setLabel(String label) {
        this.field.setLabel(label);
    }

    protected String generateModelValue() {
        return this.field.getValue();
    }

    protected void setPresentationValue(String t) {
        if (t != null) {
            this.field.setValue(t);
        }
    }

    public void setWidth(String width) {
        this.field.setWidth(width);
    }
}

