/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.components.containers;

import br.com.system.app.features.layout.Color;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.util.Shadow;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;

public class VerticalContainer
extends VerticalLayout {
    private static final long serialVersionUID = 1L;
    private Object dataObject;

    public Object getDataObject() {
        return this.dataObject;
    }

    public void setDataObject(Object dataObject) {
        this.dataObject = dataObject;
    }

    public void setBackgroundColor(Color color) {
        this.getStyle().set("background-color", color.getValue());
    }

    public VerticalContainer(Component ... components) {
        super(components);
        this.setDefaults();
    }

    public VerticalContainer setFull() {
        this.setHeightFull();
        this.setWidthFull();
        return this;
    }

    private void setDefaults() {
        this.addClassNames(new String[]{"text-xs", "p-s"});
        this.setAlignItems(FlexComponent.Alignment.START);
        this.setJustifyContentMode(FlexComponent.JustifyContentMode.START);
        this.setSpacing(false);
        this.setMargin(false);
    }

    public void setTransparent() {
        this.getElement().getStyle().set("background", "transparent");
    }

    public VerticalContainer setVerticalAlign(FlexComponent.Alignment alignment) {
        this.setAlignItems(alignment);
        return this;
    }

    public VerticalContainer setHorizontalAlign(FlexComponent.JustifyContentMode alignment) {
        if (alignment == null) {
            this.setJustifyContentMode(FlexComponent.JustifyContentMode.BETWEEN);
        } else {
            this.setJustifyContentMode(alignment);
        }
        return this;
    }

    public VerticalContainer setHorizontalAlign(FlexComponent.Alignment align) {
        this.setAlignItems(align);
        return this;
    }

    public VerticalContainer setShadow(Shadow shadow) {
        UIUtils.setShadow((Shadow)shadow, (Component[])new Component[]{this});
        return this;
    }

    public VerticalContainer setPaddingOn() {
        this.setPadding(true);
        return this;
    }

    public VerticalContainer setPaddingOff() {
        this.setPadding(false);
        return this;
    }

    public VerticalContainer setSpacingOn() {
        this.setSpacing(true);
        return this;
    }

    public VerticalContainer setSpacingOff() {
        this.setSpacing(false);
        return this;
    }
}

