/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.components.grid;

import br.com.system.app.components.grid.model.GridNameEnum;
import br.com.system.app.components.grid.model.GridOrder;
import br.com.system.app.components.grid.repository.GridOrderRepository;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.shared.exception.BusinessException;
import com.vaadin.flow.component.grid.Grid;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GridOrderService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private GridOrderRepository gor;

    public void delete(EstruturaUsuario eu, Grid<?> grid, GridNameEnum gridName, PedidoTipoEnum tipo) {
        this.gor.deleteByEstruturaUsuarioAndGridNameAndPedidoTipo(eu, gridName, tipo);
    }

    public String[] getColuns(EstruturaUsuario eu, Grid<?> grid, GridNameEnum gridName, PedidoTipoEnum tipo) {
        GridOrder g = this.gor.findByEstruturaUsuarioAndGridNameAndPedidoTipo(eu, gridName, tipo);
        if (g == null) {
            return null;
        }
        return g.getListaColunas().split(",");
    }

    public GridOrder save(EstruturaUsuario eu, GridNameEnum gridName, List<String> colunas, PedidoTipoEnum tipo) {
        if (tipo == null || eu == null || gridName == null || colunas.size() <= 0) {
            return null;
        }
        GridOrder g = this.gor.findByEstruturaUsuarioAndGridNameAndPedidoTipo(eu, gridName, tipo);
        if (g == null) {
            g = new GridOrder();
            g.setGridName(gridName);
            g.setPedidoTipo(tipo);
            g.setEstruturaUsuario(eu);
        }
        g.setListaColunas(StringUtils.join(colunas, (String)","));
        return this.save(g);
    }

    public GridOrder save(GridOrder go) {
        if (go.getEstruturaUsuario() == null) {
            throw new BusinessException("EU n\u00e3o informado");
        }
        if (go.getGridName() == null) {
            throw new BusinessException("Grid name nao informado");
        }
        if (go.getListaColunas() == null || go.getListaColunas().isEmpty()) {
            throw new BusinessException("Lista de coluans nao informadas");
        }
        return (GridOrder)this.gor.save((Object)go);
    }
}

