/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.analisefatura;

import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.InformationDialog;
import br.com.system.app.components.ListField;
import br.com.system.app.components.ListFieldTypeEnum;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.analisefatura.AnaliseFaturaAtividadeView;
import br.com.system.app.features.analisefatura.AnaliseFaturaItensView;
import br.com.system.app.features.analisefatura.model.AnaliseFatura;
import br.com.system.app.features.analisefatura.model.AnaliseFaturaDTO;
import br.com.system.app.features.analisefatura.model.StatusAnalise;
import br.com.system.app.features.analisefatura.service.AnaliseFaturaService;
import br.com.system.app.features.layout.FlexBoxLayout;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.util.TempFileMultiBuffer;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.FileUtil;
import br.com.system.commons.HashUtil;
import br.com.system.commons.SleepUtil;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.server.AbstractStreamResource;
import elemental.json.Json;
import elemental.json.JsonValue;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;

@Component
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class AnaliseFaturaFormView
extends VerticalContainer
implements SecurityContext,
Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private AnaliseFaturaService service;
    @Autowired
    private AnaliseFaturaAtividadeView analiseFaturaAtividadeView;
    private String nomeArquivo;
    private GridCrud<AnaliseFaturaDTO> crud;
    private TempFileMultiBuffer mBuffer;
    private ListField listCnpj;
    private NumberField txtFaturaId;
    private Pedido pedido;

    public AnaliseFaturaFormView() {
        super(new com.vaadin.flow.component.Component[0]);
    }

    public Pedido getPedido() {
        return this.pedido;
    }

    public void setPedido(Pedido pedido) {
        this.pedido = pedido;
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public VerticalContainer create() {
        VerticalContainer lay = new VerticalContainer(new com.vaadin.flow.component.Component[0]);
        lay.removeAll();
        lay.add(new com.vaadin.flow.component.Component[]{UIUtils.createSmallSpan((String)"* Devido a problemas no PDF da CLARO, sugerimos importar o arquivo TXT")});
        HorizontalContainer ch = new HorizontalContainer(new com.vaadin.flow.component.Component[0]);
        ch.add(new com.vaadin.flow.component.Component[]{this.createUpload()});
        Button btnPesquisar = UIUtils.createSmallButton((String)"Pesquisar");
        btnPesquisar.addClickListener((ComponentEventListener & Serializable)e -> this.crud.refreshGrid());
        this.txtFaturaId = new NumberField("Id Fatura");
        this.listCnpj = new ListField(ListFieldTypeEnum.CPF_CNPJ, "CPF-CNPJ");
        if (this.pedido != null) {
            this.listCnpj.setValue(this.pedido.getCliente().getCpfCnpj());
        } else {
            ch.add(new com.vaadin.flow.component.Component[]{this.txtFaturaId, new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.listCnpj, btnPesquisar})});
        }
        if (this.isMaster()) {
            ch.add(new com.vaadin.flow.component.Component[]{this.getGreatThen32()});
        }
        lay.add(new com.vaadin.flow.component.Component[]{ch, this.createCrud()});
        lay.setHeightFull();
        lay.setWidthFull();
        return lay;
    }

    private com.vaadin.flow.component.Component createCrud() {
        this.crud = new GridCrud(AnaliseFaturaDTO.class);
        this.crud.setHeightFull();
        this.crud.setWidthFull();
        this.crud.getCrudLayout().addToolbarComponent((com.vaadin.flow.component.Component)this.getOptions());
        this.crud.getGrid().setColumns(new String[0]);
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)(p.getNomeCliente() == null ? "" : p.getNomeCliente())))).setHeader("Nome Cliente").setFlexGrow(0).setWidth("250px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getNomeArquivo()))).setHeader("Arquivo").setFlexGrow(0).setWidth("150px");
        this.crud.getGrid().addColumn("id").setHeader("#").setFlexGrow(0).setWidth("120px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getOperadora() == null ? "" : p.getOperadora().name())).setHeader("Operadora").setFlexGrow(0).setWidth("180px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getStatusAnalise().name())).setHeader("Status").setFlexGrow(0).setWidth("180px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> this.botaoDownload(p.getHashArquivoOriginal(), false, p.getNomeArquivo(), true))).setFlexGrow(0).setHeader("Original").setWidth("160px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> this.botaoDownload(p.getHashArquivoAnalisado(), true, p.getNomeArquivo(), p.getStatusAnalise().equals((Object)StatusAnalise.FINALIZADA)))).setFlexGrow(0).setHeader("Analisado").setWidth("160px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getCpfCnpj() == null ? "" : p.getCpfCnpj())).setHeader("CPF-CNPJ").setFlexGrow(0).setWidth("180px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getNomeUsuario()))).setHeader("Usu\u00e1rio Importa\u00e7\u00e3o").setFlexGrow(0).setWidth("200px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataHoraImportacao().format(FormatDate.DATETIME_BR.toDTF()))).setHeader("Importa\u00e7\u00e3o").setFlexGrow(0).setWidth("180px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataVencimento() == null ? "" : p.getDataVencimento().format(FormatDate.DATE_BR.toDTF()))).setHeader("Vencimento").setFlexGrow(0).setWidth("180px");
        this.crud.getGrid().addColumn("valorTotal").setHeader("Valor").setFlexGrow(0).setWidth("150px");
        this.crud.getGrid().addColumn("mesAno").setHeader("M\u00eas/Ano").setFlexGrow(0).setWidth("150px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)(p.getObservacao() == null ? "" : p.getObservacao())))).setHeader("Observa\u00e7\u00e3o").setFlexGrow(0).setWidth("150px");
        this.crud.getGrid().setColumnReorderingAllowed(true);
        this.crud.getCrudFormFactory().setVisibleProperties(new String[0]);
        this.crud.getAddButton().setVisible(false);
        this.crud.getUpdateButton().setVisible(false);
        this.crud.getDeleteButton().setVisible(this.hasPermission("ANALISE_FATURA_DELETE"));
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        return this.crud;
    }

    private FlexBoxLayout getOptions() {
        Button bRefresh = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.REFRESH, (String)"Reprocessar fatura");
        bRefresh.setVisible(this.isMaster());
        bRefresh.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.crud.getGrid().getSelectedItems().size() <= 0) {
                UIUtils.showNotification((String)"Selecione uma fatura");
                return;
            }
            ConfirmationDialog cd = new ConfirmationDialog("Reprocessar", "Confirma Reprocessamento?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                if (this.crud.getGrid().getSelectedItems().size() <= 0) {
                    UIUtils.showNotification((String)"Selecione uma fatura");
                    return;
                }
                AnaliseFatura af = this.service.getById(((AnaliseFaturaDTO)this.crud.getGrid().getSelectedItems().iterator().next()).getId());
                this.service.reprocessar(af);
                this.crud.refreshGrid();
                UIUtils.showNotification((String)"Reprocessamento solicitado, aguarde conclusao");
                cd.close();
            });
        });
        Button bItens = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.BULLETS, (String)"Visualizar itens da fatura(Linhas)");
        bItens.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.crud.getGrid().getSelectedItems().size() <= 0) {
                UIUtils.showNotification((String)"Selecione uma fatura");
                return;
            }
            AnaliseFatura af = this.service.getById(((AnaliseFaturaDTO)this.crud.getGrid().getSelectedItems().iterator().next()).getId());
            AnaliseFaturaItensView itemView = new AnaliseFaturaItensView(af, this.service);
            itemView.open();
        });
        Button bProposta = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PENCIL, (String)"Criar proposta com base na fatura");
        bProposta.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.crud.getGrid().getSelectedItems().size() <= 0) {
                UIUtils.showNotification((String)"Selecione uma fatura");
                return;
            }
            if (!((AnaliseFaturaDTO)this.crud.getGrid().getSelectedItems().iterator().next()).getStatusAnalise().equals((Object)StatusAnalise.FINALIZADA)) {
                UIUtils.showNotification((String)"Fatura n\u00e3o esta processada");
                return;
            }
            AnaliseFatura af = this.service.getById(((AnaliseFaturaDTO)this.crud.getGrid().getSelectedItems().iterator().next()).getId());
            if (this.pedido != null) {
                af.setAtividadeId(this.pedido.getId());
            }
            this.analiseFaturaAtividadeView.create(af, this.getEu());
            this.analiseFaturaAtividadeView.open();
        });
        FlexBoxLayout container = new FlexBoxLayout(FlexLayout.FlexDirection.ROW, new com.vaadin.flow.component.Component[0]);
        container.setFlexWrap(FlexLayout.FlexWrap.WRAP);
        if (this.pedido == null) {
            container.add(new com.vaadin.flow.component.Component[]{bRefresh, bItens, bProposta});
        } else {
            container.add(new com.vaadin.flow.component.Component[]{bItens, bProposta});
        }
        return container;
    }

    private com.vaadin.flow.component.Component createUpload() {
        this.mBuffer = new TempFileMultiBuffer();
        Upload upload = new Upload((Receiver)this.mBuffer);
        upload.setMaxFiles(1);
        upload.setAcceptedFileTypes(new String[]{".pdf", ".txt"});
        upload.setMaxFileSize(0x2000000);
        upload.addFinishedListener((ComponentEventListener & Serializable)e -> {
            this.nomeArquivo = e.getFileName();
            UIUtils.showNotification((String)"Arquivo carregado, clique em processar");
        });
        upload.addFileRejectedListener((ComponentEventListener & Serializable)event -> {
            if (event.getErrorMessage().contains("Too Many Files")) {
                UIUtils.showNotification((String)"Importe apenas 1 arquivo por vez.");
            } else {
                UIUtils.showNotification((String)"Apenas pdf, no maximo 32MB. Faturas maiores acione o suporte.");
            }
        });
        Button processar = UIUtils.createSmallButton((String)"Processar", (VaadinIcon)VaadinIcon.COGS, (String)"Iniciar processamento da Fatura");
        processar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.nomeArquivo == null || this.nomeArquivo.isEmpty()) {
                UIUtils.showNotification((String)"Selecione o arquivo.");
            } else {
                try {
                    this.upload(this.nomeArquivo, this.mBuffer);
                    upload.getElement().setPropertyJson("files", (JsonValue)Json.createArray());
                    this.mBuffer.clear();
                }
                catch (Exception ex) {
                    UIUtils.showNotification((String)("Erro: " + ex.getMessage()));
                }
            }
        });
        return new VerticalContainer(new com.vaadin.flow.component.Component[]{upload, processar});
    }

    private HorizontalContainer getGreatThen32() {
        HorizontalContainer h = new HorizontalContainer(new com.vaadin.flow.component.Component[0]);
        TextField link = new TextField("NOME ARQUIVO GOOGLE STORAGE");
        Button b = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.CHECK, (String)"Processar fatura");
        b.addClickListener((ComponentEventListener & Serializable)e -> {
            InputStream is = null;
            try {
                is = new URL(link.getValue()).openStream();
                String extensao = FileUtil.getExtension((String)link.getValue().trim());
                this.upload(HashUtil.getUUI() + extensao, is);
            }
            catch (Exception ex) {
                UIUtils.showNotification((String)ex.getMessage());
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        });
        h.add(new com.vaadin.flow.component.Component[]{link, b});
        return h;
    }

    private void upload(String nomeArquivo, TempFileMultiBuffer buffer) {
        InputStream is = buffer.getInputStream((String)buffer.getFiles().iterator().next());
        this.upload(nomeArquivo, is);
    }

    private void upload(String nomeArquivo, InputStream is) {
        AnaliseFatura af = this.service.upload(this.getEu(), is, nomeArquivo);
        SleepUtil.inSeconds((Integer)3);
        this.crud.refreshGrid();
        StringBuilder dadosFatura = new StringBuilder();
        if (af.getObservacao() != null && !af.getObservacao().isEmpty()) {
            dadosFatura.append("Aten\u00e7\u00e3o: ").append(af.getObservacao()).append("<BR>");
        }
        dadosFatura.append("CODIGO: #").append(af.getId()).append("<BR>");
        dadosFatura.append("OPERADORA: ").append(af.getOperadora().name()).append("<BR>");
        dadosFatura.append("CPF-CNPJ: ").append(af.getCpfCnpj()).append("<BR>");
        dadosFatura.append("CLIENTE: ").append(af.getNomeCliente()).append("<BR>");
        dadosFatura.append("CONTA: ").append(af.getCodigoConta()).append("<BR>");
        dadosFatura.append("MES-ANO: ").append(af.getMesAno()).append("<BR>");
        dadosFatura.append("VENCIMENTO: ").append(af.getDataVencimento()).append("<BR>");
        dadosFatura.append("VALOR: R$ ").append(af.getValorTotal()).append("<BR>");
        InformationDialog.show((String)"Importa\u00e7\u00e3o de Fatura", (String)dadosFatura.toString());
        dadosFatura = null;
    }

    private com.vaadin.flow.component.Component botaoDownload(String hash, boolean analisado, String fileName, boolean visible) {
        Button button = new Button("Download", (ComponentEventListener & Serializable)event -> {
            Button b = UIUtils.createSmallButton((String)"Fechar");
            Anchor anchor = this.getLink(hash, analisado, fileName);
            VerticalContainer v = new VerticalContainer(new com.vaadin.flow.component.Component[0]);
            v.setWidthFull();
            v.setJustifyContentMode(FlexComponent.JustifyContentMode.CENTER);
            v.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Arquivo Gerado com sucesso"), anchor, b});
            Dialog d = new Dialog();
            b.addClickListener((ComponentEventListener & Serializable)e -> d.close());
            d.add(new com.vaadin.flow.component.Component[]{v});
            d.open();
        });
        button.setVisible(visible);
        return button;
    }

    private Anchor getLink(String hash, boolean analisado, String filename) {
        String extFilename = FileUtil.getExtension((String)filename, (boolean)false);
        if (analisado) {
            filename = filename.replace(extFilename, ".xlsx");
        }
        Anchor anchor = new Anchor((AbstractStreamResource)StorageUtil.getStreamResource((String)hash, (String)filename), filename);
        anchor.getElement().setAttribute("download", true);
        anchor.setTarget("_blank");
        anchor.setText(filename);
        anchor.setVisible(true);
        return anchor;
    }
}

