/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.broadcast.service;

import br.com.system.app.features.whatsapp.model.WhatsAppAtendimento;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.slf4j.LoggerFactory;

public class BroadcasterWhats
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Executor executor = Executors.newSingleThreadExecutor();
    private static final CopyOnWriteArrayList<Consumer<WhatsAppAtendimento>> listeners = new CopyOnWriteArrayList();

    public static Registration register(Consumer<WhatsAppAtendimento> listener) {
        listeners.add(listener);
        return (Registration & Serializable)() -> listeners.remove(listener);
    }

    public static void broadcast(WhatsAppAtendimento atendimento) {
        for (Consumer listener : listeners) {
            executor.execute(() -> {
                try {
                    listener.accept(atendimento);
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(BroadcasterWhats.class).error(e.getMessage());
                }
            });
        }
    }
}

