/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cliente.service;

import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteAnexo;
import br.com.system.app.features.cliente.repository.ClienteAnexoRepository;
import br.com.system.app.features.cliente.service.ClienteLogService;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.util.TempFileMultiBuffer;
import br.com.system.commons.FileUtil;
import br.com.system.commons.HashUtil;
import br.com.system.commons.StringUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClienteAnexoService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ClienteAnexoRepository anexoRepository;
    @Autowired
    private ClienteLogService clienteLogService;

    public void save(Cliente cliente, EstruturaUsuario euContext, TempFileMultiBuffer buffer) {
        for (String file : buffer.getFiles()) {
            String hash = "";
            InputStream is = null;
            try {
                is = buffer.getInputStream(file);
                String extensao = FileUtil.getExtension((String)buffer.getFileData(file).getFileName());
                hash = HashUtil.getUUI();
                StorageUtil.uploadObjectInputStream((String)(hash + extensao), (InputStream)is);
                ClienteAnexo ca = new ClienteAnexo();
                ca.setHashArquivo(hash);
                ca.setEstruturaUsuario(euContext);
                ca.setDataHora(LocalDateTime.now());
                ca.setNomeArquivo(buffer.getFileData(file).getFileName());
                ca.setCliente(cliente);
                this.save(ca);
                extensao = null;
            }
            catch (Exception e) {
                throw new BusinessException("Erro ao gravar arquivo: " + e.getMessage());
            }
            finally {
                try {
                    is.close();
                    is = null;
                }
                catch (Exception exception) {}
            }
        }
        buffer = null;
    }

    public ClienteAnexo save(ClienteAnexo clienteAnexo) {
        if (clienteAnexo.getEstruturaUsuario() == null) {
            throw new BusinessException("Estrutura Usuario obrigatorio");
        }
        if (clienteAnexo.getHashArquivo().isBlank()) {
            throw new BusinessException("Hash obrigatorio");
        }
        if (clienteAnexo.getCliente() == null) {
            throw new BusinessException("Cliente obrigatorio");
        }
        this.clienteLogService.salvar(clienteAnexo.getCliente(), clienteAnexo.getEstruturaUsuario(), "Anexo " + clienteAnexo.getNomeArquivo() + " Inserido");
        return (ClienteAnexo)this.anexoRepository.save((Object)clienteAnexo);
    }

    public void delete(ClienteAnexo pa) throws Exception {
        this.delete(pa, Boolean.TRUE);
    }

    public void delete(ClienteAnexo pa, Boolean excluirAnexoBucket) throws Exception {
        if (excluirAnexoBucket.booleanValue()) {
            StorageUtil.deleteObject((String)pa.getHashArquivo());
        }
        this.clienteLogService.salvar(pa.getCliente(), pa.getEstruturaUsuario(), "Anexo " + pa.getNomeArquivo() + " Excluido");
        this.anexoRepository.delete((Object)pa);
    }

    public List<ClienteAnexo> getAnexo(Long clienteId) {
        return this.anexoRepository.findByClienteId(clienteId);
    }

    public List<ClienteAnexo> getAnexo(Cliente cliente) {
        return this.anexoRepository.findByCliente(cliente);
    }

    public List<ClienteAnexo> getByName(Cliente cliente, String nomeArquivo) {
        return this.anexoRepository.findByClienteAndNomeArquivo(cliente, nomeArquivo);
    }

    public String getZip(List<ClienteAnexo> lista) {
        try {
            File zipFile = new File("/tmp/" + HashUtil.getUUI() + ".zip");
            ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
            int ind = 0;
            for (ClienteAnexo pa : lista) {
                InputStream is;
                ++ind;
                String ext = FileUtil.getExtension((String)pa.getNomeArquivo(), (boolean)false);
                String fn = pa.getHashArquivo() + ext;
                try {
                    is = StorageUtil.getObject((String)fn);
                }
                catch (Exception ex) {
                    try {
                        fn = pa.getHashArquivo() + ext.toLowerCase();
                        is = StorageUtil.getObject((String)fn);
                    }
                    catch (Exception exx) {
                        try {
                            fn = pa.getHashArquivo() + ext.toUpperCase();
                            is = StorageUtil.getObject((String)fn);
                        }
                        catch (Exception exxx) {
                            continue;
                        }
                    }
                }
                ZipEntry ze = new ZipEntry(ind + "-" + StringUtil.normalize((String)pa.getNomeArquivo()));
                zos.putNextEntry(ze);
                byte[] bytes = new byte[1024];
                int count = is.read(bytes);
                while (count > -1) {
                    zos.write(bytes, 0, count);
                    count = is.read(bytes);
                }
                is.close();
                zos.closeEntry();
            }
            zos.close();
            byte[] fileContent = Files.readAllBytes(zipFile.toPath());
            zipFile.delete();
            return StorageUtil.uploadObjectByteArray((String)(HashUtil.getUUI() + ".zip"), (byte[])fileContent);
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
    }

    public List<ClienteAnexo> getByEstrutura(Estrutura estrutura) {
        return this.anexoRepository.findByEstruturaUsuarioEstrutura(estrutura);
    }

    public List<ClienteAnexo> getByHash(String hashArquivo) {
        return this.anexoRepository.findByHashArquivo(hashArquivo);
    }
}

