/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cliente.view;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.InformationDialog;
import br.com.system.app.components.MultiComboBox;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.cliente.model.ClienteTag;
import br.com.system.app.features.cliente.model.ClienteTrigger;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.cliente.service.ClienteTagService;
import br.com.system.app.features.cliente.service.ClienteTriggerService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.layout.size.FontSize;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.model.PedidoTags;
import br.com.system.app.features.pedido.service.PedidoTagsService;
import br.com.system.app.features.usuario.model.UsuarioTag;
import br.com.system.app.features.usuario.service.UsuarioTagService;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.Collection;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;

@Route(value="cliente-gatilho", layout=MainLayout.class)
@PageTitle(value="Gatilho atividade clientes")
@RolesAllowed(value={"CLIENTE_GATILHO_VIEW"})
public class ClienteTriggerView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final ClienteTriggerService clienteTriggerService;
    private final ClienteTagService clienteTagService;
    private final UsuarioTagService usuarioTagService;
    private final PedidoTagsService pedidoTagsService;
    private final ClienteService clienteService;
    private MultiComboBox<ClienteTag> cbClienteTag;
    private MultiComboBox<PedidoTags> cbPedidoTag;
    private ComboBox<UsuarioTag> cbUsuarioTag;
    private NumberField dias;
    private Checkbox cbAtivo;
    private ClienteTrigger trigger;
    private TextField txtNome;
    private GridCrud<ClienteTrigger> crud;
    private RadioButtonGroup<PedidoTipoEnum> rbTipo;

    public ClienteTriggerView(ClienteTriggerService clienteTriggerService, ClienteTagService clienteTagService, UsuarioTagService usuarioTagService, PedidoTagsService pedidoTagsService, ClienteService clienteService) {
        this.clienteTriggerService = clienteTriggerService;
        this.clienteTagService = clienteTagService;
        this.usuarioTagService = usuarioTagService;
        this.pedidoTagsService = pedidoTagsService;
        this.clienteService = clienteService;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent(this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private Component createContent() {
        this.crud = new GridCrud(ClienteTrigger.class);
        TextField filter = new TextField();
        filter.setPlaceholder("Filtrar por nome");
        filter.setClearButtonVisible(true);
        Button add = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PLUS, (String)"Adicionar registro");
        add.addClickListener((ComponentEventListener & Serializable)e -> {
            this.trigger = new ClienteTrigger();
            this.edit();
        });
        add.setEnabled(this.hasPermission("CLIENTE_GATILHO_SAVE"));
        this.crud.getCrudLayout().addToolbarComponent((Component)add);
        this.crud.getCrudLayout().addFilterComponent((Component)filter);
        this.crud.getGrid().setColumns(new String[0]);
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)c -> {
            Button edit = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PENCIL, (String)"Editar registro");
            edit.addClickListener((ComponentEventListener & Serializable)e -> {
                this.trigger = c;
                this.edit();
            });
            edit.setEnabled(this.hasPermission("CLIENTE_GATILHO_SAVE"));
            return edit;
        })).setFlexGrow(0).setWidth("50px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)c -> {
            Button trash = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.TRASH, (String)"Excluir registro");
            trash.addClickListener((ComponentEventListener & Serializable)e -> {
                ConfirmationDialog cd = new ConfirmationDialog("Excluir", "Confirma exclus\u00e3o?");
                cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
                cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                    this.clienteTriggerService.delete(c);
                    cd.close();
                    this.crud.refreshGrid();
                });
            });
            trash.setEnabled(this.hasPermission("CLIENTE_GATILHO_DELETE"));
            return trash;
        })).setFlexGrow(0).setWidth("50px");
        this.crud.getGrid().addColumn("nome").setFlexGrow(0).setWidth("250px").setHeader("Nome");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataCriacao().format(FormatDate.DATE_BR.toDTF()))).setFlexGrow(0).setWidth("160px").setHeader("Cria\u00e7\u00e3o");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getEstruturaUsuario().getUsuario().getNome())).setFlexGrow(0).setWidth("250px").setHeader("Usu\u00e1rio");
        this.crud.getGrid().addColumn("tagsCliente").setFlexGrow(0).setWidth("200px").setHeader("Tags Cliente");
        this.crud.getGrid().addColumn("dias").setFlexGrow(0).setWidth("80px").setHeader("Dias");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getAtivo() != false ? "Ativo" : "Inativo")).setHeader("Ativo").setFlexGrow(0).setWidth("100px");
        this.crud.getCrudFormFactory().setVisibleProperties(new String[0]);
        this.crud.getAddButton().setVisible(false);
        this.crud.getUpdateButton().setVisible(false);
        this.crud.getDeleteButton().setVisible(false);
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        filter.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.crud.refreshGrid());
        return this.crud;
    }

    private void edit() {
        if (this.trigger == null) {
            this.trigger = new ClienteTrigger();
        }
        Dialog dialog = new Dialog();
        this.txtNome = new TextField("Nome Gatilho");
        this.txtNome.setValue(this.trigger.getNome() == null ? "" : this.trigger.getNome());
        this.cbClienteTag = new MultiComboBox("Selecionar Clientes com as Tags", (Collection)this.clienteTagService.getTags(this.getEstrutura()));
        this.cbClienteTag.setItemLabelGenerator(ClienteTag::getTag);
        if (this.trigger.getTagsCliente() != null && !this.trigger.getTagsCliente().isBlank()) {
            this.cbClienteTag.setValue(this.clienteTagService.getTags(this.getEstrutura(), this.trigger.getTagsCliente()));
        }
        this.rbTipo = new RadioButtonGroup();
        UIUtils.setFontSize((FontSize)FontSize.XXS, (Component[])new Component[]{this.rbTipo});
        this.rbTipo.setItems((Object[])PedidoTipoEnum.values());
        if (this.trigger != null && this.trigger.getTipo() != null) {
            this.rbTipo.setValue((Object)this.trigger.getTipo());
        } else {
            this.rbTipo.setValue((Object)PedidoTipoEnum.COMERCIAL);
        }
        this.rbTipo.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.cbPedidoTag.setItems((Collection)this.pedidoTagsService.getTags(this.getEstrutura(), (PedidoTipoEnum)e.getValue())));
        this.cbPedidoTag = new MultiComboBox("Criar Atividades com as Tags", (Collection)this.pedidoTagsService.getTags(this.getEstrutura(), (PedidoTipoEnum)this.rbTipo.getValue()));
        this.cbPedidoTag.setWidth("150px");
        this.cbPedidoTag.setItemLabelGenerator(PedidoTags::getTagAndCategoria);
        if (this.trigger.getTagsCliente() != null && !this.trigger.getTagsCliente().isBlank()) {
            this.cbPedidoTag.setValue(this.pedidoTagsService.getTags(this.getEstrutura(), (PedidoTipoEnum)this.rbTipo.getValue(), this.trigger.getTagsAtividade()));
        }
        this.cbUsuarioTag = new ComboBox("Distribuir entre usu\u00e1rios que tenham a tag", (Collection)this.usuarioTagService.getTags(this.getEstrutura()));
        this.cbUsuarioTag.setItemLabelGenerator(UsuarioTag::getTag);
        if (this.trigger.getTagsCliente() != null && !this.trigger.getTagsCliente().isBlank()) {
            this.cbUsuarioTag.setValue((Object)this.usuarioTagService.getByTag(this.getEstrutura(), this.trigger.getTagUsuario()));
        }
        this.dias = new NumberField("Dias");
        this.dias.setMin(30.0);
        this.dias.setMax(365.0);
        if (this.trigger.getDias() != null) {
            this.dias.setValue((Number)this.trigger.getDias().doubleValue());
        }
        this.cbAtivo = new Checkbox("Ativo");
        if (this.trigger.getAtivo() != null) {
            this.cbAtivo.setValue((Object)this.trigger.getAtivo());
        }
        Button btnSimular = UIUtils.createSmallButton((String)"Simular", (VaadinIcon)VaadinIcon.EYE);
        btnSimular.addClickListener((ComponentEventListener & Serializable)e -> {
            this.setTrigger();
            InformationDialog.show((String)"Simula\u00e7\u00e3o", (String)(this.clienteService.getByTrigger(this.getEstrutura(), this.trigger).size() + " Clientes Nessas condi\u00e7\u00f5es"));
        });
        Button btnFechar = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE);
        btnFechar.addClickListener((ComponentEventListener & Serializable)e -> dialog.close());
        Button btnSalvar = UIUtils.createSmallButton((String)"Salvar", (VaadinIcon)VaadinIcon.INBOX);
        btnSalvar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.txtNome.getValue().isBlank() || this.cbClienteTag.getValue().size() <= 0 || this.dias.getValue() == null || (Double)this.dias.getValue() <= 0.0) {
                this.showNotification("Nome, cliente tags, dias s\u00e3o obrigat\u00f3rios");
                return;
            }
            this.setTrigger();
            ConfirmationDialog cd = new ConfirmationDialog("Criar Gatilho", "Neste momento voc\u00ea tem " + this.clienteService.getByTrigger(this.getEstrutura(), this.trigger).size() + " clientes nessas condicoes.\nEssas atividades ser\u00e3o criadas amanh\u00e3.\nConfirma a cria\u00e7\u00e3o?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                this.clienteTriggerService.save(this.trigger, this.getEu());
                cd.close();
                this.crud.refreshGrid();
                dialog.close();
            });
        });
        VerticalContainer c = new VerticalContainer(new Component[0]);
        c.add(new Component[]{this.txtNome, this.cbAtivo, this.cbClienteTag, this.dias, this.rbTipo, this.cbPedidoTag, this.cbUsuarioTag, new FooterContainer(new Component[]{btnFechar, btnSimular, btnSalvar})});
        dialog.add(new Component[]{c});
        dialog.open();
    }

    private void setTrigger() {
        this.trigger.setAtivo((Boolean)this.cbAtivo.getValue());
        this.trigger.setDias(Integer.valueOf(((Double)this.dias.getValue()).intValue()));
        this.trigger.setNome(this.txtNome.getValue());
        this.trigger.setTipo((PedidoTipoEnum)this.rbTipo.getValue());
        if (this.trigger.getEstruturaUsuario() == null) {
            this.trigger.setEstruturaUsuario(this.getEu());
        }
        if (this.cbClienteTag.getValue() != null) {
            this.trigger.setTagsCliente(this.clienteTagService.getStringtags(this.cbClienteTag.getValue()));
        }
        if (this.cbUsuarioTag.getValue() != null) {
            this.trigger.setTagUsuario(((UsuarioTag)this.cbUsuarioTag.getValue()).getTag());
        }
        if (this.cbPedidoTag.getValue() != null) {
            this.trigger.setTagsAtividade(this.pedidoTagsService.getStringtags(this.cbPedidoTag.getValue()));
        }
    }
}

