/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cliente.view.form;

import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.creditos.service.CreditosService;
import br.com.system.app.features.datastone.model.DataStone;
import br.com.system.app.features.datastone.service.DataStoneService;
import br.com.system.app.features.enriquecimento.model.EnriquecimentoItens;
import br.com.system.app.features.enriquecimento.service.EnriquecimentoFindService;
import br.com.system.app.features.enriquecimento.service.EnriquecimentoService;
import br.com.system.app.features.estrutura.model.EstruturaComplemento;
import br.com.system.app.features.estrutura.service.EstruturaComplementoService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.oportunidade.model.OportunidadeFileItem;
import br.com.system.app.features.oportunidade.service.OportunidadeFindService;
import br.com.system.app.features.shared.model.TipoProcessoEnum;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Hr;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import java.io.Serializable;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;

@Component
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class ClienteFormEnriquecimento
extends VerticalLayout
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    @Autowired
    private EnriquecimentoService enriquecimentoService;
    @Autowired
    private CreditosService creditosService;
    @Autowired
    private EstruturaComplementoService estruturaComplementoService;
    @Autowired
    private EnriquecimentoFindService enriquecimentoFindService;
    @Autowired
    private OportunidadeFindService oportunidadeFindService;
    @Autowired
    private DataStoneService dataStoneService;
    private Cliente cliente;

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public VerticalLayout create(Cliente cli) {
        VerticalLayout lay = new VerticalLayout();
        this.cliente = cli;
        lay.removeAll();
        lay.setEnabled(this.cliente != null && this.cliente.getId() != null);
        lay.add(new com.vaadin.flow.component.Component[]{new Hr()});
        lay.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Enriquecimento Base")});
        Button btnIq = UIUtils.createSmallButton((String)"Enriquecimento");
        btnIq.addClickListener((ComponentEventListener & Serializable)e -> {
            ConfirmationDialog cd = new ConfirmationDialog("Enriquecimento de Base", "Confirma a\u00e7\u00e3o de enriquecimento de base?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                cd.close();
                try {
                    HashSet<String> cnpjs = new HashSet<String>();
                    cnpjs.add(cli.getCpfCnpj());
                    EstruturaComplemento compl = this.estruturaComplementoService.getComplementos(this.getEstrutura());
                    if (!this.creditosService.temCredito(this.getEu(), compl.getValorEnriquecimento())) {
                        UIUtils.showNotification((String)"Voc\u00ea n\u00e3o tem c\u0155editos suficientes");
                        return;
                    }
                    if (cli.getCpfCnpj().length() == 14) {
                        this.enriquecimentoService.processar(this.getEu(), cnpjs, cli.getCpfCnpj() + ".xlsx", TipoProcessoEnum.CNPJ, false, true, false);
                    } else {
                        this.enriquecimentoService.processar(this.getEu(), cnpjs, cli.getCpfCnpj() + ".xlsx", TipoProcessoEnum.CPF, false, true, false);
                    }
                    UIUtils.showNotification((String)"Solicita\u00e7\u00e3o de enriquecimento efetuada, ao final vc ser\u00e1 notificado.");
                }
                catch (Exception ex) {
                    UIUtils.showNotification((String)ex.getMessage());
                }
            });
        });
        Span spanData = new Span();
        Span spanFunc = new Span();
        if (cli != null && cli.getId() != null) {
            OportunidadeFileItem op = this.oportunidadeFindService.getByEstruturaAndCpfCnpj(cli.getEstrutura(), cli.getCpfCnpj());
            EnriquecimentoItens enri = this.enriquecimentoFindService.getByEstruturaAndCpfCnpj(cli.getEstrutura(), cli.getCpfCnpj());
            if (op != null && enri != null) {
                if (op.getOportunidadeFile().getDataHoraImportacao().isAfter(enri.getEnriquecimento().getDataHora())) {
                    spanData.setText("Enriquecido em " + op.getOportunidadeFile().getDataHoraImportacao().format(FormatDate.DATETIME_BR.toDTF()));
                } else {
                    spanData.setText("Enriquecido em " + enri.getEnriquecimento().getDataHora().format(FormatDate.DATETIME_BR.toDTF()));
                }
            } else if (op != null) {
                spanData.setText("Enriquecido em " + op.getOportunidadeFile().getDataHoraImportacao().format(FormatDate.DATETIME_BR.toDTF()));
            } else if (enri != null) {
                spanData.setText("Enriquecido em " + enri.getEnriquecimento().getDataHora().format(FormatDate.DATETIME_BR.toDTF()));
            }
            DataStone dataStone = this.dataStoneService.getByCpfCnpj(cli.getCpfCnpj());
            if ((op != null || enri != null) && dataStone != null && dataStone.getFuncionarios() != null) {
                spanFunc.setText("  " + dataStone.getFuncionarios());
            }
            lay.add(new com.vaadin.flow.component.Component[]{btnIq, spanData, spanFunc});
        }
        return lay;
    }
}

