/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.creditos;

import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.features.cep.service.CepService;
import br.com.system.app.features.creditos.model.CreditosFatura;
import br.com.system.app.features.creditos.model.CreditosFaturaStatusEnum;
import br.com.system.app.features.creditos.service.CreditosService;
import br.com.system.app.features.endereco.EnderecoView;
import br.com.system.app.features.endereco.model.Endereco;
import br.com.system.app.features.endereco.model.EnderecoTipoEnum;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.mailing.model.Mailing;
import br.com.system.app.features.mailing.service.MailingService;
import br.com.system.app.features.starkbank.StarkBankQrcodeView;
import br.com.system.app.features.starkbank.StarkBankService;
import br.com.system.app.features.starkbank.StarkBankTipoEnum;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.usuario.service.UsuarioService;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.StringUtil;
import br.com.system.commons.TelefoneUtil;
import br.com.system.commons.ValidationUtil;
import com.starkbank.Invoice;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.textfield.EmailField;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;

@Component
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class CreditosCompraView
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    @Autowired
    private CreditosService creditosService;
    @Autowired
    private StarkBankService starkBankService;
    @Autowired
    private MailingService mailingService;
    @Autowired
    private CepService cepService;
    @Autowired
    private UsuarioService usuarioService;
    private EnderecoView enderecoView;
    private EstruturaUsuario eu;
    private Button btnFechar;
    private Grid<CreditosFatura> grid;
    private TextField saldo;

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public void create(EstruturaUsuario eu) {
        this.enderecoView = new EnderecoView(this.cepService, this.getEnd(eu.getUsuario()), EnderecoTipoEnum.COMERCIAL, "Endere\u00e7o");
        this.removeAll();
        this.eu = eu;
        this.setCloseOnOutsideClick(false);
        this.setWidth("950px");
        this.setMinHeight("700px");
        this.saldo = new TextField("Saldo Atual");
        this.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Comprar cr\u00e9ditos")});
        this.btnFechar = UIUtils.createSmallButton((String)"Fechar");
        this.add(new com.vaadin.flow.component.Component[]{this.createBuyStark()});
        this.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Suas Faturas")});
        this.add(new com.vaadin.flow.component.Component[]{this.createGrid()});
        this.btnFechar.addClickListener((ComponentEventListener & Serializable)close -> this.close());
        this.open();
        this.atualizarSaldo();
    }

    private void atualizarSaldo() {
        this.saldo.setValue("R$ " + this.creditosService.getCredito(this.eu).toString());
    }

    public Button getCloseButton() {
        return this.btnFechar;
    }

    private Grid<CreditosFatura> createGrid() {
        this.grid = new Grid(CreditosFatura.class);
        this.grid.setWidthFull();
        this.grid.setHeight("300px");
        this.grid.setColumns(new String[0]);
        this.grid.addComponentColumn((ValueProvider & Serializable)item -> {
            Button btn = UIUtils.createSmallButton((String)"QRCODE");
            btn.setVisible(item.getStarkId() != null && !item.getStarkId().isEmpty() && item.getStatus().equals((Object)CreditosFaturaStatusEnum.EM_ABERTO));
            btn.addClickListener((ComponentEventListener & Serializable)click -> {
                Invoice invoice = this.starkBankService.getInvoice(item.getStarkId());
                this.openQrcode(item, invoice);
            });
            return btn;
        }).setHeader("Acessar").setFlexGrow(0).setWidth("120px");
        this.grid.addComponentColumn((ValueProvider & Serializable)item -> {
            Button btnCancelar = UIUtils.createSmallButton((String)"Cancelar");
            btnCancelar.setEnabled(item.getStatus().equals((Object)CreditosFaturaStatusEnum.EM_ABERTO));
            btnCancelar.addClickListener((ComponentEventListener & Serializable)e -> {
                ConfirmationDialog cd = new ConfirmationDialog("Cancelar Fatura", "Confirma o cancelamento da fatura?");
                cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
                cd.getConfirm().addClickListener((ComponentEventListener & Serializable)confirm -> {
                    this.creditosService.cancelarFatura(item);
                    UIUtils.showNotification((String)"Fatura cancelada com sucesso");
                    this.atualizarGrid();
                    cd.close();
                });
            });
            return btnCancelar;
        }).setHeader("Cancelar").setFlexGrow(0).setWidth("120px");
        this.grid.addComponentColumn((ValueProvider & Serializable)item -> {
            if (item.getLinkPdfEnotas() != null && !item.getLinkPdfEnotas().isEmpty()) {
                Anchor anchor = new Anchor(item.getLinkPdfEnotas(), new com.vaadin.flow.component.Component[0]);
                anchor.setText("Baixar");
                anchor.setTitle("Baixar PDF da Nota fiscal");
                anchor.setVisible(item.getLinkPdfEnotas() != null && !item.getLinkPdfEnotas().isEmpty());
                anchor.setTarget("_blank");
                return anchor;
            }
            if (item.getStatus().equals((Object)CreditosFaturaStatusEnum.CANCELADA)) {
                return new Span("Cancelado");
            }
            return new Span("Processando");
        }).setHeader("NF").setFlexGrow(0).setWidth("180px");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getStatus().name())).setHeader("Status").setFlexGrow(0).setWidth("150px");
        this.grid.addColumn("valor").setFlexGrow(0).setWidth("150px");
        this.grid.addColumn("cpfCnpj").setFlexGrow(0).setWidth("160px");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getNome()))).setHeader("Nome").setFlexGrow(0).setWidth("250px");
        this.atualizarGrid();
        return this.grid;
    }

    private HorizontalContainer createBuyStark() {
        Usuario u = this.getEu().getUsuario();
        HorizontalContainer h = new HorizontalContainer(new com.vaadin.flow.component.Component[0]);
        TextField cnpj = new TextField("CPF/CNPJ");
        TextField nome = new TextField("Nome");
        if (u.getCpf() != null && !u.getCpf().isEmpty()) {
            cnpj.setValue(StringUtil.numbersOnly((String)u.getCpf()));
        }
        if (u.getNome() != null && !u.getNome().isEmpty()) {
            nome.setValue(u.getNome());
        }
        TextField celular = new TextField("Celular");
        if (u.getCelular() != null && !u.getCelular().isEmpty()) {
            celular.setValue(u.getCelular());
        }
        EmailField email = new EmailField("E-mail");
        if (u.getEmail() != null && !u.getEmail().isEmpty()) {
            email.setValue(u.getEmail());
        }
        NumberField valor = new NumberField("Valor(Min R$25,00)");
        cnpj.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            String c = StringUtil.numbersOnly((String)((String)e.getValue()));
            if (!c.equals(e.getValue())) {
                cnpj.setValue(c);
            }
            if (cnpj.getValue().length() == 14) {
                Mailing m = this.mailingService.buscarCnpj(c);
                if (m != null) {
                    nome.setValue(m.getNome());
                } else {
                    UIUtils.showNotification((String)"CNPJ Inv\u00e1lido");
                    nome.setValue("");
                }
            }
        });
        valor.setWidth("130px");
        Button btnCriarFatura = UIUtils.createSmallButton((String)"Criar Fatura");
        btnCriarFatura.setDisableOnClick(true);
        h.add(new com.vaadin.flow.component.Component[]{cnpj, nome, celular, email});
        h.add(new com.vaadin.flow.component.Component[]{valor, this.enderecoView, new FooterContainer(new com.vaadin.flow.component.Component[]{this.btnFechar, btnCriarFatura})});
        btnCriarFatura.addClickListener((ComponentEventListener & Serializable)e -> {
            Object erro = "";
            if (!ValidationUtil.isValidCnpjAndCpf((String)cnpj.getValue())) {
                erro = (String)erro + "CPF/CNPJ inv\u00e1lido\n";
            }
            if (valor.getValue() == null || (Double)valor.getValue() < 25.0) {
                erro = (String)erro + "Valor minimo de compra R$ 25,00\n";
            }
            if (nome.getValue() == null || nome.getValue().isEmpty()) {
                erro = (String)erro + "Informe seu nome\n";
            }
            if (!ValidationUtil.isValidEmail((String)email.getValue())) {
                erro = (String)erro + "E-mail inv\u00e1lido\n";
            }
            if (!TelefoneUtil.isCelular((String)celular.getValue())) {
                erro = (String)erro + "Celular inv\u00e1lido\n";
            }
            if (!this.enderecoView.getErros().isEmpty()) {
                erro = (String)erro + this.enderecoView.getErros();
            }
            btnCriarFatura.setEnabled(true);
            if (!((String)erro).isEmpty()) {
                UIUtils.showNotification((String)erro);
                return;
            }
            Invoice invoice = this.starkBankService.createInvoice(StarkBankTipoEnum.CREDITO, this.getEu(), cnpj.getValue(), nome.getValue(), email.getValue(), (Double)valor.getValue(), LocalDate.now().plusDays(2L));
            CreditosFatura cf = new CreditosFatura();
            cf.setCpfCnpj(cnpj.getValue());
            cf.setDataHora(LocalDateTime.now());
            cf.setEmail(email.getValue());
            cf.setEstruturaUsuario(this.eu);
            cf.setNome(nome.getValue());
            cf.setStatus(CreditosFaturaStatusEnum.EM_ABERTO);
            cf.setTelefone(celular.getValue());
            cf.setValor(BigDecimal.valueOf((Double)valor.getValue()));
            cf.setStarkId(invoice.id);
            Endereco end = this.enderecoView.getValue();
            u.setCpf(cnpj.getValue());
            u.setCep(end.getCep());
            u.setLogradouro(end.getLogradouro());
            u.setNumero(end.getNumero());
            u.setCompl(end.getComplemento());
            u.setBairro(end.getBairro());
            u.setCidade(end.getCidade());
            u.setEstado(end.getEstado());
            this.usuarioService.salvar(u, this.eu);
            cf.setUrl(invoice.link);
            this.creditosService.salvarFatura(cf);
            this.openQrcode(cf, invoice);
        });
        return h;
    }

    private void openQrcode(CreditosFatura cf, Invoice invoice) {
        StarkBankQrcodeView qrView = new StarkBankQrcodeView();
        qrView.criar(invoice);
        Button btnClose = qrView.getBtnClose();
        btnClose.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.isPaid(cf, invoice)) {
                UIUtils.showNotification((String)"Fatura paga com sucesso! O valor j\u00e1 foi creditado no seu saldo! OBRIGADO!");
            }
            qrView.close();
            this.atualizarGrid();
        });
        Button btnValidar = qrView.getBtnValidar();
        btnValidar.setVisible(cf.getStatus().equals((Object)CreditosFaturaStatusEnum.EM_ABERTO));
        btnValidar.addClickListener((ComponentEventListener & Serializable)ex -> {
            if (this.isPaid(cf, invoice)) {
                UIUtils.showNotification((String)"Fatura paga com sucesso! O valor j\u00e1 foi creditado no seu saldo! OBRIGADO!");
                qrView.close();
            } else {
                UIUtils.showNotification((String)"Fatura ainda n\u00e3o foi paga");
            }
            this.atualizarGrid();
        });
    }

    private boolean isPaid(CreditosFatura cf, Invoice invoice) {
        Invoice i = this.starkBankService.getInvoice(invoice.id);
        if (i.status.equals("paid")) {
            this.creditosService.pagar(cf);
            return true;
        }
        return false;
    }

    private void atualizarGrid() {
        this.grid.setItems((Collection)this.creditosService.getFaturasByEstruturausuario(this.eu));
    }

    private Endereco getEnd(Usuario u) {
        Endereco end = new Endereco();
        if (u == null) {
            return end;
        }
        end.setBairro(u.getBairro());
        end.setCep(u.getCep());
        end.setCidade(u.getCidade());
        end.setComplemento(u.getCompl());
        end.setEstado(u.getEstado());
        end.setLogradouro(u.getLogradouro());
        end.setNumero(u.getNumero());
        return end;
    }
}

