/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.dashboard;

import br.com.system.app.components.DownloadDialog;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.dashboard.DashBoardBoxForm;
import br.com.system.app.features.dashboard.DashBoardBoxTipoEnum;
import br.com.system.app.features.dashboard.service.DashBoardExportacaoService;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.layout.Color;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.producaopainel.dto.ProducaoPainelDetalhamentoDTO;
import br.com.system.app.features.producaopainel.dto.ProducaoPainelResumoDTO;
import br.com.system.app.features.producaopainel.model.ProducaoPainelBox;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.CurrencyUtil;
import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.Axis;
import com.storedobject.chart.BarChart;
import com.storedobject.chart.CategoryData;
import com.storedobject.chart.CoordinateSystem;
import com.storedobject.chart.Data;
import com.storedobject.chart.DataType;
import com.storedobject.chart.NightingaleRoseChart;
import com.storedobject.chart.Position;
import com.storedobject.chart.RectangularCoordinate;
import com.storedobject.chart.SOChart;
import com.storedobject.chart.Size;
import com.storedobject.chart.Toolbox;
import com.storedobject.chart.ToolboxButton;
import com.storedobject.chart.XAxis;
import com.storedobject.chart.XYAxis;
import com.storedobject.chart.YAxis;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.H4;
import com.vaadin.flow.component.html.H5;
import com.vaadin.flow.component.html.H6;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DashBoardBoxView
extends VerticalContainer
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final DownloadDialog dd;
    Icon pencil = VaadinIcon.PENCIL.create();
    Icon table = VaadinIcon.TABLE.create();
    HorizontalContainer mainContainer;

    public DashBoardBoxView() {
        super(new Component[0]);
        this.dd = new DownloadDialog();
    }

    public void setDefault(EstruturaUsuario eu, String mesAno, DashBoardBoxForm form, ProducaoPainelBox box, DashBoardExportacaoService des) {
        this.setId("box");
        this.removeAll();
        this.setAlignItems(FlexComponent.Alignment.CENTER);
        this.pencil.setVisible(this.hasPermission("PAINEL_PRODUCAO_BOX_SAVE"));
        this.pencil.addClickListener((ComponentEventListener & Serializable)e -> form.create(box.getEstrutura(), box));
        this.table.addClickListener((ComponentEventListener & Serializable)e -> {
            String url = des.exportar(eu, box, mesAno);
            this.dd.open(url, box.getNome() + ".xlsx", true);
        });
        H5 label = UIUtils.createHeader((String)box.getNome());
        label.setWidth("98%");
        HorizontalContainer header = new HorizontalContainer(new Component[0]).setNoWrap();
        header.add(new Component[]{label, this.pencil});
        if (!box.getTipo().equals((Object)DashBoardBoxTipoEnum.CABECALHO)) {
            header.add(new Component[]{this.table});
        }
        header.setWidth("99%");
        this.add(new Component[]{header});
        this.mainContainer = new HorizontalContainer(new Component[0]).setNoWrap().setPaddingOff().setSpacingOff();
        this.mainContainer.setId("mainContainer");
        this.mainContainer.setAlignItems(FlexComponent.Alignment.CENTER);
        this.mainContainer.setWidthFull();
        if (box.getBackgroundColor() != null) {
            this.getStyle().set("background-color", box.getBackgroundColor());
        } else {
            this.getStyle().set("background-color", "var(--lumo-shade-5pct)");
        }
        this.add(new Component[]{this.mainContainer});
    }

    public VerticalContainer createGrid(EstruturaUsuario eu, DashBoardBoxForm form, DashBoardExportacaoService des, ProducaoPainelBox box, List<ProducaoPainelDetalhamentoDTO> dto, String mesAno) {
        this.setMaxWidth("100%");
        this.setHeight("400px");
        this.setAlignItems(FlexComponent.Alignment.CENTER);
        this.setDefault(eu, mesAno, form, box, des);
        Grid grid = new Grid(ProducaoPainelDetalhamentoDTO.class);
        grid.setColumns(new String[0]);
        grid.setWidth("100%");
        grid.setHeight("350px");
        grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getNumero()))).setHeader("N\u00famero").setFlexGrow(0).setWidth("150px");
        grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getCpfCnpj()))).setHeader("CPF-CNPJ").setFlexGrow(0).setWidth("160px");
        grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getNomeCliente()))).setHeader("Cliente").setFlexGrow(0).setWidth("250px");
        grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getFila()))).setHeader("Fila").setFlexGrow(0).setWidth("200px");
        grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getLoginUsuario()))).setHeader("Usu\u00e1rio").setFlexGrow(0).setWidth("250px");
        grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getQuantidade().toString()))).setHeader("Quantidade").setFlexGrow(0).setWidth("120px");
        grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)CurrencyUtil.toCurrencyWithR$((BigDecimal)p.getValor())))).setHeader("Valor").setFlexGrow(0).setWidth("120px");
        grid.setItems(dto);
        this.mainContainer.add(new Component[]{grid});
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public VerticalContainer createBox(EstruturaUsuario eu, DashBoardBoxForm form, DashBoardExportacaoService des, ProducaoPainelBox box, List<ProducaoPainelResumoDTO> dto, String mesAno) {
        this.setDefault(eu, mesAno, form, box, des);
        if (box.getTipo().equals((Object)DashBoardBoxTipoEnum.NORMAL)) {
            this.setMaxWidth("390px");
            BigDecimal valorAnterior = null;
            for (ProducaoPainelResumoDTO producaoPainelResumoDTO : dto) {
                VerticalContainer verticalContainer = new VerticalContainer(new Component[0]);
                verticalContainer.setAlignItems(FlexComponent.Alignment.CENTER);
                verticalContainer.add(new Component[]{new H4(producaoPainelResumoDTO.getMesAno().substring(4, 6) + "-" + producaoPainelResumoDTO.getMesAno().substring(0, 4))});
                if (box.getMostrarValor().booleanValue()) {
                    if (valorAnterior != null && valorAnterior.compareTo(producaoPainelResumoDTO.getValor()) >= 0) {
                        this.mainContainer.add(new Component[]{this.getIconDown()});
                    } else if (valorAnterior != null && valorAnterior.compareTo(producaoPainelResumoDTO.getValor()) < 0) {
                        this.mainContainer.add(new Component[]{this.getIconUp()});
                    }
                }
                verticalContainer.add(new Component[]{new H6(CurrencyUtil.toCurrencyWithR$((BigDecimal)producaoPainelResumoDTO.getValor()))});
                if (box.getMostrarQuantidade().booleanValue()) {
                    verticalContainer.add(new Component[]{new H6(producaoPainelResumoDTO.getQuantidade().toString())});
                }
                this.mainContainer.add(new Component[]{verticalContainer});
                valorAnterior = producaoPainelResumoDTO.getValor();
            }
        } else if (box.getTipo().equals((Object)DashBoardBoxTipoEnum.CONTAGEM_CONSULTOR) || box.getTipo().equals((Object)DashBoardBoxTipoEnum.CONTAGEM_CNPJ)) {
            this.setMaxWidth("390px");
            LinkedHashMap<String, Integer> mesano = new LinkedHashMap<String, Integer>();
            for (ProducaoPainelResumoDTO producaoPainelResumoDTO : dto) {
                if (mesano.containsKey(producaoPainelResumoDTO.getMesAno())) {
                    mesano.put(producaoPainelResumoDTO.getMesAno(), (Integer)mesano.get(producaoPainelResumoDTO.getMesAno()) + 1);
                    continue;
                }
                mesano.put(producaoPainelResumoDTO.getMesAno(), 1);
            }
            Integer qtdeAntes = null;
            for (Map.Entry entry : mesano.entrySet()) {
                if (qtdeAntes != null && qtdeAntes > (Integer)entry.getValue()) {
                    this.mainContainer.add(new Component[]{this.getIconDown()});
                } else if (qtdeAntes != null && qtdeAntes <= (Integer)entry.getValue()) {
                    this.mainContainer.add(new Component[]{this.getIconUp()});
                }
                VerticalContainer content = new VerticalContainer(new Component[0]);
                content.setAlignItems(FlexComponent.Alignment.CENTER);
                content.add(new Component[]{new H4(((String)entry.getKey()).substring(4, 6) + "-" + ((String)entry.getKey()).substring(0, 4))});
                content.add(new Component[]{new H6(((Integer)entry.getValue()).toString())});
                this.mainContainer.add(new Component[]{content});
                qtdeAntes = (Integer)entry.getValue();
            }
        } else if (box.getTipo().equals((Object)DashBoardBoxTipoEnum.RANKING)) {
            void var9_23;
            this.setMaxWidth("100%");
            this.setAlignItems(FlexComponent.Alignment.CENTER);
            VerticalContainer content1 = new VerticalContainer(new Component[0]);
            content1.setWidth("50%");
            content1.add(new Component[]{new H4("Melhor Resultado")});
            for (int i = 0; i < 10; ++i) {
                try {
                    String string = dto.get(i).getLoginUsuario();
                    content1.add(new Component[]{new FooterContainer(new Component[]{new HorizontalContainer(new Component[]{new Span(i + 1 + "\u00ba"), new Span(string)}), new Span(CurrencyUtil.toCurrency((BigDecimal)dto.get(i).getValor()))})});
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            VerticalContainer content2 = new VerticalContainer(new Component[0]);
            content2.add(new Component[]{new H4("Ranking Invertido")});
            content2.setWidth("50%");
            int n = dto.size() - 1;
            while (var9_23 > dto.size() - 11) {
                try {
                    String string = dto.get((int)var9_23).getLoginUsuario();
                    content2.add(new Component[]{new FooterContainer(new Component[]{new HorizontalContainer(new Component[]{new Span((int)(var9_23 + true) + "\u00ba"), new Span(string)}), new Span(CurrencyUtil.toCurrencyWithR$((BigDecimal)dto.get((int)var9_23).getValor()))})});
                }
                catch (Exception exception) {
                    // empty catch block
                }
                --var9_23;
            }
            FooterContainer footerContainer = new FooterContainer(new Component[]{content1, content2});
            footerContainer.setWidth("100%");
            this.mainContainer.add(new Component[]{footerContainer});
        } else if (box.getTipo().equals((Object)DashBoardBoxTipoEnum.CABECALHO)) {
            this.setMaxWidth("100%");
            this.setHeight("35px");
            this.setAlignItems(FlexComponent.Alignment.CENTER);
            this.setPaddingOff();
            this.setSpacingOff();
        } else if (box.getTipo().equals((Object)DashBoardBoxTipoEnum.GRAFICO_GRUPO) || box.getTipo().equals((Object)DashBoardBoxTipoEnum.GRAFICO_ANUAL) || box.getTipo().equals((Object)DashBoardBoxTipoEnum.GRAFICO_FILA)) {
            this.setMaxWidth("100%");
            this.setAlignItems(FlexComponent.Alignment.CENTER);
            CategoryData labels = new CategoryData(new String[0]);
            Data data = new Data(new Number[0]);
            for (ProducaoPainelResumoDTO producaoPainelResumoDTO : dto) {
                labels.add((Object)producaoPainelResumoDTO.getNome());
                if (box.getMostrarQuantidade().booleanValue()) {
                    data.add((Object)producaoPainelResumoDTO.getQuantidade());
                    continue;
                }
                data.add((Object)producaoPainelResumoDTO.getValor());
            }
            SOChart sOChart = this.getChart(labels, data, box.getNome());
            this.mainContainer.add(new Component[]{sOChart});
        }
        return this;
    }

    private Icon getIconDown() {
        Icon icon = VaadinIcon.ARROW_DOWN.create();
        icon.getElement().getStyle().set("width", "50px");
        icon.setColor(Color.RED.name());
        return icon;
    }

    private Icon getIconUp() {
        Icon icon = VaadinIcon.ARROW_UP.create();
        icon.getElement().getStyle().set("width", "50px");
        icon.setColor(Color.GREEN.name());
        return icon;
    }

    private SOChart getChart(CategoryData labels, Data data, String nomeGrafico) {
        SOChart soChart = new SOChart();
        soChart.setSize("95%", "500px");
        NightingaleRoseChart nc = new NightingaleRoseChart((AbstractDataProvider)labels, data);
        Position p = new Position();
        p.setTop(Size.percentage((int)50));
        nc.setPosition(p);
        BarChart bc = new BarChart((AbstractDataProvider)labels, (AbstractDataProvider)data);
        RectangularCoordinate rc = new RectangularCoordinate(new XYAxis[]{new XAxis(DataType.CATEGORY), new YAxis(DataType.NUMBER)});
        p = new Position();
        p.setBottom(Size.percentage((int)55));
        rc.setPosition(p);
        bc.plotOn((CoordinateSystem)rc, new Axis[0]);
        Toolbox toolbox = new Toolbox();
        toolbox.addButton(new ToolboxButton[]{new Toolbox.Download(), new Toolbox.Zoom()});
        soChart.add(new com.storedobject.chart.Component[]{nc, bc, toolbox});
        return soChart;
    }
}

