/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.datastone.service;

import br.com.system.app.features.datastone.service.DataStoneProcessaService;
import br.com.system.app.features.datastone.service.DataStoneService;
import br.com.system.app.features.enriquecimento.model.Enriquecimento;
import br.com.system.app.features.enriquecimento.model.EnriquecimentoItens;
import br.com.system.app.features.enriquecimento.service.EnriquecimentoItensService;
import br.com.system.app.features.enriquecimento.service.EnriquecimentoService;
import br.com.system.app.features.shared.model.StatusProcessoEnum;
import java.util.HashSet;
import java.util.List;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataStoneEnriquecimento {
    @Autowired
    private EnriquecimentoService enriquecimentoService;
    @Autowired
    private EnriquecimentoItensService enriquecimentoItensService;
    @Autowired
    private DataStoneProcessaService dataStoneProcessaService;
    @Autowired
    private DataStoneService dataStoneService;

    public void goEnriquecimento(Enriquecimento e, JSONObject jsonBody) {
        try {
            e.setUrlArquivo("");
            if (jsonBody.getString("status").equals("error")) {
                e.setStatusAnalise(StatusProcessoEnum.FINALIZADO_COM_ERRO);
                e.setObservacao("Erro no player de mailinglist" + String.valueOf(jsonBody));
                this.enriquecimentoService.save(e);
                return;
            }
            e.setStatusAnalise(StatusProcessoEnum.PROCESSANDO);
            this.enriquecimentoService.save(e);
            List itens = this.enriquecimentoItensService.get(e);
            HashSet<String> cnpjs = new HashSet<String>();
            for (EnriquecimentoItens i : itens) {
                cnpjs.add(i.getCpfCnpj());
            }
            this.dataStoneProcessaService.processar(e.getDataStoneId());
            if (!e.getJustConsult().booleanValue()) {
                String url = this.dataStoneService.processarLote(e.getEstruturaUsuario(), cnpjs, e.getNomeArquivo(), e, e.getConsultaWhats());
                e.setUrlArquivo(url);
            }
            e.setStatusAnalise(StatusProcessoEnum.FINALIZADO);
            this.enriquecimentoService.save(e);
        }
        catch (Exception ex) {
            e.setStatusAnalise(StatusProcessoEnum.FINALIZADO_COM_ERRO);
            e.setObservacao(ex.getMessage());
            this.enriquecimentoService.save(e);
        }
    }
}

